package com.bizunited.platform.user.service.feign.service.internal;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.user.common.service.UserMappingService;
import com.bizunited.platform.user.common.vo.UserMappingVo;
import com.bizunited.platform.user.service.feign.UserMappingFeignClient;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 用户关联配置服务实现类
 * TODO 所有public服务的入参均为校验
 * @Author: Paul Chan
 * @Date: 2019-11-25 15:57
 */
@Service("UserMappingServiceImpl")
public class UserMappingServiceImpl implements UserMappingService {

  @Autowired
  private UserMappingFeignClient userMappingFeignClient;

  @Override
  public UserMappingVo init() {
    throw new IllegalArgumentException("此服务暂不对外开放");
  }

  /**
   * 更新用户关联设置
   * @param mappingVo
   * @return
   */
  @Override
  public UserMappingVo update(UserMappingVo mappingVo) {
    ResponseModel response = userMappingFeignClient.update(mappingVo);
    Validate.isTrue(response.getSuccess(), response.getErrorMsg());
    return JsonUtils.convert(response.getData(), UserMappingVo.class);
  }

  /**
   * 获取用户关联设置
   * @return
   */
  @Override
  public UserMappingVo findOne() {
    ResponseModel response = userMappingFeignClient.findOne();
    return JsonUtils.convert(response.getSuccessDataOrElse(Lists.newArrayList()), UserMappingVo.class);
  }

}
