/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.feign;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.interceptor.FeignRequestInterceptor;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import com.bizunited.platform.user.service.feign.fallback.OrganizationFeignClientFallback;
import java.security.Principal;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(qualifier="OrganizationFeignClient", name="${user.application.name}", path="/v1/nebula/orgs", fallback=OrganizationFeignClientFallback.class, configuration={FeignRequestInterceptor.class})
public interface OrganizationFeignClient {
    @PostMapping(value={""})
    public ResponseModel create(@RequestBody OrganizationVo var1);

    @PatchMapping(value={"/update"})
    public ResponseModel update(@RequestBody OrganizationVo var1);

    @PatchMapping(value={"/updateStatus/{orgId}"})
    public ResponseModel updateStatus(@PathVariable(value="orgId") String var1);

    @PatchMapping(value={"/disables/{orgIds}"})
    public ResponseModel disables(@PathVariable(value="orgIds") String[] var1);

    @PatchMapping(value={"/enables/{orgIds}"})
    public ResponseModel enables(@PathVariable(value="orgIds") String[] var1);

    @PatchMapping(value={"/bindParent"})
    public ResponseModel bindParent(@RequestParam(name="currentOrgId") String var1, @RequestParam(name="parentOrgId") String var2);

    @PatchMapping(value={"/unbindParent"})
    public ResponseModel unbindParent(@RequestParam(name="currentOrgId") String var1);

    @PatchMapping(value={"/reBindParent"})
    public ResponseModel reBindParent(@RequestParam(name="currentOrgId") String var1, @RequestParam(name="parentOrgId") String var2);

    @PatchMapping(value={"/bindUsers"})
    public ResponseModel bindUsers(@RequestParam(name="currentOrgId") String var1, @RequestParam(name="userIds") String[] var2);

    @PatchMapping(value={"/rebindUsers"})
    public ResponseModel rebindUsers(@RequestParam(name="currentOrgId") String var1, @RequestParam(name="userIds") String[] var2);

    @PatchMapping(value={"/unbindUsers"})
    public ResponseModel unbindUsers(@RequestParam(name="currentOrgId") String var1, @RequestParam(name="userId") String[] var2);

    @GetMapping(value={"/findByNullParent"})
    public ResponseModel findByNullParent();

    @GetMapping(value={"/findByParent"})
    public ResponseModel findByParent(@RequestParam(name="parentId") String var1);

    @GetMapping(value={"/findByParentAndFilterConditions"})
    public ResponseModel findByParentAndFilterConditions(@RequestParam(name="parentId") String var1, @RequestParam(name="id") String var2, @RequestParam(name="code") String var3, @RequestParam(name="orgName") String var4);

    @GetMapping(value={"/findByNullParentAndStatus"})
    public ResponseModel findByNullParentAndStatus(@RequestParam(name="status") Integer var1);

    @GetMapping(value={"/findByParentAndStatus"})
    public ResponseModel findByParentAndStatus(@RequestParam(name="parentId") String var1, @RequestParam(name="status") Integer var2);

    @GetMapping(value={"/findByOrgName"})
    public ResponseModel findByOrgName(@RequestParam(name="orgName") String var1);

    @GetMapping(value={"/findDetailsById"})
    public ResponseModel findDetailsById(@RequestParam(name="id") String var1);

    @GetMapping(value={"/findUnbindOrgById"})
    public ResponseModel findUnbindOrgById(@RequestParam(name="currentOrgId") String var1);

    @GetMapping(value={"/findAll"})
    public ResponseModel findAll();

    @GetMapping(value={"/findOrgByUserId"})
    public ResponseModel findOrgByUserId(@RequestParam(value="userId") String var1);

    @PostMapping(value={"/findByIds"})
    public ResponseModel findByIds(@RequestBody List<String> var1);

    @GetMapping(value={"/findById"})
    public ResponseModel findById(@RequestParam(value="id") String var1);

    @GetMapping(value={"/findByOrgNameLike"})
    public ResponseModel findByOrgNameLike(@RequestParam(name="orgName") String var1);

    @GetMapping(value={"findByCode"})
    public ResponseModel findByCode(@RequestParam(name="code") String var1);

    @GetMapping(value={"/findByUserId"})
    public ResponseModel findByUserId(@RequestParam(name="userId") String var1);

    @GetMapping(value={"/unbindUser"})
    public ResponseModel unbindUser(@RequestParam(name="userId") String var1);

    @GetMapping(value={"/childId"})
    public ResponseModel findByChild(@RequestParam(name="childId") String var1);

    @GetMapping(value={"findMainOrgByUserId"})
    public ResponseModel findMainOrgByUserId(@RequestParam(value="userId") String var1);

    @PatchMapping(value={"updateUserMainOrg"})
    public ResponseModel updateUserMainOrg(@RequestParam(value="userId") String var1, @RequestParam(value="orgId") String var2);

    @GetMapping(value={"findTreeByConditions"})
    public ResponseModel findTreeByConditions(@RequestParam(value="id", required=false) String var1, @RequestParam(value="code", required=false) String var2, @RequestParam(value="orgName", required=false) String var3, @RequestParam(value="tstatus", required=false) Integer var4);

    @GetMapping(value={"findByPrincipal"})
    public ResponseModel findByPrincipal(@RequestParam(value="type") Integer var1, @RequestParam(value="principal") Principal var2);

    @GetMapping(value={"findByTypeAndLevel"})
    public ResponseModel findByTypeAndLevel(@RequestParam(value="type") Integer var1, @RequestParam(value="account") String var2, @RequestParam(value="level") Integer var3);

    @PatchMapping(value={"/mergeOrgById"})
    public ResponseModel mergeOrgById(@RequestParam(name="currentOrgId") String var1, @RequestParam(name="id") String var2);

    @PatchMapping(value={"bindRegions"})
    public ResponseModel bindRegions(@RequestParam(value="orgId") String var1, @RequestParam(value="regionIds") String[] var2);

    @PatchMapping(value={"rebindRegions"})
    public ResponseModel rebindRegions(@RequestParam(value="orgId") String var1, @RequestParam(value="regionIds") String[] var2);

    @PatchMapping(value={"unbindRegions"})
    public ResponseModel unbindRegions(@RequestParam(value="orgId") String var1, @RequestParam(value="regionIds") String[] var2);

    @GetMapping(value={"/findChildrenByIdsOrCodes"})
    public ResponseModel findChildrenByIdsOrCodes(@RequestParam(value="ids") String[] var1, @RequestParam(value="codes") String[] var2);

    @GetMapping(value={"findByIdStruSelfAndDescendant"})
    public ResponseModel findByIdStruSelfAndDescendant(@RequestParam(value="id") String var1);

    @GetMapping(value={"findByLevel"})
    public ResponseModel findByLevel(@RequestParam(value="level") Integer var1);
}

