/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.feign;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.interceptor.FeignRequestInterceptor;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.service.feign.fallback.PositionFeignClientFallback;
import java.security.Principal;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(qualifier="PositionFeignClient", name="${user.application.name}", path="/v1/nebula/position", fallback=PositionFeignClientFallback.class, configuration={FeignRequestInterceptor.class})
public interface PositionFeignClient {
    @GetMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(@RequestParam(value="nameEqual") String var1, @RequestParam(value="tstatus") Integer var2, @RequestParam(value="flag") Integer var3, @RequestParam(value="ids") List<String> var4, @RequestParam(value="codes") List<String> var5, @RequestParam(value="name") String var6, @RequestParam(value="userName") String var7, @RequestParam(value="positionLevel") String var8, @RequestParam(value="orgName") String var9, @RequestParam(value="page") int var10, @RequestParam(value="size") int var11);

    @GetMapping(value={"/find/{positionId}"})
    public ResponseModel findDetailsById(@PathVariable(value="positionId") String var1);

    @PostMapping(value={""})
    public ResponseModel create(@RequestBody PositionVo var1);

    @PatchMapping(value={"update"})
    public ResponseModel update(@RequestBody PositionVo var1);

    @PatchMapping(value={"updateStatus/{positionId}"})
    public ResponseModel updateStatus(@PathVariable(value="positionId") String var1);

    @PatchMapping(value={"/bindOrg"})
    public ResponseModel bindOrg(@RequestParam(name="positionId") String var1, @RequestParam(name="orgId") String var2);

    @PatchMapping(value={"/unbindOrg"})
    public ResponseModel unbindOrg(@RequestParam(name="positionId") String var1);

    @PatchMapping(value={"/reBindOrg"})
    public ResponseModel reBindOrg(@RequestParam(name="orgId") String var1, @RequestParam(name="positionId") String var2);

    @PatchMapping(value={"/bindUsersAndPosition"})
    public ResponseModel bindUsers(@RequestParam(name="positionId") String var1, @RequestParam(name="userIds") String[] var2);

    @PatchMapping(value={"/unbindUsersAndPosition"})
    public ResponseModel unbindUsersAndPosition(@RequestParam(name="positionId") String var1, @RequestParam(name="userIds") String[] var2);

    @GetMapping(value={"/findByUserId"})
    public ResponseModel findByUserId(@RequestParam(value="userId") String var1);

    @GetMapping(value={"/findByUserAccount"})
    public ResponseModel findByUserAccount(@RequestParam(value="userAccount") String var1);

    @PostMapping(value={"/findByIds"})
    public ResponseModel findByIds(@RequestBody List<String> var1);

    @GetMapping(value={"findByCode"})
    public ResponseModel findByCode(@RequestParam(value="code") String var1);

    @PostMapping(value={"changePosition"})
    public ResponseModel changePosition(@RequestParam(name="positionId") String var1, @RequestParam(name="userId") String var2);

    @GetMapping(value={"/findMainPositionByUserId"})
    public ResponseModel findMainPositionByUserId(@RequestParam(name="userId") String var1);

    @PatchMapping(value={"/rebindUsers"})
    public ResponseModel rebindUsers(@RequestParam(name="positionId") String var1, @RequestParam(name="userIds") String[] var2);

    @GetMapping(value={"/findAll"})
    public ResponseModel findAll();

    @GetMapping(value={"findByStatus"})
    public ResponseModel findByStatus(@RequestParam(name="status") Integer var1);

    @GetMapping(value={"findByPrincipal"})
    public ResponseModel findByPrincipal(@RequestParam(value="type") Integer var1, @RequestParam(value="principal") Principal var2);

    @GetMapping(value={"findByTypeAndLevel"})
    public ResponseModel findByTypeAndLevel(@RequestParam(value="type") Integer var1, @RequestParam(value="principal") Principal var2, @RequestParam(value="level") Integer var3);

    @GetMapping(value={"createByPositionLevelCode"})
    public ResponseModel createByPositionLevelCode(@RequestParam(value="levelCode") String var1);

    @GetMapping(value={"findDetailsByOrgCode"})
    public ResponseModel findDetailsByOrgCode(@RequestParam(value="orgCode") String var1);

    @GetMapping(value={"findDetailsByCode"})
    public ResponseModel findDetailsByCode(@RequestParam(value="code") String var1);

    @GetMapping(value={"findPositionDetailByCode"})
    public ResponseModel findPositionDetailByCode(@RequestParam(value="code") String var1);

    @GetMapping(value={"findByPositionLevelIds"})
    public ResponseModel findByPositionLevelIds(@Param(value="positionLevelIds") String[] var1);

    @PostMapping(value={"disableByIds"})
    public ResponseModel disableByIds(@Param(value="ids") String[] var1);

    @PostMapping(value={"enableByIds"})
    public ResponseModel enableByIds(@Param(value="ids") String[] var1);

    @PatchMapping(value={"reBindOrgCode"})
    public ResponseModel reBindOrgCode(@RequestParam(value="codes") String[] var1, @RequestParam(value="orgCode") String var2);

    @GetMapping(value={"findByPositionLevelAndConditions"})
    public ResponseModel findByPositionLevelAndConditions(@RequestParam(value="name") String var1, @RequestParam(value="orgName") String var2, @RequestParam(value="userName") String var3, @RequestParam(value="positionLevel") String var4, @RequestParam(value="page") int var5, @RequestParam(value="size") int var6);

    @GetMapping(value={"findByUserIdStrDescendant"})
    public ResponseModel findByUserIdStruDescendant(@RequestParam(value="userId") String var1);

    @PatchMapping(value={"bindParent"})
    public ResponseModel bindParent(@RequestParam(value="id") String var1, @RequestParam(value="parentId") String var2);
}

