/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.feign;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.interceptor.FeignRequestInterceptor;
import com.bizunited.platform.user.common.vo.UserGroupVo;
import com.bizunited.platform.user.service.feign.fallback.UserGroupFeignClientFallback;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(qualifier="UserGroupFeignClient", name="${user.application.name}", path="/v1/nebula/userGroups", fallback=UserGroupFeignClientFallback.class, configuration={FeignRequestInterceptor.class})
public interface UserGroupFeignClient {
    @GetMapping(value={"/findByCondition"})
    public ResponseModel findByCondition(@RequestParam(required=false, name="groupName") String var1, @RequestParam(required=false, name="groupCode") String var2, @RequestParam(required=false, name="status") Integer var3, @RequestParam(value="page") Integer var4, @RequestParam(value="size") Integer var5);

    @PostMapping(value={""})
    public ResponseModel create(@RequestBody UserGroupVo var1);

    @PatchMapping(value={"/update"})
    public ResponseModel update(@RequestBody UserGroupVo var1);

    @PatchMapping(value={"/updateStatus/{groupId}"})
    public ResponseModel updateStatus(@PathVariable(value="groupId") String var1);

    @PatchMapping(value={"/bindUser"})
    public ResponseModel bindUser(@RequestParam(value="groupId") String var1, @RequestParam(value="userIds") String[] var2);

    @PatchMapping(value={"/unBindUser"})
    public ResponseModel unBindUser(@RequestParam(value="groupId") String var1, @RequestParam(value="userIds") String[] var2);

    @PatchMapping(value={"/bindRole"})
    public ResponseModel bindRole(@RequestParam(value="groupId") String var1, @RequestParam(value="roleIds") String[] var2);

    @PatchMapping(value={"/unBindRole"})
    public ResponseModel unBindRole(@RequestParam(value="groupId") String var1, @RequestParam(value="roleIds") String[] var2);

    @GetMapping(value={"/findDetailsById"})
    public ResponseModel findDetailsById(@RequestParam(value="id") String var1);

    @GetMapping(value={"/findByIds"})
    public ResponseModel findByIds(@RequestBody List<String> var1);

    @GetMapping(value={"findByGroupName"})
    public ResponseModel findByGroupName(@RequestParam(name="groupName") String var1);

    @GetMapping(value={"findAll"})
    public ResponseModel findAll();

    @GetMapping(value={"findByUserId"})
    public ResponseModel findByUserId(@RequestParam(name="userId") String var1);

    @GetMapping(value={"findByCode"})
    public ResponseModel findByCode(@RequestParam(name="groupCode") String var1);

    @PatchMapping(value={"/reBindUser"})
    public ResponseModel reBindUser(@RequestParam(name="groupId") String var1, @RequestParam(name="userIds") String[] var2);

    @GetMapping(value={"/findByGroupCodes"})
    public ResponseModel findByGroupCodes(@RequestParam(name="groupCodes") List<String> var1);
}

