/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.feign.service.internal;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.user.common.enums.RegionLevelEnum;
import com.bizunited.platform.user.common.service.region.AdministrativeRegionService;
import com.bizunited.platform.user.common.vo.AdministrativeRegionVo;
import com.bizunited.platform.user.service.feign.AdministrativeRegionFeignClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="AdministrativeRegionServiceImpl")
public class AdministrativeRegionServiceImpl
implements AdministrativeRegionService {
    @Autowired
    private AdministrativeRegionFeignClient administrativeRegionFeignClient;

    public AdministrativeRegionVo create(AdministrativeRegionVo region) {
        Validate.notNull((Object)region, (String)"\u884c\u653f\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ResponseModel responseModel = this.administrativeRegionFeignClient.create(region);
        Validate.isTrue((responseModel.getSuccess() != null && responseModel.getSuccess() != false ? 1 : 0) != 0, (String)responseModel.getErrorMsg(), (Object[])new Object[0]);
        return (AdministrativeRegionVo)JsonUtils.convert((Object)responseModel.getData(), AdministrativeRegionVo.class);
    }

    @NebulaServiceMethod(name="AdministrativeRegionService.findDetailsById", desc="\u6839\u636eID\u67e5\u8be2\u660e\u7ec6", scope=NebulaServiceMethod.ScopeType.READ, returnPropertiesFilterB="..children")
    public AdministrativeRegionVo findDetailsById(@ServiceMethodParam(name="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ResponseModel response = this.administrativeRegionFeignClient.findDetailsById(id);
        return (AdministrativeRegionVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), AdministrativeRegionVo.class);
    }

    public AdministrativeRegionVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ResponseModel response = this.administrativeRegionFeignClient.findById(id);
        return (AdministrativeRegionVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), AdministrativeRegionVo.class);
    }

    public List<AdministrativeRegionVo> findByConditions(Map<String, Object> conditions) {
        String regionName = (String)conditions.get("regionName");
        String regionCode = (String)conditions.get("regionCode");
        String longitude = (String)conditions.get("longitude");
        String latitude = (String)conditions.get("latitude");
        ResponseModel response = this.administrativeRegionFeignClient.findByConditions(regionName, regionCode, longitude, latitude);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<AdministrativeRegionVo>>(){});
    }

    @NebulaServiceMethod(name="AdministrativeRegionService.findByConditions", desc="\u591a\u6761\u4ef6\u67e5\u8be2\uff0c\u8fd4\u56de\u6811\u7ed3\u6784", returnPropertiesFilterB="..parent", scope=NebulaServiceMethod.ScopeType.READ)
    public List<AdministrativeRegionVo> findByConditions(InvokeParams invokeParams) {
        invokeParams = (InvokeParams)ObjectUtils.defaultIfNull((Object)invokeParams, (Object)new InvokeParams());
        return this.findByConditions(invokeParams.getInvokeParams());
    }

    @NebulaServiceMethod(name="AdministrativeRegionService.findByParentIdOrConditions", desc="\u6839\u636e\u4e0a\u7ea7\u7ec4\u7ec7ID\u6216\u591a\u6761\u4ef6\u67e5\u8be2", returnPropertiesFilterB="..parent", scope=NebulaServiceMethod.ScopeType.READ)
    public List<AdministrativeRegionVo> findByParentIdOrConditions(InvokeParams invokeParams) {
        invokeParams = (InvokeParams)ObjectUtils.defaultIfNull((Object)invokeParams, (Object)new InvokeParams());
        Map params = invokeParams.getInvokeParams();
        params.entrySet().removeIf(entry -> entry.getValue() == null || CharSequence.class.isAssignableFrom(entry.getValue().getClass()) && StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue())));
        String parentId = (String)params.get("parentId");
        params.remove("parentId");
        if (CollectionUtils.isEmpty((Map)params)) {
            return this.findByParent(parentId);
        }
        return this.findByConditions(params);
    }

    public Set<AdministrativeRegionVo> findByRegionLevel(Integer regionLevel) {
        if (regionLevel == null) {
            return Sets.newHashSet();
        }
        ResponseModel response = this.administrativeRegionFeignClient.findByRegionLevel(regionLevel);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<AdministrativeRegionVo>>(){});
    }

    @NebulaServiceMethod(name="AdministrativeRegionService.findByOrgId", desc="\u6839\u636e\u7ec4\u7ec7ID\u67e5\u8be2\u5173\u8054\u533a\u57df", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.READ)
    public List<AdministrativeRegionVo> findByOrgId(String orgId) {
        if (StringUtils.isBlank((CharSequence)orgId)) {
            return Lists.newArrayList();
        }
        ResponseModel response = this.administrativeRegionFeignClient.findByOrgId(orgId);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<AdministrativeRegionVo>>(){});
    }

    @NebulaServiceMethod(name="AdministrativeRegionService.findByParent", desc="\u6839\u636e\u7236ID\u67e5\u8be2\u5b50\u533a\u57df", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.READ)
    public List<AdministrativeRegionVo> findByParent(@ServiceMethodParam(name="parentId") String parentId) {
        ResponseModel response = this.administrativeRegionFeignClient.findByParent(parentId);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<AdministrativeRegionVo>>(){});
    }

    @NebulaServiceMethod(name="AdministrativeRegionService.findByCode", desc="\u6839\u636e\u7f16\u7801\u67e5\u8be2\u884c\u653f\u533a\u57df", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.READ)
    public AdministrativeRegionVo findByCode(@ServiceMethodParam(name="code") String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        ResponseModel response = this.administrativeRegionFeignClient.findByCode(code);
        return (AdministrativeRegionVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), AdministrativeRegionVo.class);
    }

    public Integer updateOrgMappingLevel(Integer level) {
        Validate.notNull((Object)level, (String)"\u5173\u8054\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RegionLevelEnum regionLevelEnum = RegionLevelEnum.valueOfLevel((Integer)level);
        Validate.notNull((Object)regionLevelEnum, (String)"\u4e0d\u652f\u6301\u7684\u533a\u57df\u5c42\u7ea7", (Object[])new Object[0]);
        ResponseModel responseModel = this.administrativeRegionFeignClient.updateOrgMappingLevel(level);
        Validate.isTrue((boolean)responseModel.getSuccess(), (String)"\u66f4\u65b0\u5173\u8054\u533a\u57df\u5c42\u7ea7\u5931\u8d25", (Object[])new Object[0]);
        return (Integer)responseModel.getData();
    }

    public Integer findOrgMappingLevel() {
        ResponseModel responseModel = this.administrativeRegionFeignClient.findOrgMappingLevel();
        return (Integer)responseModel.getSuccessDataOrElse((Object)RegionLevelEnum.AREA.getLevel());
    }
}

