/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.feign.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import com.bizunited.platform.user.service.feign.OrganizationFeignClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public class OrganizationServiceImpl
implements OrganizationService {
    @Autowired
    private OrganizationFeignClient organizationFeignClient;

    @NebulaServiceMethod(name="OrganizationService.create", desc="\u7ec4\u7ec7\u673a\u6784\u521b\u5efa\u670d\u52a1\u6e90", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.WRITE)
    public OrganizationVo create(OrganizationVo organization) {
        Validate.notNull((Object)organization, (String)"\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)organization.getId()), (String)"\u6dfb\u52a0\u7ec4\u7ec7\u673a\u6784\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165\u7ec4\u7ec7\u673a\u6784id,\u8bf7\u91cd\u65b0\u6dfb\u52a0!!", (Object[])new Object[0]);
        String orgName = organization.getOrgName();
        Validate.notBlank((CharSequence)orgName, (String)"\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)organization.getDescription(), (String)"\u7ec4\u7ec7\u673a\u6784\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)organization.getType(), (String)"\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String code = organization.getCode();
        Validate.notNull((Object)code, (String)"\u7ec4\u7ec7\u673a\u6784\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.organizationFeignClient.create(organization);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (OrganizationVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), OrganizationVo.class);
    }

    @NebulaServiceMethod(name="OrganizationService.update", desc="\u7ec4\u7ec7\u673a\u6784\u66f4\u65b0\u670d\u52a1\u6e90", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.WRITE)
    public OrganizationVo update(OrganizationVo organization) {
        Validate.notNull((Object)organization, (String)"\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)organization.getId(), (String)"\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u6dfb\u52a0!!", (Object[])new Object[0]);
        String orgName = organization.getOrgName();
        Validate.notBlank((CharSequence)orgName, (String)"\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)organization.getDescription(), (String)"\u7ec4\u7ec7\u673a\u6784\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ResponseModel response = this.organizationFeignClient.update(organization);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (OrganizationVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), OrganizationVo.class);
    }

    public OrganizationVo updateStatus(String orgId) {
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ResponseModel response = this.organizationFeignClient.updateStatus(orgId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (OrganizationVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), OrganizationVo.class);
    }

    public Set<OrganizationVo> enables(String[] orgIds) {
        Validate.notEmpty((Object[])orgIds, (String)"\u7ec4\u7ec7\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ResponseModel response = this.organizationFeignClient.enables(orgIds);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<OrganizationVo>>(){});
    }

    public Set<OrganizationVo> disables(String[] orgIds) {
        Validate.notEmpty((Object[])orgIds, (String)"\u7ec4\u7ec7\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ResponseModel response = this.organizationFeignClient.disables(orgIds);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<OrganizationVo>>(){});
    }

    public void bindParent(String currentOrgId, String parentOrgId) {
        Validate.notBlank((CharSequence)currentOrgId, (String)"\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)parentOrgId, (String)"\u6307\u5b9a\u7684\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.equals((CharSequence)currentOrgId, (CharSequence)parentOrgId) ? 1 : 0) != 0, (String)"\u7ed1\u5b9a\u7ec4\u7ec7\u673a\u6784\u65f6\uff0c\u4e0d\u80fd\u81ea\u5df1\u7ed1\u5b9a\u81ea\u5df1!!", (Object[])new Object[0]);
        ResponseModel response = this.organizationFeignClient.bindParent(currentOrgId, parentOrgId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public void unbindParent(String currentOrgId) {
        Validate.notBlank((CharSequence)currentOrgId, (String)"\u8fdb\u884c\u7ed1\u5b9a\u7ed3\u6784\u6d88\u9664\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f!!", (Object[])new Object[0]);
        ResponseModel response = this.organizationFeignClient.unbindParent(currentOrgId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public void rebindParent(String currentOrgId, String parentOrgId) {
        ResponseModel response = this.organizationFeignClient.reBindParent(currentOrgId, parentOrgId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public void bindUsers(String currentOrgId, String[] userIds) {
        Validate.notBlank((CharSequence)currentOrgId, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((userIds != null && userIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u7ed1\u5b9a\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u4eba\u5458\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        ResponseModel response = this.organizationFeignClient.bindUsers(currentOrgId, userIds);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public void rebindUsers(String currentOrgId, String[] userIds) {
        Validate.notBlank((CharSequence)currentOrgId, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f!!", (Object[])new Object[0]);
        ResponseModel response = this.organizationFeignClient.rebindUsers(currentOrgId, userIds);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public void unbindUsers(String currentOrgId, String[] userId) {
        Validate.notBlank((CharSequence)currentOrgId, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.notNull((Object)userId, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u4eba\u5458\u4fe1\u606f!!", (Object[])new Object[0]);
        ResponseModel response = this.organizationFeignClient.unbindUsers(currentOrgId, userId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public List<OrganizationVo> findByNullParent() {
        ResponseModel response = this.organizationFeignClient.findByNullParent();
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<OrganizationVo>>(){});
    }

    public List<OrganizationVo> findByParent(String parentId) {
        ResponseModel response = this.organizationFeignClient.findByParent(parentId);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<OrganizationVo>>(){});
    }

    public List<OrganizationVo> findByParentAndFilterConditions(InvokeParams invokeParams) {
        Map parameters = (invokeParams = (InvokeParams)ObjectUtils.defaultIfNull((Object)invokeParams, (Object)new InvokeParams())).getInvokeParams();
        String parentId = parameters.get("parentId") == null ? null : parameters.get("parentId").toString();
        String id = parameters.get("id") == null ? null : parameters.get("id").toString();
        String code = parameters.get("code") == null ? null : parameters.get("code").toString();
        String orgName = parameters.get("orgName") == null ? null : parameters.get("orgName").toString();
        ResponseModel response = this.organizationFeignClient.findByParentAndFilterConditions(parentId, id, code, orgName);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<OrganizationVo>>(){});
    }

    @NebulaServiceMethod(name="OrganizationService.findTreeByConditions", desc="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u6811", returnPropertiesFilter="parent", scope=NebulaServiceMethod.ScopeType.READ)
    public List<OrganizationVo> findTreeByConditions(InvokeParams invokeParams) {
        Map parameters = (invokeParams = (InvokeParams)ObjectUtils.defaultIfNull((Object)invokeParams, (Object)new InvokeParams())).getInvokeParams();
        String id = parameters.get("id") == null ? null : parameters.get("id").toString();
        String code = parameters.get("code") == null ? null : parameters.get("code").toString();
        String orgName = parameters.get("orgName") == null ? null : parameters.get("orgName").toString();
        Integer tstatus = parameters.get("tstatus") == null ? null : (Integer)parameters.get("tstatus");
        ResponseModel response = this.organizationFeignClient.findTreeByConditions(id, code, orgName, tstatus);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<OrganizationVo>>(){});
    }

    @NebulaServiceMethod(name="OrganizationService.findByNullParentAndStatus", desc="\u6839\u636e\u72b6\u6001\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u7684\u6700\u9876\u7ea7\u6570\u636e", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.READ)
    public List<OrganizationVo> findByNullParentAndStatus(@ServiceMethodParam(name="status") Integer status) {
        ResponseModel response = this.organizationFeignClient.findByNullParentAndStatus(status);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<OrganizationVo>>(){});
    }

    @NebulaServiceMethod(name="OrganizationService.findByParentAndStatus", desc="\u6839\u636e\u7236\u7ea7ID\u548c\u72b6\u6001\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u7684\u6700\u9876\u7ea7\u6570\u636e", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.READ)
    public List<OrganizationVo> findByParentAndStatus(@ServiceMethodParam(name="parentId") String parentId, @ServiceMethodParam(name="status") Integer status) {
        ResponseModel response = this.organizationFeignClient.findByParentAndStatus(parentId, status);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<OrganizationVo>>(){});
    }

    public JSONArray findByOrgName(String orgName) {
        ResponseModel response = this.organizationFeignClient.findByOrgName(orgName);
        if (response.getSuccess().booleanValue() && response.getData() != null) {
            return new JSONArray();
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)response.getData()));
    }

    public JSONArray findByUserId(String userId) {
        ResponseModel response = this.organizationFeignClient.findByUserId(userId);
        if (response.getData() == null) {
            return new JSONArray();
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)response.getData()));
    }

    @NebulaServiceMethod(name="OrganizationService.findDetailsById", desc="\u6839\u636e\u7ec4\u7ec7\u673a\u6784ID\u67e5\u8be2\u660e\u7ec6\u670d\u52a1\u6e90", returnPropertiesFilter="parent,child,roles,users,positions", scope=NebulaServiceMethod.ScopeType.READ)
    public OrganizationVo findDetailsById(@ServiceMethodParam(name="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ResponseModel response = this.organizationFeignClient.findDetailsById(id);
        return (OrganizationVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), OrganizationVo.class);
    }

    public Object[] findUnbindOrgById(String orgId) {
        ResponseModel response = this.organizationFeignClient.findUnbindOrgById(orgId);
        return (Object[])JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)new Object[0]), (TypeReference)new TypeReference<Object[]>(){});
    }

    public List<OrganizationVo> findAll() {
        ResponseModel response = this.organizationFeignClient.findAll();
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<OrganizationVo>>(){});
    }

    public OrganizationVo findMainOrgByUserId(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return null;
        }
        ResponseModel response = this.organizationFeignClient.findMainOrgByUserId(userId);
        return (OrganizationVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), OrganizationVo.class);
    }

    public void updateUserMainOrg(String userId, String orgId) {
        Validate.notBlank((CharSequence)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.organizationFeignClient.updateUserMainOrg(userId, orgId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public Set<OrganizationVo> findOrgByUserId(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Sets.newHashSet();
        }
        ResponseModel response = this.organizationFeignClient.findOrgByUserId(userId);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<OrganizationVo>>(){});
    }

    public Set<OrganizationVo> findByIds(List<String> ids) {
        ResponseModel response = this.organizationFeignClient.findByIds(ids);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<OrganizationVo>>(){});
    }

    public OrganizationVo findById(String id) {
        ResponseModel response = this.organizationFeignClient.findById(id);
        return (OrganizationVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), OrganizationVo.class);
    }

    public Set<OrganizationVo> findByOrgNameLike(String orgName) {
        ResponseModel response = this.organizationFeignClient.findByOrgNameLike(orgName);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<OrganizationVo>>(){});
    }

    public OrganizationVo findByCode(String code) {
        ResponseModel response = this.organizationFeignClient.findByCode(code);
        return (OrganizationVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), OrganizationVo.class);
    }

    public OrganizationVo findByChild(String childId) {
        if (StringUtils.isBlank((CharSequence)childId)) {
            return null;
        }
        ResponseModel response = this.organizationFeignClient.findByChild(childId);
        return (OrganizationVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), OrganizationVo.class);
    }

    public Set<OrganizationVo> findByPrincipal(Integer type, Principal principal) {
        Validate.notNull((Object)type, (String)"\u4f20\u5165\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ResponseModel response = this.organizationFeignClient.findByPrincipal(type, principal);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<OrganizationVo>>(){});
    }

    public Set<OrganizationVo> findByTypeAndLevel(Integer type, String account, Integer level) {
        Validate.notNull((Object)type, (String)"\u4f20\u5165\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notNull((Object)account, (String)"\u4f20\u5165\u8d26\u53f7\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notNull((Object)level, (String)"\u4f20\u5165\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ResponseModel response = this.organizationFeignClient.findByTypeAndLevel(type, account, level);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<OrganizationVo>>(){});
    }

    public void mergeOrgById(String id, String currentOrgId) {
        Validate.notBlank((CharSequence)currentOrgId, (String)"\u5408\u5e76\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)id, (String)"\u88ab\u5408\u5e76\u7684\u7ec4\u7ec7\u673a\u6784\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.equals((CharSequence)currentOrgId, (CharSequence)id) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u5408\u5e76\u81ea\u5df1\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        ResponseModel response = this.organizationFeignClient.mergeOrgById(currentOrgId, id);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    @NebulaServiceMethod(name="OrganizationService.bindRegions", desc="\u7ed1\u5b9a\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u7684\u884c\u653f\u533a\u57df", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.WRITE)
    public void bindRegions(@ServiceMethodParam(name="orgId") String orgId, @ServiceMethodParam(name="regionIds") String[] regionIds) {
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Object[])regionIds, (String)"\u884c\u653f\u533a\u57dfID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.organizationFeignClient.bindRegions(orgId, regionIds);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    @NebulaServiceMethod(name="OrganizationService.rebindRegions", desc="\u91cd\u65b0\u7ed1\u5b9a\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u7684\u884c\u653f\u533a\u57df", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.WRITE)
    public void rebindRegions(@ServiceMethodParam(name="orgId") String orgId, @ServiceMethodParam(name="regionIds") String[] regionIds) {
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.organizationFeignClient.rebindRegions(orgId, regionIds);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    @NebulaServiceMethod(name="OrganizationService.unbindRegions", desc="\u89e3\u7ed1\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u7684\u884c\u653f\u533a\u57df", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.WRITE)
    public void unbindRegions(@ServiceMethodParam(name="orgId") String orgId, @ServiceMethodParam(name="regionIds") String[] regionIds) {
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Object[])regionIds, (String)"\u884c\u653f\u533a\u57dfID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.organizationFeignClient.unbindRegions(orgId, regionIds);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public List<OrganizationVo> findChildrenByIdsOrCodes(String[] ids, String[] codes) {
        ResponseModel response = this.organizationFeignClient.findChildrenByIdsOrCodes(ids, codes);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<OrganizationVo>>(){});
    }

    @NebulaServiceMethod(name="OrganizationService.findByIdStruSelfAndDescendant", desc="\u6839\u636eID\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u53ca\u5f53\u524d\u7ec4\u7ec7\u7684\u6240\u6709\u4e0b\u7ea7,\u4ee5\u4e00\u7ef4\u6570\u7ec4\u7684\u683c\u5f0f\u8fd4\u56de\u6570\u636e", returnPropertiesFilter="parent", scope=NebulaServiceMethod.ScopeType.READ)
    public List<OrganizationVo> findByIdStruSelfAndDescendant(@ServiceMethodParam(name="id") String id) {
        ResponseModel response = this.organizationFeignClient.findByIdStruSelfAndDescendant(id);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<OrganizationVo>>(){});
    }

    @NebulaServiceMethod(name="OrganizationService.findByLevel", desc="\u6839\u636e\u7ec4\u7ec7\u5c42\u7ea7\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.READ)
    public List<OrganizationVo> findByLevel(@ServiceMethodParam(name="level") Integer level) {
        if (level == null) {
            return Lists.newArrayList();
        }
        ResponseModel response = this.organizationFeignClient.findByLevel(level);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<OrganizationVo>>(){});
    }

    @NebulaServiceMethod(name="OrganizationService.findParentsByLevel", desc="\u6839\u636e\u5c42\u7ea7\u67e5\u8be2\u4e0a\u7ea7\u7ec4\u7ec7\u673a\u6784", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.READ)
    public List<OrganizationVo> findParentsByLevel(@ServiceMethodParam(name="level") Integer level) {
        if (level == null || level <= 1) {
            return Lists.newArrayList();
        }
        Integer n = level;
        Integer n2 = level = Integer.valueOf(level - 1);
        return this.findByLevel(level);
    }
}

