/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.feign.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.common.util.PageUtils;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.user.common.service.position.PositionLevelEventListener;
import com.bizunited.platform.user.common.service.position.PositionLevelService;
import com.bizunited.platform.user.common.vo.PositionLevelVo;
import com.bizunited.platform.user.service.feign.PositionLevelFeignClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

public class PositionLevelServiceImpl
implements PositionLevelService {
    @Autowired
    private PositionLevelFeignClient positionLevelFeignClient;
    @Autowired(required=false)
    private List<PositionLevelEventListener> positionLevelEventListener;

    public PositionLevelVo create(PositionLevelVo positionLevelVo) {
        Validate.notNull((Object)positionLevelVo, (String)"\u804c\u4f4d\u7ea7\u522b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)positionLevelVo.getId()), (String)"\u6dfb\u52a0\u804c\u4f4d\u7ea7\u522b\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165\u5c97\u4f4d\u804c\u4f4d\u7ea7\u522bID,\u8bf7\u91cd\u65b0\u6dfb\u52a0!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionLevelVo.getName(), (String)"\u804c\u4f4d\u7ea7\u522b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionLevelVo.getCode(), (String)"\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ResponseModel response = this.positionLevelFeignClient.create(positionLevelVo);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        PositionLevelVo dbPositionLevel = (PositionLevelVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), PositionLevelVo.class);
        dbPositionLevel.setRoleCodes(positionLevelVo.getRoleCodes());
        if (CollectionUtils.isEmpty(this.positionLevelEventListener)) {
            for (PositionLevelEventListener eventListener : this.positionLevelEventListener) {
                eventListener.onPositionLevelCreated(dbPositionLevel);
            }
        }
        return dbPositionLevel;
    }

    public PositionLevelVo update(PositionLevelVo positionLevelVo) {
        this.updateValidation(positionLevelVo);
        ResponseModel response = this.positionLevelFeignClient.update(positionLevelVo);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        PositionLevelVo dbPositionLevel = (PositionLevelVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), PositionLevelVo.class);
        dbPositionLevel.setRoleCodes(positionLevelVo.getRoleCodes());
        if (CollectionUtils.isEmpty(this.positionLevelEventListener)) {
            for (PositionLevelEventListener eventListener : this.positionLevelEventListener) {
                eventListener.onPositionLevelUpdated(dbPositionLevel);
            }
        }
        return dbPositionLevel;
    }

    private void updateValidation(PositionLevelVo positionLevelVo) {
        Validate.notNull((Object)positionLevelVo, (String)"\u804c\u4f4d\u7ea7\u522b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.isBlank((CharSequence)positionLevelVo.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u804c\u4f4d\u7ea7\u522b\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u804c\u4f4d\u7ea7\u522bid,\u8bf7\u91cd\u65b0\u4fee\u6539!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionLevelVo.getName(), (String)"\u804c\u4f4d\u7ea7\u522b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
    }

    public void disableByIds(String[] ids) {
        Validate.notEmpty((Object[])ids, (String)"\u804c\u7ea7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.positionLevelFeignClient.disableByIds(ids);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public void enableByIds(String[] positionLevelIds) {
        Validate.notEmpty((Object[])positionLevelIds, (String)"\u804c\u7ea7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.positionLevelFeignClient.enableByIds(positionLevelIds);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    @NebulaServiceMethod(name="PositionLevelService.findByConditions", desc="\u6761\u4ef6\u67e5\u8be2\u804c\u7ea7\u5217\u8868", scope=NebulaServiceMethod.ScopeType.READ, returnPropertiesFilter="")
    public Page<PositionLevelVo> findByConditions(InvokeParams invokeParams, @ServiceMethodParam(name="pageable") Pageable pageable) {
        String code;
        String name = (String)(invokeParams = (InvokeParams)ObjectUtils.defaultIfNull((Object)invokeParams, (Object)new InvokeParams())).getInvokeParam("name");
        ResponseModel response = this.positionLevelFeignClient.findByConditions(name, code = (String)invokeParams.getInvokeParam("code"), pageable.getPageNumber(), pageable.getPageSize());
        if (response == null || response.getData() == null) {
            return Page.empty((Pageable)pageable);
        }
        return PageUtils.convert2Page((JSONObject)JsonUtils.toJSONObject((Object)response), (TypeReference)new TypeReference<List<PositionLevelVo>>(){});
    }

    public PositionLevelVo findByCode(String code) {
        ResponseModel response = this.positionLevelFeignClient.findByCode(code);
        return (PositionLevelVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), PositionLevelVo.class);
    }

    public PositionLevelVo findById(String positionLevelId) {
        ResponseModel response = this.positionLevelFeignClient.findById(positionLevelId);
        return (PositionLevelVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), PositionLevelVo.class);
    }

    public void deleteByIds(String[] ids) {
        Validate.notEmpty((Object[])ids, (String)"\u804c\u7ea7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.positionLevelFeignClient.deleteByIds(ids);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        for (String id : ids) {
            PositionLevelVo positionLevel = this.findById(id);
            Validate.notNull((Object)positionLevel, (String)"\u804c\u4f4d\u7ea7\u522b\u4e0d\u5b58\u5728:%s", (Object[])new Object[]{id});
            this.sendDeleteEvent(positionLevel);
        }
    }

    private void sendDeleteEvent(PositionLevelVo positionLevel) {
        if (CollectionUtils.isEmpty(this.positionLevelEventListener) || positionLevel == null) {
            return;
        }
        this.positionLevelEventListener.forEach(listener -> listener.onPositionLevelDeleted(positionLevel));
    }

    public List<PositionLevelVo> findAll() {
        ResponseModel response = this.positionLevelFeignClient.findAll();
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<PositionLevelVo>>(){});
    }
}

