/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.feign.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.common.util.PageUtils;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.vo.PositionSimpleVo;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.user.service.feign.PositionFeignClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

public class PositionServiceImpl
implements PositionService {
    @Autowired
    private PositionFeignClient positionFeignClient;

    public Page<PositionVo> findByConditions(Map<String, Object> conditions, Pageable pageable) {
        String orgName;
        String positionLevel;
        String userName;
        String name;
        List codes;
        List ids;
        Integer flag;
        Integer tstatus;
        String nameEqual;
        ResponseModel response;
        Object data;
        if (conditions == null) {
            conditions = Maps.newHashMap();
        }
        if ((data = (response = this.positionFeignClient.findByConditions(nameEqual = (String)conditions.get("nameEqual"), tstatus = (Integer)conditions.get("tstatus"), flag = (Integer)conditions.get("flag"), ids = (List)conditions.get("ids"), codes = (List)conditions.get("codes"), name = (String)conditions.get("name"), userName = (String)conditions.get("userName"), positionLevel = (String)conditions.get("positionLevel"), orgName = (String)conditions.get("orgName"), pageable.getPageNumber(), pageable.getPageSize())).getSuccessDataOrElse(null)) == null) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        return PageUtils.convert2Page((JSONObject)JsonUtils.toJSONObject((Object)data), (TypeReference)new TypeReference<List<PositionVo>>(){});
    }

    @NebulaServiceMethod(name="PositionService.findByConditions", desc="\u6761\u4ef6\u67e5\u8be2\u804c\u4f4d\u5217\u8868", scope=NebulaServiceMethod.ScopeType.READ, returnPropertiesFilter="positionLevel,parent,organization")
    public Page<PositionVo> findByConditions(@ServiceMethodParam(name="pageable") Pageable pageable, InvokeParams invokeParams) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        invokeParams = (InvokeParams)ObjectUtils.defaultIfNull((Object)invokeParams, (Object)new InvokeParams());
        Map params = invokeParams.getInvokeParams();
        return this.findByConditions(params, pageable);
    }

    public PositionVo create(PositionVo position) {
        Validate.notNull((Object)position, (String)"\u5c97\u4f4d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)position.getId()), (String)"\u6dfb\u52a0\u5c97\u4f4d\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165\u5c97\u4f4did,\u8bf7\u91cd\u65b0\u6dfb\u52a0!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)position.getName(), (String)"\u5c97\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)position.getCode(), (String)"\u5c97\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.create(position);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (PositionVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), PositionVo.class);
    }

    public PositionVo update(PositionVo position) {
        Validate.notNull((Object)position, (String)"\u5c97\u4f4d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.isBlank((CharSequence)position.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u5c97\u4f4d\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u5c97\u4f4did,\u8bf7\u91cd\u65b0\u4fee\u6539!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)position.getName(), (String)"\u5c97\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.update(position);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (PositionVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), PositionVo.class);
    }

    public PositionVo updateStatus(String positionId) {
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4did\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.updateStatus(positionId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (PositionVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), PositionVo.class);
    }

    public void bindOrg(String orgId, String positionId) {
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.bindOrg(orgId, positionId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public void unbindOrg(String positionId) {
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.unbindOrg(positionId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public void reBindOrg(String orgId, String positionId) {
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.reBindOrg(orgId, positionId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public void bindUsersAndPosition(List<String> userIds, String positionId) {
        Validate.isTrue((!CollectionUtils.isEmpty(userIds) ? 1 : 0) != 0, (String)"\u7528\u6237ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        String[] array = new String[userIds.size()];
        userIds.toArray(array);
        ResponseModel response = this.positionFeignClient.bindUsers(positionId, array);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public void unbindUsersAndPosition(List<String> userIds, String positionId) {
        Validate.isTrue((!CollectionUtils.isEmpty(userIds) ? 1 : 0) != 0, (String)"\u7528\u6237ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        String[] array = new String[userIds.size()];
        userIds.toArray(array);
        ResponseModel response = this.positionFeignClient.unbindUsersAndPosition(positionId, array);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public PositionVo findDetailsById(String id) {
        ResponseModel response = this.positionFeignClient.findDetailsById(id);
        return (PositionVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), PositionVo.class);
    }

    public List<PositionVo> findByUserId(String userId) {
        Validate.notBlank((CharSequence)userId, (String)"\u4f20\u5165\u7684\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.findByUserId(userId);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<PositionVo>>(){});
    }

    public List<PositionVo> findByUserAccount(String userAccount) {
        Validate.notBlank((CharSequence)userAccount, (String)"\u4f20\u5165\u7684\u7528\u6237Account\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.findByUserAccount(userAccount);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<PositionVo>>(){});
    }

    public Set<PositionVo> findByIds(List<String> ids) {
        ResponseModel response = this.positionFeignClient.findByIds(ids);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<PositionVo>>(){});
    }

    public PositionVo findByCode(String code) {
        ResponseModel response = this.positionFeignClient.findByCode(code);
        return (PositionVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), PositionVo.class);
    }

    public UserVo changePosition(String positionId, String userId) {
        Validate.notBlank((CharSequence)positionId, (String)"\u5207\u6362\u5c97\u4f4did\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)userId, (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.changePosition(positionId, userId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (UserVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), UserVo.class);
    }

    public PositionVo findMainPositionByUserId(String userId) {
        Validate.notBlank((CharSequence)userId, (String)"\u4f20\u5165\u7684\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.findMainPositionByUserId(userId);
        return (PositionVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), PositionVo.class);
    }

    public void rebindUsers(String[] userIds, String positionId) {
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.rebindUsers(positionId, userIds);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public List<PositionVo> findAll() {
        ResponseModel response = this.positionFeignClient.findAll();
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<PositionVo>>(){});
    }

    public List<PositionVo> findByStatus(Integer status) {
        Validate.notNull((Object)status, (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.findByStatus(status);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<PositionVo>>(){});
    }

    public Set<PositionVo> findByPrincipal(Integer type, Principal principal) {
        Validate.notNull((Object)type, (String)"\u4f20\u5165\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.findByPrincipal(type, principal);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<PositionVo>>(){});
    }

    public Set<PositionVo> findByTypeAndLevel(Integer type, Principal principal, Integer level) {
        Validate.notNull((Object)type, (String)"\u4f20\u5165\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notNull((Object)level, (String)"\u4f20\u5165\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.findByTypeAndLevel(type, principal, level);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<PositionVo>>(){});
    }

    public PositionVo createByPositionLevelCode(String levelCode) {
        Validate.notNull((Object)levelCode, (String)"\u4f20\u5165\u5c42\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.createByPositionLevelCode(levelCode);
        return (PositionVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), PositionVo.class);
    }

    @NebulaServiceMethod(name="PositionService.findDetailsByOrgCode", desc="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u76f8\u5173\u4fe1\u606f\uff08\u5305\u62ec\u7ec4\u7ec7\uff0c\u804c\u7ea7\uff0c\u7528\u6237\uff0c\u4e0b\u7ea7\u804c\u4f4d\uff09", scope=NebulaServiceMethod.ScopeType.READ, returnPropertiesFilter="positionLevel,users,organization,children")
    public List<PositionVo> findDetailsByOrgCode(String orgCode) {
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            return Lists.newArrayList();
        }
        ResponseModel response = this.positionFeignClient.findDetailsByOrgCode(orgCode);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<PositionVo>>(){});
    }

    public List<PositionVo> findDetailsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return Lists.newArrayList();
        }
        ResponseModel response = this.positionFeignClient.findDetailsByCode(code);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<PositionVo>>(){});
    }

    public PositionVo findPositionDetailByCode(String code) {
        ResponseModel response = this.positionFeignClient.findPositionDetailByCode(code);
        return (PositionVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), PositionVo.class);
    }

    public Set<PositionVo> findByPositionLevelIds(String[] positionLevelIds) {
        ResponseModel response = this.positionFeignClient.findByPositionLevelIds(positionLevelIds);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<PositionVo>>(){});
    }

    public void disableByIds(String[] ids) {
        Validate.notEmpty((Object[])ids, (String)"\u804c\u4f4did\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.disableByIds(ids);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public void enableByIds(String[] ids) {
        Validate.notEmpty((Object[])ids, (String)"\u804c\u4f4did\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.enableByIds(ids);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public void reBindOrgCode(String[] codes, String orgCode) {
        Validate.notEmpty((Object[])codes, (String)"\u5c97\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orgCode, (String)"\u7ec4\u7ec7\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.reBindOrgCode(codes, orgCode);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public Page<PositionSimpleVo> findByPositionLevelAndConditions(Pageable pageable, Map<String, Object> conditions) {
        if (conditions == null) {
            conditions = Maps.newHashMap();
        }
        String name = (String)conditions.get("name");
        String orgName = (String)conditions.get("orgName");
        String userName = (String)conditions.get("userName");
        String positionLevel = (String)conditions.get("positionLevel");
        ResponseModel response = this.positionFeignClient.findByPositionLevelAndConditions(name, orgName, userName, positionLevel, pageable.getPageNumber(), pageable.getPageSize());
        return (Page)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), (TypeReference)new TypeReference<Page<PositionSimpleVo>>(){});
    }

    public List<PositionVo> findByUserIdStruDescendant(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Lists.newArrayList();
        }
        ResponseModel response = this.positionFeignClient.findByUserIdStruDescendant(userId);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<PositionVo>>(){});
    }

    public PositionVo bindParent(String id, String parentId) {
        Validate.notBlank((CharSequence)id, (String)"\u5f53\u524d\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)parentId, (String)"\u7236\u7ea7\u804c\u4f4did\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.positionFeignClient.bindParent(id, parentId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (PositionVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), PositionVo.class);
    }

    public void unbindParent(String id) {
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u8fdc\u7aef\u89e3\u7ed1\u7236\u7ea7\u804c\u4f4d");
    }
}

