/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.feign.service.internal;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.user.common.service.UserExtentFieldService;
import com.bizunited.platform.user.common.vo.UserExtentFieldVo;
import com.bizunited.platform.user.service.feign.UserExtentFieldFeignClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public class UserExtentFieldServiceImpl
implements UserExtentFieldService {
    @Autowired
    private UserExtentFieldFeignClient userExtentFieldFeignClient;

    public List<UserExtentFieldVo> save(List<UserExtentFieldVo> userExtentFieldVos) {
        this.validateUserExtentField(userExtentFieldVos);
        ResponseModel response = this.userExtentFieldFeignClient.save(userExtentFieldVos);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<UserExtentFieldVo>>(){});
    }

    public List<UserExtentFieldVo> findAll() {
        ResponseModel response = this.userExtentFieldFeignClient.findAll();
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<UserExtentFieldVo>>(){});
    }

    private void validateUserExtentField(List<UserExtentFieldVo> userExtentFieldVos) {
        Validate.notEmpty(userExtentFieldVos, (String)"\u914d\u7f6e\u5b57\u6bb5\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        for (UserExtentFieldVo userExtentFieldVo : userExtentFieldVos) {
            Validate.notBlank((CharSequence)userExtentFieldVo.getFieldName(), (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)userExtentFieldVo.getFieldComment(), (String)"\u5b57\u6bb5\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)userExtentFieldVo.getState(), (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)userExtentFieldVo.getShowSearch(), (String)"\u663e\u793a\u6846\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)userExtentFieldVo.getRequired(), (String)"\u662f\u5426\u5fc5\u586b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

