/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.feign.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.common.util.PageUtils;
import com.bizunited.platform.user.common.service.userGroup.UserGroupService;
import com.bizunited.platform.user.common.vo.UserGroupVo;
import com.bizunited.platform.user.service.feign.UserGroupFeignClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class UserGroupServiceImpl
implements UserGroupService {
    @Autowired
    private UserGroupFeignClient userGroupFeignClient;

    public UserGroupVo create(UserGroupVo userGroup) {
        Validate.notNull((Object)userGroup, (String)"\u5206\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)userGroup.getId()), (String)"\u6dfb\u52a0\u5206\u7ec4\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165\u5206\u7ec4id,\u8bf7\u91cd\u65b0\u6dfb\u52a0!!", (Object[])new Object[0]);
        String groupName = userGroup.getGroupName();
        Validate.notBlank((CharSequence)groupName, (String)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)userGroup.getGroupDescription(), (String)"\u5206\u7ec4\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)userGroup.getTstatus(), (String)"\u5206\u7ec4\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ResponseModel response = this.userGroupFeignClient.create(userGroup);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (UserGroupVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), UserGroupVo.class);
    }

    public UserGroupVo update(UserGroupVo userGroup) {
        Validate.notNull((Object)userGroup, (String)"\u5206\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String groupId = userGroup.getId();
        Validate.notNull((Object)groupId, (String)"\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ResponseModel response = this.userGroupFeignClient.update(userGroup);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (UserGroupVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), UserGroupVo.class);
    }

    public UserGroupVo updateStatus(String groupId) {
        Validate.notNull((Object)groupId, (String)"\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ResponseModel response = this.userGroupFeignClient.updateStatus(groupId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (UserGroupVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), UserGroupVo.class);
    }

    public void bindUser(String groupId, String[] userIds) {
        Validate.notNull((Object)groupId, (String)"\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((userIds != null && userIds.length > 0 ? 1 : 0) != 0, (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff08\u81f3\u5c11\u9700\u8981\u4f20\u5165\u4e00\u4e2a\uff09\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ResponseModel response = this.userGroupFeignClient.bindUser(groupId, userIds);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public void unBindUser(String groupId, String[] userIds) {
        Validate.notNull((Object)groupId, (String)"\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((userIds != null && userIds.length > 0 ? 1 : 0) != 0, (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff08\u81f3\u5c11\u9700\u8981\u4f20\u5165\u4e00\u4e2a\uff09\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ResponseModel response = this.userGroupFeignClient.unBindUser(groupId, userIds);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public UserGroupVo findByCode(String groupCode) {
        ResponseModel response = this.userGroupFeignClient.findByCode(groupCode);
        return (UserGroupVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), UserGroupVo.class);
    }

    public Set<UserGroupVo> findByUserId(String userId) {
        ResponseModel response = this.userGroupFeignClient.findByUserId(userId);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<UserGroupVo>>(){});
    }

    public Page<UserGroupVo> findByCondition(String groupName, String groupCode, Integer status, Pageable pageable) {
        ResponseModel response = this.userGroupFeignClient.findByCondition(groupName, groupCode, status, pageable.getPageNumber(), pageable.getPageSize());
        Object data = response.getSuccessDataOrElse(null);
        if (data == null) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        return PageUtils.convert2Page((JSONObject)JsonUtils.toJSONObject((Object)data), (TypeReference)new TypeReference<List<UserGroupVo>>(){});
    }

    public UserGroupVo findDetailsById(String id) {
        ResponseModel response = this.userGroupFeignClient.findDetailsById(id);
        return (UserGroupVo)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<UserGroupVo>(){});
    }

    public Set<UserGroupVo> findByIds(List<String> ids) {
        ResponseModel response = this.userGroupFeignClient.findByIds(ids);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<UserGroupVo>>(){});
    }

    public UserGroupVo findByGroupName(String groupName) {
        ResponseModel response = this.userGroupFeignClient.findByGroupName(groupName);
        return (UserGroupVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), UserGroupVo.class);
    }

    public List<UserGroupVo> findAll() {
        ResponseModel response = this.userGroupFeignClient.findAll();
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<UserGroupVo>>(){});
    }

    public void reBindUser(String groupId, String[] userIds) {
        Validate.notBlank((CharSequence)groupId, (String)"\u7528\u6237\u4e0e\u7528\u6237\u7ec4\u7684\u91cd\u65b0\u7ed1\u5b9a\u65f6\uff0c\u7528\u6237\u7ec4Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.userGroupFeignClient.reBindUser(groupId, userIds);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public List<UserGroupVo> findByGroupCodes(List<String> groupCodes) {
        ResponseModel response = this.userGroupFeignClient.findByGroupCodes(groupCodes);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<UserGroupVo>>(){});
    }
}

