/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.feign.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.common.util.PageUtils;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.user.common.service.user.UserEventListener;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.user.service.feign.UserFeignClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class UserServiceImpl
implements UserService {
    @Autowired
    private UserFeignClient userFeignClient;
    @Autowired(required=false)
    private List<UserEventListener> localUserEventListeners;

    public UserVo create(UserVo user) {
        Validate.notNull((Object)user, (String)"\u5fc5\u987b\u4f20\u5165\u8981\u6dfb\u52a0\u7684\u7528\u6237\u4fe1\u606f!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)user.getUserName(), (String)"\u7528\u6237\u771f\u5b9e\u59d3\u540d\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)user.getAccount(), (String)"\u7528\u6237\u8d26\u53f7\u4fe1\u606f\uff08\u4e00\u822c\u662f\u624b\u673a\u53f7\uff09\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        ResponseModel response = this.userFeignClient.create(user);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        if (this.localUserEventListeners != null) {
            for (UserEventListener eventListener : this.localUserEventListeners) {
                eventListener.onUserCreated(user);
            }
        }
        return (UserVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), UserVo.class);
    }

    public UserVo update(UserVo user) {
        Validate.notNull((Object)user, (String)"\u5fc5\u987b\u4f20\u5165\u8981\u4fee\u6539\u7684\u7528\u6237\u4fe1\u606f!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)user.getId(), (String)"\u4fee\u6539\u65f6\uff0c\u7528\u6237\u6570\u636e\u7684\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)user.getUserName(), (String)"\u7528\u6237\u771f\u5b9e\u59d3\u540d\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)user.getAccount(), (String)"\u7528\u6237\u8d26\u53f7\u4fe1\u606f\uff08\u4e00\u822c\u662f\u624b\u673a\u53f7\uff09\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        ResponseModel response = this.userFeignClient.update(user);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        this.doUpdateNotify(user);
        return (UserVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), UserVo.class);
    }

    private void doUpdateNotify(UserVo user) {
        if (this.localUserEventListeners != null) {
            for (UserEventListener eventListener : this.localUserEventListeners) {
                eventListener.onUserUpgraded(user);
            }
        }
    }

    public UserVo updatePassword(String userId, String newPassword) {
        Validate.notBlank((CharSequence)userId, (String)"\u4fee\u6539\u5bc6\u7801\u65f6 ,\u7528\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)newPassword, (String)"\u4fee\u6539\u5bc6\u7801\u65f6 ,\u65b0\u7684\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        UserVo userVo = this.findByUserId(userId);
        Validate.notNull((Object)userVo, (String)"\u672a\u5728\u8fdc\u7a0b\u7cfb\u7edf\u4e2d\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ResponseModel response = this.userFeignClient.updatePasswordIgnoreOld(userId, newPassword);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        this.doUpdateNotify(userVo);
        return (UserVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), UserVo.class);
    }

    public UserVo updatePassword(String userId, String newPassword, String oldPassword) {
        Validate.notBlank((CharSequence)userId, (String)"\u4fee\u6539\u5bc6\u7801\u65f6 ,\u7528\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)newPassword, (String)"\u4fee\u6539\u5bc6\u7801\u65f6 ,\u65b0\u7684\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)oldPassword, (String)"\u4fee\u6539\u5bc6\u7801\u65f6 ,\u539f\u6709\u7684\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        UserVo userVo = this.findByUserId(userId);
        Validate.notNull((Object)userVo, (String)"\u672a\u5728\u8fdc\u7a0b\u7cfb\u7edf\u4e2d\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ResponseModel response = this.userFeignClient.updatePassword(userId, newPassword, oldPassword);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        this.doUpdateNotify(userVo);
        return (UserVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), UserVo.class);
    }

    public void updateLastloginTime(String account) {
        Validate.notBlank((CharSequence)account, (String)"\u4fee\u6539\u6700\u540e\u767b\u5f55\u65f6\u95f4\u65f6 ,\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        UserVo userVo = this.findByAccount(account);
        Validate.notNull((Object)userVo, (String)"\u672a\u5728\u8fdc\u7a0b\u7cfb\u7edf\u4e2d\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ResponseModel response = this.userFeignClient.updateLastloginTime(account);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        this.doUpdateNotify(userVo);
    }

    public UserVo enabled(String account) {
        Validate.notBlank((CharSequence)account, (String)"\u7528\u6237\u8d26\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        UserVo userVo = this.findByAccount(account);
        Validate.notNull((Object)userVo, (String)"\u672a\u5728\u8fdc\u7a0b\u7cfb\u7edf\u4e2d\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ResponseModel response = this.userFeignClient.enabled(account);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        this.doUpdateNotify(userVo);
        return (UserVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), UserVo.class);
    }

    public UserVo disable(String account) {
        Validate.notBlank((CharSequence)account, (String)"\u7528\u6237\u8d26\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        UserVo userVo = this.findByAccount(account);
        Validate.notNull((Object)userVo, (String)"\u672a\u5728\u8fdc\u7a0b\u7cfb\u7edf\u4e2d\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ResponseModel response = this.userFeignClient.disable(account);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        this.doUpdateNotify(userVo);
        return (UserVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), UserVo.class);
    }

    public UserVo findDetailsById(String userId) {
        ResponseModel response = this.userFeignClient.findDetailsById(userId);
        return (UserVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), UserVo.class);
    }

    public UserVo findByAccount(String account) {
        ResponseModel response = this.userFeignClient.findByAccount(account);
        return (UserVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), UserVo.class);
    }

    public List<UserVo> findByAccountLikeOrNameLike(String param) {
        ResponseModel response = this.userFeignClient.findByAccountLikeOrNameLike(param);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<UserVo>>(){});
    }

    public UserVo findByPhone(String phone) {
        ResponseModel response = this.userFeignClient.findByPhone(phone);
        return (UserVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), UserVo.class);
    }

    public Page<UserVo> findByConditions(UserVo userVo, Pageable pageable) {
        ResponseModel response = this.userFeignClient.findByConditions(userVo.getUserName(), userVo.getAccount(), userVo.getIdcard(), userVo.getPhone(), userVo.getCreateTime(), userVo.getEntryTime(), userVo.getLastloginTime(), userVo.getUseStatus(), userVo.getUserHead(), userVo.getGender(), userVo.getExtend1(), userVo.getExtend2(), userVo.getExtend3(), userVo.getExtend4(), userVo.getExtend5(), userVo.getExtend6(), userVo.getExtend7(), userVo.getExtend8(), userVo.getExtend9(), userVo.getExtend10(), pageable.getPageNumber(), pageable.getPageSize());
        Object data = response.getSuccessDataOrElse(null);
        if (data == null) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        return PageUtils.convert2Page((JSONObject)JsonUtils.toJSONObject((Object)data), (TypeReference)new TypeReference<List<UserVo>>(){});
    }

    public List<UserVo> findByAccountAndTypeStruDescendant(String userId, Integer type) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Lists.newArrayList();
        }
        ResponseModel response = this.userFeignClient.findByAccountAndTypeStruDescendant(userId, type);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<UserVo>>(){});
    }

    public UserVo findByUserId(String userId) {
        Validate.notBlank((CharSequence)userId, (String)"\u4f20\u5165\u7684\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ResponseModel response = this.userFeignClient.findByUserId(userId);
        return (UserVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), UserVo.class);
    }

    public Set<UserVo> findByIds(List<String> ids) {
        ResponseModel response = this.userFeignClient.findByIds(ids);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<UserVo>>(){});
    }

    public Set<UserVo> findByOrgId(String orgId) {
        if (StringUtils.isBlank((CharSequence)orgId)) {
            return Sets.newHashSet();
        }
        ResponseModel response = this.userFeignClient.findByOrgId(orgId);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<UserVo>>(){});
    }

    public Set<UserVo> findByPositionId(String positionId) {
        if (StringUtils.isBlank((CharSequence)positionId)) {
            return Sets.newHashSet();
        }
        ResponseModel response = this.userFeignClient.findByPositionId(positionId);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<UserVo>>(){});
    }

    @NebulaServiceMethod(name="UserService.findByConditions", desc="\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868", returnPropertiesFilter="positions,groups,orgs,roles", scope=NebulaServiceMethod.ScopeType.READ)
    public Page<UserVo> findByConditions(@ServiceMethodParam(name="pageable") Pageable pageable, InvokeParams invokeParams) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        invokeParams = (InvokeParams)ObjectUtils.defaultIfNull((Object)invokeParams, (Object)new InvokeParams());
        Map params = invokeParams.getInvokeParams();
        UserVo user = (UserVo)JsonUtils.convert((Object)params, UserVo.class);
        return this.findByConditions(user, pageable);
    }

    public Boolean isDefaultPassword(String account) {
        ResponseModel response = this.userFeignClient.isDefaultPassword(account);
        return (Boolean)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Boolean>(){});
    }
}

