package com.bizunited.platform.user.service.local.annotations;

import com.bizunited.platform.user.service.local.configuration.UserLocalServiceAutoConfiguration;
import org.springframework.context.annotation.Import;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * 使用该标识性质的注解，标记在业务工程的Service层，
 * 表示这个service可以启动用户资源本地文件服务
 * @author paul chan
 * @date 2020-03-16 10:14
 */
@Retention(value = java.lang.annotation.RetentionPolicy.RUNTIME)
@Target(value = { java.lang.annotation.ElementType.TYPE })
@Documented
@Import(UserLocalServiceAutoConfiguration.class)
public @interface EnableUserLocalService {

}
