package com.bizunited.platform.user.service.local.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.util.Date;
import java.util.Set;

/**
 * 该实体记录业务系统中所有需要使用鉴权登录的用户信息。例如后台管理员用户。通过不同的角色信息，对这些用户进行区别
 * @author yinwenjie
 */
@ApiModel(value = "UserEntity" , description="一个拥有权限信息的业务系统用户定义")
@Entity
@Table(name = "engine_user")
@org.hibernate.annotations.Table(appliesTo = "engine_user" , comment = "一个拥有权限信息的业务系统用户定义")
public class UserEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 318381684938863952L;

  /**
   * 人员姓名
   */
  @ApiModelProperty(name="userName" , value="人员姓名" , required=true)
  @Column(name = "user_name", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '人员姓名'")
  @SaturnColumn(description="人员姓名")
  private String userName;

  /**
   * 用户账号登录账号
   */
  @ApiModelProperty(name="account" , value="用户账号登录信息" , required=true)
  @Column(name = "user_account", length = 64, nullable = false, unique = true, columnDefinition = "varchar(64) COMMENT '用户账号登录信息'")
  @SaturnColumn(description="用户账号登录信息")
  private String account;

  /**
   * 人员主要联系电话
   */
  @ApiModelProperty(name="phone" , value="人员主要联系电话(也可能会使用该信息登录)" , required=false)
  @Column(name = "user_phone", length = 64, nullable = true, unique = true, columnDefinition = "varchar(64) COMMENT '人员主要联系电话(也可能会使用该信息登录)'")
  @SaturnColumn(description="人员主要联系电话")
  private String phone = "";

  /**
   * 用户账号密码信息
   */
  @ApiModelProperty(name="password" , value="用户账号密码信息（经过加密的）" , required=true)
  @Column(name = "user_password", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '用户账号密码信息（经过加密的）'")
  @SaturnColumn(description="用户账号密码信息")
  private String password;

  /**
   * 创建时间
   */
  @ApiModelProperty(name="createTime" , value="创建时间" , required=false)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description="创建时间")
  private Date createTime=new Date();

  /**
   * 入职时间
   */
  @ApiModelProperty(name="entryTime" , value="入职时间" , required=false)
  @Column(name = "entry_time", nullable = true, columnDefinition = "datetime COMMENT '入职时间'")
  @SaturnColumn(description="入职时间")
  private Date entryTime=new Date();

  /**
   * 最后一次登录时间
   */
  @ApiModelProperty(name="lastloginTime" , value="最后一次登录时间" , required=false)
  @Column(name = "lastlogin_time", nullable = true, columnDefinition = "datetime COMMENT '最后一次登录时间'")
  @SaturnColumn(description="最后一次登录时间")
  private Date lastloginTime=new Date();

  /**
   * 用户账号状态
   */
  @ApiModelProperty(name="useStatus" , value="用户账号状态 1：正常，其它值（0）不正常" , required=false)
  @Column(name = "use_status", nullable = false, columnDefinition = "int(11) COMMENT '用户账号状态 1：正常，其它值（0）不正常'")
  @SaturnColumn(description="用户账号状态")
  private Integer useStatus = 1;

  /**
   * 人员头像
   */
  @ApiModelProperty(name="userHead" , value="人员头像" , required=false)
  @Column(name = "user_head", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '人员头像'")
  @SaturnColumn(description="人员头像")
  private String userHead = "";

  /**
   * 人员性别
   */
  @ApiModelProperty(name="gender" , value="性别.0保密，1男 2女" , required=false)
  @Column(name = "gender" , nullable=true, columnDefinition = "int(11) COMMENT '性别.0保密，1男 2女'")
  @SaturnColumn(description="人员性别")
  private Integer gender = 0;

  /**
   * 所属组织机构
   */
  @ManyToMany(fetch=FetchType.LAZY , mappedBy="users")
  @SaturnColumn(description="所属组织机构")
  private Set<OrganizationEntity> orgs;

  /**
   * 所属用户组
   */
  @ManyToMany(fetch=FetchType.LAZY , mappedBy="users")
  @SaturnColumn(description="所属用户组")
  private Set<UserGroupEntity> groups;

  /**
   * 所属岗位
   */
  @OrderBy("createTime")
  @ManyToMany(fetch=FetchType.LAZY , mappedBy="users")
  @SaturnColumn(description="所属岗位（目前逻辑限制只有一个）")
  private Set<PositionEntity> positions;

  /**
   * 扩展字段1
   */
  @ApiModelProperty(name="extend_1", value="扩展字段1", required=false)
  @SaturnColumn(description="扩展字段1")
  @Column(name = "extend1", nullable = true, columnDefinition = "varchar(255) comment '扩展字段1'")
  private String extend1;

  /**
   * 扩展字段2
   */
  @ApiModelProperty(name="extend_2", value="扩展字段2", required=false)
  @Column(name = "extend2", nullable = true, columnDefinition = "varchar(255) comment '扩展字段2'")
  @SaturnColumn(description="扩展字段2")
  private String extend2;

  /**
   * 扩展字段3
   */
  @ApiModelProperty(name="extend_3", value="扩展字段3", required=false)
  @Column(name = "extend3", nullable = true, columnDefinition = "varchar(255) comment '扩展字段3'")
  @SaturnColumn(description="扩展字段3")
  private String extend3;

  /**
   * 扩展字段4
   */
  @ApiModelProperty(name="extend_4", value="扩展字段4", required=false)
  @Column(name = "extend4", nullable = true, columnDefinition = "varchar(255) comment '扩展字段4'")
  @SaturnColumn(description="扩展字段4")
  private String extend4;

  /**
   * 扩展字段5
   */
  @ApiModelProperty(name="extend_5", value="扩展字段5", required=false)
  @Column(name = "extend5", nullable = true, columnDefinition = "varchar(255) comment '扩展字段5'")
  @SaturnColumn(description="扩展字段5")
  private String extend5;

  /**
   * 扩展字段6
   */
  @ApiModelProperty(name="extend_6", value="扩展字段6", required=false)
  @Column(name = "extend6", nullable = true, columnDefinition = "varchar(255) comment '扩展字段6'")
  @SaturnColumn(description="扩展字段6")
  private String extend6;

  /**
   * 扩展字段7
   */
  @ApiModelProperty(name="extend_7", value="扩展字段7", required=false)
  @Column(name = "extend7", nullable = true, columnDefinition = "varchar(255) comment '扩展字段7'")
  @SaturnColumn(description="扩展字段7")
  private String extend7;

  /**
   * 扩展字段8
   */
  @ApiModelProperty(name="extend_8", value="扩展字段8", required=false)
  @Column(name = "extend8", nullable = true, columnDefinition = "varchar(255) comment '扩展字段8'")
  @SaturnColumn(description="扩展字段8")
  private String extend8;

  /**
   * 扩展字段9
   */
  @ApiModelProperty(name="extend_9", value="扩展字段9", required=false)
  @Column(name = "extend9", nullable = true, columnDefinition = "varchar(255) comment '扩展字段9'")
  @SaturnColumn(description="扩展字段9")
  private String extend9;

  /**
   * 扩展字段10
   */
  @ApiModelProperty(name="extend_10", value="扩展字段10", required=false)
  @Column(name = "extend10", nullable = true, columnDefinition = "varchar(255) comment '扩展字段10'")
  @SaturnColumn(description="扩展字段10")
  private String extend10;

  public String getUserName() {
    return userName;
  }
  public void setUserName(String userName) {
    this.userName = userName;
  }
  public String getAccount() {
    return account;
  }
  public void setAccount(String account) {
    this.account = account;
  }
  public String getPhone() {
    return phone;
  }
  public void setPhone(String phone) {
    this.phone = phone;
  }
  public String getPassword() {
    return password;
  }
  public void setPassword(String password) {
    this.password = password;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public Date getEntryTime() {
    return entryTime;
  }
  public void setEntryTime(Date entryTime) {
    this.entryTime = entryTime;
  }
  public Date getLastloginTime() {
    return lastloginTime;
  }
  public void setLastloginTime(Date lastloginTime) {
    this.lastloginTime = lastloginTime;
  }
  public Integer getUseStatus() {
    return useStatus;
  }
  public void setUseStatus(Integer useStatus) {
    this.useStatus = useStatus;
  }
  public String getUserHead() {
    return userHead;
  }
  public void setUserHead(String userHead) {
    this.userHead = userHead;
  }
  public Integer getGender() {
    return gender;
  }
  public void setGender(Integer gender) {
    this.gender = gender;
  }
  public Set<OrganizationEntity> getOrgs() {
    return orgs;
  }
  public void setOrgs(Set<OrganizationEntity> orgs) {
    this.orgs = orgs;
  }
  public Set<UserGroupEntity> getGroups() {
    return groups;
  }
  public void setGroups(Set<UserGroupEntity> groups) {
    this.groups = groups;
  }
  public Set<PositionEntity> getPositions() {
    return positions;
  }
  public void setPositions(Set<PositionEntity> positions) {
    this.positions = positions;
  }

  public String getExtend1() {
    return extend1;
  }

  public void setExtend1(String extend1) {
    this.extend1 = extend1;
  }

  public String getExtend2() {
    return extend2;
  }

  public void setExtend2(String extend2) {
    this.extend2 = extend2;
  }

  public String getExtend3() {
    return extend3;
  }

  public void setExtend3(String extend3) {
    this.extend3 = extend3;
  }

  public String getExtend4() {
    return extend4;
  }

  public void setExtend4(String extend4) {
    this.extend4 = extend4;
  }

  public String getExtend5() {
    return extend5;
  }

  public void setExtend5(String extend5) {
    this.extend5 = extend5;
  }

  public String getExtend6() {
    return extend6;
  }

  public void setExtend6(String extend6) {
    this.extend6 = extend6;
  }

  public String getExtend7() {
    return extend7;
  }

  public void setExtend7(String extend7) {
    this.extend7 = extend7;
  }

  public String getExtend8() {
    return extend8;
  }

  public void setExtend8(String extend8) {
    this.extend8 = extend8;
  }

  public String getExtend9() {
    return extend9;
  }

  public void setExtend9(String extend9) {
    this.extend9 = extend9;
  }

  public String getExtend10() {
    return extend10;
  }

  public void setExtend10(String extend10) {
    this.extend10 = extend10;
  }
}