package com.bizunited.platform.user.service.local.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 用户扩展字段模型定义
 * @Author: Paul Chan
 * @Date: 2020-04-02 10:59
 */
@Entity
@Table(name = "engine_user_extent_field")
@ApiModel(value = "UserExtentFieldEntity" , description="用户扩展字段模型定义")
@org.hibernate.annotations.Table(appliesTo = "engine_user_extent_field" , comment = "用户扩展字段模型定义")
public class UserExtentFieldEntity extends UuidEntity {
  private static final long serialVersionUID = 4537342193959428878L;

  /**
   * 字段名称
   */
  @ApiModelProperty("字段名称")
  @SaturnColumn(description = "字段名称")
  @Column(name = "field_name", nullable = false, columnDefinition = "varchar(255) comment '字段名称'")
  private String fieldName;

  /**
   * 字段描述
   */
  @ApiModelProperty("字段描述")
  @SaturnColumn(description = "字段描述")
  @Column(name = "field_comment", nullable = false, columnDefinition = "varchar(255) comment '字段描述'")
  private String fieldComment;

  /**
   * 状态
   */
  @ApiModelProperty("状态")
  @SaturnColumn(description = "状态")
  @Column(name = "state", nullable = false, columnDefinition = "bit(1) comment '状态'")
  private Boolean state;

  /**
   * 是否显示搜索条件
   */
  @ApiModelProperty("是否显示搜索条件")
  @SaturnColumn(description = "是否显示搜索条件")
  @Column(name = "is_show_search", nullable = false, columnDefinition = "bit(1) comment '是否显示搜索条件'")
  private Boolean isShowSearch;

  /**
   * 是否必填
   */
  @ApiModelProperty("是否必填")
  @SaturnColumn(description = "是否必填")
  @Column(name = "required", nullable = false, columnDefinition = "bit(1) comment '是否必填'")
  private Boolean required;

  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  public String getFieldComment() {
    return fieldComment;
  }

  public void setFieldComment(String fieldComment) {
    this.fieldComment = fieldComment;
  }

  public Boolean getState() {
    return state;
  }

  public void setState(Boolean state) {
    this.state = state;
  }

  public Boolean getShowSearch() {
    return isShowSearch;
  }

  public void setShowSearch(Boolean showSearch) {
    isShowSearch = showSearch;
  }

  public Boolean getRequired() {
    return required;
  }

  public void setRequired(Boolean required) {
    this.required = required;
  }
}
