package com.bizunited.platform.user.service.local.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.util.Date;
import java.util.Set;

/**
 * 该实体记录用户组所有信息，用来关联及管理用户与角色之间的关系
 */
@ApiModel(value = "UserGroupEntity" , description="一个关联用户以及角色的相关功能的定义")
@Entity
@Table(name = "engine_group")
@org.hibernate.annotations.Table(appliesTo = "engine_group" , comment = "一个关联用户以及角色的相关功能的定义")
public class UserGroupEntity extends UuidEntity {
  /**
   *
   */
  private static final long serialVersionUID = -1585035267307956140L;
  /**
   * 用户组名称
   */
  @ApiModelProperty(name="groupName" , value="用户组名称" , required=true)
  @Column(name = "group_name", length = 64, nullable = false,  columnDefinition = "varchar(64) COMMENT '用户组名称'")
  @SaturnColumn(description="用户组名称")
  private String groupName;
  /**
   * 用户组编号
   */
  @ApiModelProperty(name="groupCode" , value="用户组编号" , required=true)
  @Column(name = "group_code", length = 64, nullable = false, unique = true, columnDefinition = "varchar(64) COMMENT '用户组编号'")
  @SaturnColumn(description="用户组编号")
  private String groupCode;
  /**
   * 用户组描述
   */
  @ApiModelProperty(name = "groupDescription",value = "用户组描述",required = true)
  @Column(name = "group_description",nullable = false,length = 512, columnDefinition = "varchar(512) COMMENT '用户组描述'")
  @SaturnColumn(description = "用户组描述")
  private String groupDescription;
  /**
   * 用户组状态
   */
  @ApiModelProperty(name = "groupStatus",value = "用户组状态(0:禁用,1:启用)",required = true)
  @Column(name = "group_status",nullable = false, columnDefinition = "int(11) COMMENT '用户组状态(0:禁用,1:启用)'")
  @SaturnColumn(description = "用户组状态")
  private Integer tstatus;
  /**
   * 创建时间
   */
  @ApiModelProperty(name="createTime" , value="创建时间" , required=false)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description="创建时间")
  private Date createTime=new Date();
  /**
   * 用户组用户关联
   */
  @ApiModelProperty(name="users" , value="用户组绑定的用户信息" ,hidden = true , required=true)
  @ManyToMany(fetch = FetchType.LAZY)
  @JoinTable(name = "engine_group_user_mapping", joinColumns = {@JoinColumn(name = "group_id")}, inverseJoinColumns = {@JoinColumn(name = "user_id")})
  @SaturnColumn(description="用户组绑定的用户信息")
  @OrderBy("createTime")
  private Set<UserEntity> users;

  public String getGroupName() {
    return groupName;
  }

  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  public String getGroupDescription() {
    return groupDescription;
  }

  public void setGroupDescription(String groupDescription) {
    this.groupDescription = groupDescription;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Set<UserEntity> getUsers() {
    return users;
  }

  public void setUsers(Set<UserEntity> users) {
    this.users = users;
  }

  public String getGroupCode() {
    return groupCode;
  }

  public void setGroupCode(String groupCode) {
    this.groupCode = groupCode;
  }
}
