package com.bizunited.platform.user.service.local.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 用户的关联设定
 * @Author: Paul Chan
 * @Date: 2019-11-25 15:28
 */
@Entity
@Table(name = "engine_user_mapping")
@ApiModel(value = "UserMappingEntity", description = "用户的关联设定")
@org.hibernate.annotations.Table(appliesTo = "engine_user_mapping" , comment = "用户的关联设定")
public class UserMappingEntity extends UuidEntity {
  private static final long serialVersionUID = 2662751725141467991L;

  /**
   * 用户和分组的关系 0：多对多，1：多对一，2：一对多，3：一对一
   */
  @ApiModelProperty("用户和分组的关系 0：多对多，1：多对一，2：一对多，3：一对一")
  @Column(name = "user_group_relation", nullable = false, columnDefinition = "int(11) default 0 COMMENT '用户和分组的关系 0：多对多，1：多对一，2：一对多，3：一对一'")
  @SaturnColumn(description = "用户和分组的关系 0：多对多，1：多对一，2：一对多，3：一对一")
  private Integer userGroupRelation;

  /**
   * 用户和组织的关系 0：多对多，1：多对一，2：一对多，3：一对一
   */
  @ApiModelProperty("用户和组织的关系 0：多对多，1：多对一，2：一对多，3：一对一")
  @Column(name = "user_org_relation", nullable = false, columnDefinition = "int(11) default 0 COMMENT '用户和组织的关系 0：多对多，1：多对一，2：一对多，3：一对一'")
  @SaturnColumn(description = "用户和组织的关系 0：多对多，1：多对一，2：一对多，3：一对一")
  private Integer userOrgRelation;


  /**
   * 用户和岗位的关系 0：多对多，1：多对一，2：一对多，3：一对一
   */
  @ApiModelProperty("用户和岗位的关系 0：多对多，1：多对一，2：一对多，3：一对一")
  @Column(name = "user_position_relation", nullable = false, columnDefinition = "int(11) default 0 COMMENT '用户和岗位的关系 0：多对多，1：多对一，2：一对多，3：一对一'")
  @SaturnColumn(description = "用户和岗位的关系 0：多对多，1：多对一，2：一对多，3：一对一")
  private Integer userPositionRelation;


  /**
   * 组织机构和岗位的关系 2：一对多，3：一对一
   */
  @ApiModelProperty("组织机构和岗位的关系 2：一对多，3：一对一")
  @Column(name = "org_position_relation", nullable = false, columnDefinition = "int(11) default 2 COMMENT '组织机构和岗位的关系 2：一对多，3：一对一'")
  @SaturnColumn(description = "组织机构和岗位的关系 2：一对多，3：一对一")
  private Integer orgPositionRelation;

  public Integer getUserGroupRelation() {
    return userGroupRelation;
  }

  public void setUserGroupRelation(Integer userGroupRelation) {
    this.userGroupRelation = userGroupRelation;
  }

  public Integer getUserOrgRelation() {
    return userOrgRelation;
  }

  public void setUserOrgRelation(Integer userOrgRelation) {
    this.userOrgRelation = userOrgRelation;
  }

  public Integer getUserPositionRelation() {
    return userPositionRelation;
  }

  public void setUserPositionRelation(Integer userPositionRelation) {
    this.userPositionRelation = userPositionRelation;
  }

  public Integer getOrgPositionRelation() {
    return orgPositionRelation;
  }

  public void setOrgPositionRelation(Integer orgPositionRelation) {
    this.orgPositionRelation = orgPositionRelation;
  }
}
