package com.bizunited.platform.user.service.local.repository.internal;

import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.user.service.local.entity.UserEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author yinwenjie
 */
@Repository("UserRepositoryImpl")
public class UserRepositoryImpl implements UserRepositoryCustom {
  
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String USER_NAME = "userName";
  private static final String ACCOUNT = "account";
  private static final String USE_STATUS = "useStatus";
  private static final String EXTEND_1 = "extend1";
  private static final String EXTEND_2 = "extend2";
  private static final String EXTEND_3 = "extend3";
  private static final String EXTEND_4 = "extend4";
  private static final String EXTEND_5 = "extend5";
  private static final String EXTEND_6 = "extend6";
  private static final String EXTEND_7 = "extend7";
  private static final String EXTEND_8 = "extend8";
  private static final String EXTEND_9 = "extend9";
  private static final String EXTEND_10 = "extend10";

  /* (non-Javadoc)
   * @see com.bizunited.platform.kuiper.starter.repository.internal.UserRepositoryCustom#findByConditions(org.springframework.data.domain.Pageable, java.util.Map)
   */
  @Override
  @SuppressWarnings("unchecked")
  public Page<UserEntity> findByConditions(Pageable pageable, UserVo user) {
    /*
     * 按照需求，是按照人员姓名或者账号信息进行查询
     * */
    StringBuilder hql = new StringBuilder("from UserEntity u where 1 = 1");
    StringBuilder countHql = new StringBuilder("select count(*) from UserEntity u where 1 = 1");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>();
    this.buildConditionsAndParameter(user, condition, parameter);
    hql.append(condition).append(" order by u.createTime desc ");
    countHql.append(condition);
    // 构造HQL查询 和 数量查询
    Query query = entityManager.createQuery(hql.toString());
    Query countQuery = entityManager.createQuery(countHql.toString());
    parameter.forEach((k, v) -> {
      query.setParameter(k, v);
      countQuery.setParameter(k, v);
    });
    
    // 构造分页信息
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<UserEntity> resutls = query.getResultList();
    
    // 查询总数量信息
    long count = (long)countQuery.getResultList().get(0);
    return new PageImpl<>(resutls,pageable,count);
  }

  /**
   * 构造查询参数和语句
   * @param conditions
   * @param condition
   * @param parameter
   */
  private void buildConditionsAndParameter(UserVo user, StringBuilder condition, Map<String, Object> parameter) {
    if(user == null) {
      return;
    }
    if(StringUtils.isNotBlank(user.getUserName())) {
      condition.append(" AND u.userName like CONCAT('%',:userName,'%') ");
      parameter.put(USER_NAME, user.getUserName());
    }
    if(StringUtils.isNotBlank(user.getAccount())) {
      condition.append(" AND u.account like CONCAT('%',:account,'%') ");
      parameter.put(ACCOUNT, user.getAccount());
    }
    if (user.getUseStatus() != null) {
      condition.append(" AND u.useStatus = :useStatus ");
      parameter.put(USE_STATUS, user.getUseStatus());
    }
    if (StringUtils.isNotBlank(user.getExtend1())) {
      condition.append(" AND u.extend1 = :extend1 ");
      parameter.put(EXTEND_1, user.getExtend1());
    }
    if (StringUtils.isNotBlank(user.getExtend2())) {
      condition.append(" AND u.extend2 = :extend2 ");
      parameter.put(EXTEND_2, user.getExtend2());
    }
    if (StringUtils.isNotBlank(user.getExtend3())) {
      condition.append(" AND u.extend3 = :extend3 ");
      parameter.put(EXTEND_3, user.getExtend3());
    }
    if (StringUtils.isNotBlank(user.getExtend4())) {
      condition.append(" AND u.extend4 = :extend4 ");
      parameter.put(EXTEND_4, user.getExtend4());
    }
    if (StringUtils.isNotBlank(user.getExtend5())) {
      condition.append(" AND u.extend5 = :extend5 ");
      parameter.put(EXTEND_5, user.getExtend5());
    }
    if (StringUtils.isNotBlank(user.getExtend6())) {
      condition.append(" AND u.extend6 = :extend6 ");
      parameter.put(EXTEND_6, user.getExtend6());
    }
    if (StringUtils.isNotBlank(user.getExtend7())) {
      condition.append(" AND u.extend7 = :extend7 ");
      parameter.put(EXTEND_7, user.getExtend7());
    }
    if (StringUtils.isNotBlank(user.getExtend8())) {
      condition.append(" AND u.extend8 = :extend8 ");
      parameter.put(EXTEND_8, user.getExtend8());
    }
    if (StringUtils.isNotBlank(user.getExtend9())) {
      condition.append(" AND u.extend9 = :extend9 ");
      parameter.put(EXTEND_9, user.getExtend9());
    }
    if (StringUtils.isNotBlank(user.getExtend10())) {
      condition.append(" AND u.extend10 = :extend10 ");
      parameter.put(EXTEND_10, user.getExtend10());
    }
  }
}