package com.bizunited.platform.user.service.local.service.init;

import com.bizunited.platform.common.service.init.InitProcessService;
import com.bizunited.platform.user.common.service.UserMappingService;
import com.bizunited.platform.user.service.local.entity.UserEntity;
import com.bizunited.platform.user.service.local.repository.UserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

import static com.bizunited.platform.common.constant.Constants.DEFAULT_ADMIN_ACCOUNT;
import static com.bizunited.platform.common.constant.Constants.DEFAULT_PASSWORD;

/**
 * 该初始化过程用于系统启动时初始化管理员相关账号，如果管理员账号已经存在，则不会进行初始化工作
 * @author paul chan
 */
@Component("UserInitProcess")
public class UserInitProcess implements InitProcessService {
  @Autowired
  private UserRepository userRepository;
  @Autowired
  @Qualifier("passwordEncoder")
  @Lazy
  private PasswordEncoder passwordEncoder;
  @Autowired
  private UserMappingService userMappingService;

  @Override
  public boolean doProcess() {
    // 如果当前系统中能够找到一个名叫BASEROLE的角色，就认为整个基础权限的初始化做完了，那么就没有必要继续做了
    return this.userRepository.findByAccount(DEFAULT_ADMIN_ACCOUNT) == null
        || this.userMappingService.find() == null;
  }
  
  @Override
  public int sort() {
    // 要求在系统启动时，第一时间检验并完成权限基本信息的初始化
    return 1;
  }

  @Override
  public boolean stopOnException() {
    // 如果该初始化过程出现异常，则直接抛出，并终止后续处理
    return true;
  }

  @Override
  public void init() {
    // 如果条件成立，则初始化管理员
    if (this.userRepository.findByAccount(DEFAULT_ADMIN_ACCOUNT) == null) {
      this.initAdmin();
    }
    userMappingService.init();
  }
  


  /** 初始化系统管理员 */
  private void initAdmin() {
    // 保证系统中至少有一个系统管理员
    UserEntity admin = new UserEntity();
    admin.setAccount(DEFAULT_ADMIN_ACCOUNT);
    admin.setGender(0);
    admin.setPassword(this.passwordEncoder.encode(DEFAULT_PASSWORD));
    admin.setPhone("12345678");
    admin.setUserName("后台超级管理员");
    admin.setUseStatus(1);
    this.userRepository.saveAndFlush(admin);
  }

}
