package com.bizunited.platform.user.service.local.service.internal;

import com.bizunited.platform.common.enums.RbacRelationEnum;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.user.common.service.UserMappingService;
import com.bizunited.platform.user.common.vo.UserMappingVo;
import com.bizunited.platform.user.service.local.entity.UserMappingEntity;
import com.bizunited.platform.user.service.local.repository.UserMappingRepository;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 用户关联配置服务实现类
 * @Author: Paul Chan
 * @Date: 2019-11-25 15:57
 */
@Service("UserMappingServiceImpl")
public class UserMappingServiceImpl implements UserMappingService {

  @Autowired
  private UserMappingRepository userMappingRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;


  @Override
  @Transactional
  public UserMappingVo init() {
    List<UserMappingEntity> mappings = userMappingRepository.findAll();
    if(!CollectionUtils.isEmpty(mappings)) {
      return nebulaToolkitService.copyObjectByWhiteList(mappings.get(0), UserMappingVo.class, HashSet.class, ArrayList.class);
    }
    UserMappingEntity mapping = new UserMappingEntity();
    mapping.setUserGroupRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
    mapping.setUserOrgRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
    mapping.setUserPositionRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
    mapping.setOrgPositionRelation(RbacRelationEnum.ONE_TO_MANY.getRelation());
    userMappingRepository.save(mapping);
    return nebulaToolkitService.copyObjectByWhiteList(mapping, UserMappingVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  @Transactional
  public UserMappingVo update(UserMappingVo mappingVo) {
    Validate.notBlank(mappingVo.getId(), "更新时主键ID不能为空!!!");
    UserMappingEntity mapping = userMappingRepository.findById(mappingVo.getId()).orElse(null);
    Validate.notNull(mapping, "更新对象不存在，请检查！！！");
    if(mappingVo.getUserGroupRelation() != null) {
      mapping.setUserGroupRelation(mappingVo.getUserGroupRelation());
    }
    if(mappingVo.getUserOrgRelation() != null) {
      mapping.setUserOrgRelation(mappingVo.getUserOrgRelation());
    }
    if(mappingVo.getUserPositionRelation() != null) {
      mapping.setUserPositionRelation(mappingVo.getUserPositionRelation());
    }
    if(mappingVo.getOrgPositionRelation() != null) {
      mapping.setOrgPositionRelation(mappingVo.getOrgPositionRelation());
    }
    userMappingRepository.save(mapping);
    return nebulaToolkitService.copyObjectByWhiteList(mapping, UserMappingVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  public UserMappingVo find() {
    List<UserMappingEntity> mappings = userMappingRepository.findAll();
    if(CollectionUtils.isEmpty(mappings)) {
      return this.init();
    }
    return nebulaToolkitService.copyObjectByWhiteList(mappings.get(0), UserMappingVo.class, HashSet.class, ArrayList.class);
  }

}
