package com.bizunited.platform.user.service.local.repository;


import com.bizunited.platform.user.service.local.entity.AdministrativeRegionEntity;
import com.bizunited.platform.user.service.local.repository.internal.AdministrativeRegionRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * AdministrativeRegionEntity业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("AdministrativeRegionEntityRepository")
public interface AdministrativeRegionRepository
    extends
    JpaRepository<AdministrativeRegionEntity, String>
    , JpaSpecificationExecutor<AdministrativeRegionEntity>
    , AdministrativeRegionRepositoryCustom {

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct administrativeRegionEntity from AdministrativeRegionEntity administrativeRegionEntity "
      + " left join fetch administrativeRegionEntity.parent administrativeRegionEntity_parent "
      + " where administrativeRegionEntity.id=:id ")
  AdministrativeRegionEntity findDetailsById(@Param("id") String id);

  /**
   * 查询所有顶级区域
   *
   * @param code
   * @return
   */
  AdministrativeRegionEntity findByDimensionalityCode(String code);

  /**
   * 根据层级查询
   *
   * @param regionLevel
   * @return
   */
  @Query("select distinct ad from AdministrativeRegionEntity ad where ad.regionLevel = :regionLevel ")
  List<AdministrativeRegionEntity> findByRegionLevel(@Param("regionLevel") Integer regionLevel);

  /**
   * 根据组织机构ID查询关联的行政区域
   * @param orgId
   * @return
   */
  @Query("select r from AdministrativeRegionEntity r inner join r.orgs o where o.id = :orgId and r.regionLevel = :level " +
      " order by r.regionCode asc")
  List<AdministrativeRegionEntity> findByOrgIdAndLevel(@Param("orgId") String orgId, @Param("level") Integer level);

  /**
   * 查询明细
   * @return
   */
  @Query("select r from AdministrativeRegionEntity  r left join fetch r.parent rp")
  List<AdministrativeRegionEntity> findAllDetails();

  /**
   * 查询父级为null的数据
   * @return
   */
  @Query("select r from AdministrativeRegionEntity r where r.parent is null order by r.id asc")
  List<AdministrativeRegionEntity> findByNullParent();

  /**
   * 根据父级ID查询
   * @return
   */
  @Query("select r from AdministrativeRegionEntity r inner join r.parent rp where rp.id = :parentId order by r.id asc")
  List<AdministrativeRegionEntity> findByParentId(@Param("parentId") String parentId);

  /**
   * 根据编码查询行政区域
   * @param code
   * @return
   */
  @Query("select r from AdministrativeRegionEntity r where r.regionCode = :code")
  AdministrativeRegionEntity findByRegionCode(@Param("code") String code);
}