package com.bizunited.platform.user.service.local.entity;

import com.bizunited.platform.common.entity.UuidEntity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;
import java.util.Set;

/**
 * @author: weikangning
 * @Date: 2020/8/18 16:27
 * @Description: 职位级别实体
 */
@ApiModel(value = "PositionLevelEntity", description = "职位级别")
@Entity
@Table(name = "engine_position_level")
@org.hibernate.annotations.Table(appliesTo = "engine_position_level", comment = "描述业务系统中的职位级别信息")
public class PositionLevelEntity extends UuidEntity {

  /**
   * 
   */
  private static final long serialVersionUID = 9162981914872402190L;

  @ApiModelProperty(name = "code", value = "职位级别唯一编号", required = true)
  @Column(name = "code", length = 128, nullable = false, unique = true, columnDefinition = "varchar(128) COMMENT '职位级别的唯一编号'")
  @SaturnColumn(description = "职位级别的唯一编号", length = 128, nullable = false, unique = true)
  private String code;

  @ApiModelProperty(name = "name", value = "职位级别名称", required = true)
  @Column(name = "name", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '职位级别名称'")
  @SaturnColumn(description = "职位级别名称", length = 64, nullable = false)
  private String name;

  @ApiModelProperty(name = "state", value = "职位级别状态（1启用；0禁用）", required = true)
  @Column(name = "state", nullable = false, columnDefinition = "int(11) COMMENT '职位级别状态'")
  @SaturnColumn(description = "职位级别状态", nullable = false)
  private Integer state;

  @ApiModelProperty(name = "createUser", value = "创建人", required = true)
  @Column(name = "create_user", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '创建人'")
  @SaturnColumn(description = "创建人", nullable = false)
  private String createUser;

  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间", nullable = false)
  private Date createTime = new Date();

  /**
   * 最后更新人
   */
  @ApiModelProperty(name = "modifyUser", value = "最后更新人")
  @Column(name = "modify_user", columnDefinition = "varchar(255) COMMENT '最后更新人'")
  @SaturnColumn(description = "最后更新人")
  private String modifyUser;

  /**
   * 最后更新时间
   */
  @ApiModelProperty(name = "modifyDate", value = "最后更新时间")
  @Column(name = "modify_Date", columnDefinition = "datetime COMMENT '最后更新时间'")
  @SaturnColumn(description = "最后更新时间")
  private Date modifyDate;

  /**
   * 关联职位
   */
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "positionLevel")
  @SaturnColumn(description = "关联职位")
  @OrderBy("createTime")
  private Set<PositionEntity> positions;

  /**
   * 扩展字段1
   */
  @ApiModelProperty(name="extend1", value="扩展字段1", required=false)
  @SaturnColumn(description="扩展字段1")
  @Column(name = "extend1", nullable = true, columnDefinition = "varchar(255) comment '扩展字段1'")
  private String extend1;

  /**
   * 扩展字段2
   */
  @ApiModelProperty(name="extend2", value="扩展字段2", required=false)
  @Column(name = "extend2", nullable = true, columnDefinition = "varchar(255) comment '扩展字段2'")
  @SaturnColumn(description="扩展字段2")
  private String extend2;

  /**
   * 扩展字段3
   */
  @ApiModelProperty(name="extend3", value="扩展字段3", required=false)
  @Column(name = "extend3", nullable = true, columnDefinition = "varchar(255) comment '扩展字段3'")
  @SaturnColumn(description="扩展字段3")
  private String extend3;

  /**
   * 扩展字段4
   */
  @ApiModelProperty(name="extend4", value="扩展字段4", required=false)
  @Column(name = "extend4", nullable = true, columnDefinition = "varchar(255) comment '扩展字段4'")
  @SaturnColumn(description="扩展字段4")
  private String extend4;

  /**
   * 扩展字段5
   */
  @ApiModelProperty(name="extend5", value="扩展字段5", required=false)
  @Column(name = "extend5", nullable = true, columnDefinition = "varchar(255) comment '扩展字段5'")
  @SaturnColumn(description="扩展字段5")
  private String extend5;

  /**
   * 扩展字段6
   */
  @ApiModelProperty(name="extend6", value="扩展字段6", required=false)
  @Column(name = "extend6", nullable = true, columnDefinition = "varchar(255) comment '扩展字段6'")
  @SaturnColumn(description="扩展字段6")
  private String extend6;

  /**
   * 扩展字段7
   */
  @ApiModelProperty(name="extend7", value="扩展字段7", required=false)
  @Column(name = "extend7", nullable = true, columnDefinition = "varchar(255) comment '扩展字段7'")
  @SaturnColumn(description="扩展字段7")
  private String extend7;

  /**
   * 扩展字段8
   */
  @ApiModelProperty(name="extend8", value="扩展字段8", required=false)
  @Column(name = "extend8", nullable = true, columnDefinition = "varchar(255) comment '扩展字段8'")
  @SaturnColumn(description="扩展字段8")
  private String extend8;

  /**
   * 扩展字段9
   */
  @ApiModelProperty(name="extend9", value="扩展字段9", required=false)
  @Column(name = "extend9", nullable = true, columnDefinition = "varchar(255) comment '扩展字段9'")
  @SaturnColumn(description="扩展字段9")
  private String extend9;

  /**
   * 扩展字段10
   */
  @ApiModelProperty(name="extend10", value="扩展字段10", required=false)
  @Column(name = "extend10", nullable = true, columnDefinition = "varchar(255) comment '扩展字段10'")
  @SaturnColumn(description="扩展字段10")
  private String extend10;

  public Set<PositionEntity> getPositions() {
    return positions;
  }

  public void setPositions(Set<PositionEntity> positions) {
    this.positions = positions;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Integer getState() {
    return state;
  }

  public void setState(Integer state) {
    this.state = state;
  }

  public String getCreateUser() {
    return createUser;
  }

  public void setCreateUser(String createUser) {
    this.createUser = createUser;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public String getModifyUser() {
    return modifyUser;
  }

  public void setModifyUser(String modifyUser) {
    this.modifyUser = modifyUser;
  }

  public Date getModifyDate() {
    return modifyDate;
  }

  public void setModifyDate(Date modifyDate) {
    this.modifyDate = modifyDate;
  }

  public String getExtend1() {
    return extend1;
  }

  public void setExtend1(String extend1) {
    this.extend1 = extend1;
  }

  public String getExtend2() {
    return extend2;
  }

  public void setExtend2(String extend2) {
    this.extend2 = extend2;
  }

  public String getExtend3() {
    return extend3;
  }

  public void setExtend3(String extend3) {
    this.extend3 = extend3;
  }

  public String getExtend4() {
    return extend4;
  }

  public void setExtend4(String extend4) {
    this.extend4 = extend4;
  }

  public String getExtend5() {
    return extend5;
  }

  public void setExtend5(String extend5) {
    this.extend5 = extend5;
  }

  public String getExtend6() {
    return extend6;
  }

  public void setExtend6(String extend6) {
    this.extend6 = extend6;
  }

  public String getExtend7() {
    return extend7;
  }

  public void setExtend7(String extend7) {
    this.extend7 = extend7;
  }

  public String getExtend8() {
    return extend8;
  }

  public void setExtend8(String extend8) {
    this.extend8 = extend8;
  }

  public String getExtend9() {
    return extend9;
  }

  public void setExtend9(String extend9) {
    this.extend9 = extend9;
  }

  public String getExtend10() {
    return extend10;
  }

  public void setExtend10(String extend10) {
    this.extend10 = extend10;
  }
}
