package com.bizunited.platform.user.service.local.repository;

import com.bizunited.platform.user.service.local.entity.PositionLevelEntity;
import com.bizunited.platform.user.service.local.repository.internal.PositionLevelRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * @author: weikangning
 * @Date: 2020/8/18 16:28
 * @Description: 职位级别
 */
@Repository("PositionLevelRepository")
public interface PositionLevelRepository extends JpaRepository<PositionLevelEntity, String>,
        JpaSpecificationExecutor<PositionLevelEntity>, PositionLevelRepositoryCustom {

  /**
   * 根据编码查询
   * @Param
   * @Return
   */
  @Query("select pl from PositionLevelEntity pl where pl.code = :code")
  PositionLevelEntity findByCode(@Param("code") String code);

  /**
   * 根据名称查询
   * @param name
   * @return
   */
  @Query("select pl from PositionLevelEntity pl where pl.name = :name")
  PositionLevelEntity findByName(@Param("name") String name);
}
