package com.bizunited.platform.user.service.local.repository.internal;

import com.bizunited.platform.user.service.local.entity.AdministrativeRegionEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description :
 * @Author : chengzhongxiang
 * @Date: 2020-08-28 09:43
 */
@Repository("AdministrativeRegionEntityRepositoryCustomImpl")
public class AdministrativeRegionRepositoryCustomImpl implements AdministrativeRegionRepositoryCustom {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String REGIONNAME = "regionName";
  private static final String LONGITUDE = "longitude";
  private static final String LATITUDE = "latitude";
  private static final String REGIONCODE = "regionCode";

  /**
   * 分页查询,若查询条件为空则查询所有顶级区域
   *
   * @param conditions
   * @return
   */
  @Override
  @SuppressWarnings("unchecked")
  public List<AdministrativeRegionEntity> findByConditions(Map<String, Object> conditions) {
    StringBuilder hql = new StringBuilder("from AdministrativeRegionEntity ar where 1 = 1");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>();
    Object regionName = conditions.get(REGIONNAME);
    if (regionName != null) {
      condition.append(" AND ar.regionName like CONCAT('%',:regionName,'%')");
      parameter.put("regionName", regionName);
    }
    Object longitude = conditions.get(LONGITUDE);
    if (longitude != null) {
      condition.append(" AND ar.longitude like CONCAT('%',:longitude,'%')");
      parameter.put("longitude", longitude);
    }
    Object latitude = conditions.get(LATITUDE);
    if (latitude != null) {
      condition.append(" AND ar.latitude like CONCAT('%',:latitude,'%')");
      parameter.put("latitude", latitude);
    }
    Object regionCode = conditions.get(REGIONCODE);
    if (regionCode != null) {
      condition.append(" AND ar.regionCode like CONCAT('%',:regionCode,'%')");
      parameter.put("regionCode", regionCode);
    }
    hql.append(condition).append("order by ar.id");

    Query query = entityManager.createQuery(hql.toString());
    parameter.forEach(query::setParameter);
    return query.getResultList();
  }
}
