package com.bizunited.platform.user.service.local.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.user.service.local.entity.PositionLevelEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;


/**
 * 职位接级别持久化自定义实现
 * @author: weikangning
 * @Date: 2020/8/16 17:50
 */
@Service
public class PositionLevelRepositoryImpl implements PositionLevelRepositoryCustom, PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;

  @Override
  public Page<PositionLevelEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
    StringBuilder hql = new StringBuilder("from PositionLevelEntity u where 1=1 ");
    StringBuilder countHql = new StringBuilder("select count(*) from PositionLevelEntity u where 1=1");
    StringBuilder conditionHql = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>();
    if(conditions != null) {
      String name = (String) conditions.get("name");
      if (StringUtils.isNotBlank(name)) {
        conditionHql.append(" AND u.name like CONCAT(CONCAT('%',:name),'%') ");
        parameter.put("name", name);
      }
      String code = (String) conditions.get("code");
      if (StringUtils.isNotBlank(code)) {
        conditionHql.append(" AND u.code = :code ");
        parameter.put("code", code);
      }
    }
    hql.append(conditionHql).append("  order by u.createTime desc ");
    countHql.append(conditionHql);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
  }


}
