package com.bizunited.platform.user.service.local.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.user.common.vo.PositionSimpleVo;
import com.bizunited.platform.user.service.local.entity.PositionEntity;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * PositionRepositoryImpl
 *
 * @description:
 * @author: yanwe
 * @date: 18/Jan/2019 15:14
 */
@Repository("PositionRepositoryImpl")
public class PositionRepositoryImpl implements PositionRepositoryCustom, PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String T_STATUS = "tstatus";
  private static final String NAME = "name";
  private static final String NAME_EQUAL = "nameEqual";
  private static final String USERNAME = "userName";
  private static final String IDS = "ids";
  private static final String CODE = "code";
  private static final String CODES = "codes";
  private static final String POSITIONLEVE = "positionLevel";
  private static final String ORGNAME = "orgName";

  @Override
  public Page<PositionEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
    if(conditions == null) {
      conditions = Maps.newHashMap();
    }
    StringBuilder hql = new StringBuilder("from PositionEntity p left join fetch p.positionLevel pl ");
    hql.append(" left join fetch p.users u ");
    hql.append(" left join fetch p.organization organization ");
    hql.append(" where 1 = 1 ");
    StringBuilder countHql = new StringBuilder("select count(DISTINCT p.id) from PositionEntity p " +
            "left join p.positionLevel pl  left join p.users u left join p.organization o where 1 = 1");
    Object nameEqual = conditions.get(NAME_EQUAL);
    Map<String, Object> parameters = Maps.newHashMap();
    StringBuilder condition = new StringBuilder();
    //职位名称
    if (nameEqual != null) {
      condition.append(" AND p.name like CONCAT('%',:nameEqual,'%') ");
      parameters.put(NAME_EQUAL, nameEqual);
    }
    //职位编码
    Object code = conditions.get(CODE);
    if (code != null) {
      condition.append(" AND p.code = :code ");
      parameters.put(CODE, code);
    }
    //职位状态
    Object tstatus = conditions.get(T_STATUS);
    if (tstatus != null) {
      condition.append(" AND p.tstatus = :tstatus ");
      parameters.put(T_STATUS, tstatus);
    }
    Object flagObject = conditions.get("flag");
    int flag = flagObject == null ? 1 : (int) flagObject;
    // 职位id集合，如果flag为1则查询集合内的，反之则查集合外的
    Object ids = conditions.get(IDS);
    if (ids != null && !CollectionUtils.isEmpty((Collection<?>) ids)) {
      parameters.put(IDS, ids);
      if (flag == 1) {
        condition.append(" AND p.id in :ids");
      } else {
        condition.append(" AND p.id not in :ids");
      }
    }
    //若flag为1则查询在code集合中的，为0则查询不在code集合中的
    Object codes = conditions.get(CODES);
    if (codes != null && !CollectionUtils.isEmpty((Collection<?>) codes)) {
      parameters.put(CODES, codes);
      if (flag == 1) {
        condition.append(" AND p.code in :codes");
      } else {
        condition.append(" AND p.code not in :codes");
      }
    }
    //职位名称
    Object name = conditions.get(NAME);
    if (name != null) {
      if (StringUtils.isNotBlank((CharSequence) name)) {
        parameters.put(NAME, name);
        condition.append(" AND p.name like CONCAT('%',:name,'%')");
      }
    }
    //用户名称
    Object userName = conditions.get(USERNAME);
    if (userName != null) {
      if (StringUtils.isNotBlank((CharSequence) userName)) {
        parameters.put(USERNAME, userName);
        condition.append(" AND u.userName like CONCAT('%',:userName,'%')");
      }
    }
    //职位级别
    Object positionLevel = conditions.get(POSITIONLEVE);
    if (positionLevel != null) {
      parameters.put(POSITIONLEVE, positionLevel);
      condition.append(" AND pl.id =:positionLevel");
    }
    //组织名称
    Object orgName = conditions.get(ORGNAME);
    if (orgName != null) {
      if (StringUtils.isNotBlank((CharSequence) orgName)) {
        parameters.put(ORGNAME, orgName);
        condition.append(" AND o.orgName like CONCAT('%',:orgName,'%')");
      }
    }
    hql.append(condition).append(" order by p.createTime desc ");
    countHql.append(condition);
    return this.queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
  }

  /**
   * 分页条件查询，根据职位带出用户信息
   *
   * @param pageable
   * @param conditions
   * @return
   */
  @Override
  public Page<PositionSimpleVo> findByPositionLevelAndConditions(Pageable pageable, Map<String, Object> conditions) {
    //因为此方法主要参数为职级，所有职级必传，且不能为空
    if (conditions == null || StringUtils.isBlank((String) conditions.get(POSITIONLEVE))) {
      return Page.empty(pageable);
    }
    StringBuilder sql = new StringBuilder("SELECT " +
            "ep.id id," +
            "ep.`code` code," +
            "ep.`name` name," +
            "u.user_name userName," +
            "eue.`code` userCode," +
            "org.org_name orgName, " +
            "ep.create_time createTime " +
            "FROM " +
            "engine_position ep " +
            "LEFT JOIN engine_position_user_mapping epu ON epu.position_id = ep.id " +
            "LEFT JOIN engine_user u ON u.id = epu.user_id " +
            "LEFT JOIN engine_user_extend eue ON u.id = eue.user_id " +
            "LEFT JOIN engine_org org ON ep.organization_id = org.id where 1 = 1");
    StringBuilder countSql = new StringBuilder("SELECT count(*)" +
            "FROM " +
            "engine_position ep " +
            "LEFT JOIN engine_position_user_mapping epu ON epu.position_id = ep.id " +
            "LEFT JOIN engine_user u ON u.id = epu.user_id " +
            "LEFT JOIN engine_user_extend eue ON u.id = eue.user_id " +
            "LEFT JOIN engine_org org ON ep.organization_id = org.id where 1 = 1");
    StringBuilder condition = new StringBuilder();
    HashMap<String, Object> parameter = Maps.newHashMap();
    //职位名称
    Object name = conditions.get(NAME);
    if (name != null) {
      condition.append(" AND ep.name like CONCAT('%', :name, '%')");
      parameter.put(NAME, name);
    }
    //组织名称
    Object orgName = conditions.get(ORGNAME);
    if (orgName != null) {
      condition.append(" AND org.org_name like CONCAT('%', :orgName, '%')");
      parameter.put(ORGNAME, orgName);
    }
    //用户名称
    Object userName = conditions.get(USERNAME);
    if (userName != null) {
      condition.append(" AND u.user_name like CONCAT('%', :userName, '%')");
      parameter.put(USERNAME, userName);
    }
    //职级ID
    Object positionLevel = conditions.get(POSITIONLEVE);
    if (positionLevel != null) {
      condition.append(" AND ep.position_level_id = :positionLevel ");
      parameter.put("positionLevel", positionLevel);
    }
    sql.append(condition).append(" order by ep.create_time");
    countSql.append(condition);
    return queryByConditions(entityManager, sql.toString(), countSql.toString(), parameter, pageable, true, PositionSimpleVo.class);
  }

}
