package com.bizunited.platform.user.service.local.service.internal;

import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.user.common.service.UserExtentFieldService;
import com.bizunited.platform.user.common.vo.UserExtentFieldVo;
import com.bizunited.platform.user.service.local.entity.UserExtentFieldEntity;
import com.bizunited.platform.user.service.local.repository.UserExtentFieldServiceRepository;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
/**
 * 附加字段功能接口实现
 * @Author: zengxingwang
 * @Date: 2020/4/7 14:03
 */
public class UserExtentFieldServiceImpl implements UserExtentFieldService {

  @Autowired
  private UserExtentFieldServiceRepository userExtentFieldServiceRepository;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  /**
   * 配置附加字段
   * @param userExtentFieldVos
   * @return
   */
  @Override
  @Transactional
  public List<UserExtentFieldVo> save(List<UserExtentFieldVo> userExtentFieldVos) {
    this.validateUserExtentField(userExtentFieldVos);

    //新增集合
    Set<UserExtentFieldEntity> needInsertUserExtentFields = new HashSet<>();
    //更新集合
    Set<UserExtentFieldEntity> needUpdateUserExtentFields = new HashSet<>();
    //删除集合
    Set<UserExtentFieldEntity> needDeleteUserExtentFields = new HashSet<>();

    Set<UserExtentFieldEntity> result = new HashSet<>();
    Map<String, UserExtentFieldVo> fieldVoMap = new HashMap<>();
    for(UserExtentFieldVo fieldVo : userExtentFieldVos){
      fieldVoMap.put(fieldVo.getFieldName(), fieldVo);
    }

    List<UserExtentFieldEntity> existUserExtentFields = userExtentFieldServiceRepository.findAll();
    Collection<UserExtentFieldEntity> userExtentFields = nebulaToolkitService.copyCollectionByWhiteList(userExtentFieldVos, UserExtentFieldVo.class, UserExtentFieldEntity.class, HashSet.class, ArrayList.class);

    nebulaToolkitService.collectionDiscrepancy(userExtentFields, existUserExtentFields, UserExtentFieldEntity::getFieldName, needDeleteUserExtentFields, needUpdateUserExtentFields, needInsertUserExtentFields);

    //新增
    if(!CollectionUtils.isEmpty(needInsertUserExtentFields)) {
      userExtentFieldServiceRepository.saveAll(needInsertUserExtentFields);
      result.addAll(needInsertUserExtentFields);
    }
    //修改
    if(!CollectionUtils.isEmpty(needUpdateUserExtentFields)) {
      for(UserExtentFieldEntity fieldEntity : needUpdateUserExtentFields){
        UserExtentFieldVo updateField = fieldVoMap.get(fieldEntity.getFieldName());
        fieldEntity.setFieldComment(updateField.getFieldComment());
        fieldEntity.setRequired(updateField.getRequired());
        fieldEntity.setShowSearch(updateField.getShowSearch());
        fieldEntity.setState(updateField.getState());
        userExtentFieldServiceRepository.save(fieldEntity);
        result.add(fieldEntity);
      }
    }
    if(!CollectionUtils.isEmpty(needDeleteUserExtentFields)){
      result.addAll(needDeleteUserExtentFields);
    }
    Collection<UserExtentFieldVo> resultUserExtentFields = nebulaToolkitService.copyCollectionByWhiteList(result, UserExtentFieldEntity.class, UserExtentFieldVo.class, HashSet.class, ArrayList.class);
    return Lists.newArrayList(resultUserExtentFields);
  }

  /**
   * 查询所有配置
   * @return
   */
  @Override
  public List<UserExtentFieldVo> findAll() {
    List<UserExtentFieldEntity> userExtentFields = userExtentFieldServiceRepository.findAll();
    if(CollectionUtils.isEmpty(userExtentFields)){
      return Lists.newArrayList();
    }
    Collection<UserExtentFieldVo> userExtentFieldVos = nebulaToolkitService.copyCollectionByWhiteList(userExtentFields, UserExtentFieldEntity.class, UserExtentFieldVo.class, HashSet.class, ArrayList.class);
    return Lists.newArrayList(userExtentFieldVos);
  }

  /**
   * 验证每一条配置
   * @param userExtentFieldVos
   */
  private void validateUserExtentField(List<UserExtentFieldVo> userExtentFieldVos) {
    Validate.notEmpty(userExtentFieldVos, "配置字段信息不能为空，请检查");
    for(UserExtentFieldVo userExtentFieldVo : userExtentFieldVos){
      Validate.notBlank(userExtentFieldVo.getFieldName(), "字段名称不能为空");
      Validate.notBlank(userExtentFieldVo.getFieldComment(), "字段描述不能为空");
      Validate.notNull(userExtentFieldVo.getState(), "状态不能为空");
      Validate.notNull(userExtentFieldVo.getShowSearch(), "显示框状态不能为空");
      Validate.notNull(userExtentFieldVo.getRequired(), "是否必填不能为空");
    }
  }
}
