/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.local.repository;

import com.bizunited.platform.user.service.local.entity.OrganizationEntity;
import com.bizunited.platform.user.service.local.repository.internal.OrganizationRepositoryCustom;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="OrganizationRepository")
public interface OrganizationRepository
extends JpaRepository<OrganizationEntity, String>,
JpaSpecificationExecutor<OrganizationEntity>,
OrganizationRepositoryCustom {
    @Modifying
    @Query(value="update engine_org set parent_id = :parentOrgId where id = :currentOrgId", nativeQuery=true)
    public void bindParent(@Param(value="currentOrgId") String var1, @Param(value="parentOrgId") String var2);

    @Modifying
    @Query(value="update engine_org set parent_id = null where id = :currentOrgId", nativeQuery=true)
    public void unbindParent(@Param(value="currentOrgId") String var1);

    @Modifying
    @Query(value="insert into engine_org_user_mapping (org_id , user_id) values (:currentOrgId , :userId)", nativeQuery=true)
    public void bindUsers(@Param(value="currentOrgId") String var1, @Param(value="userId") String var2);

    @Modifying
    @Query(value="delete from engine_org_user_mapping where user_id = :userId", nativeQuery=true)
    public void unbindUser(@Param(value="userId") String var1);

    @Modifying
    @Query(value="delete from engine_org_user_mapping where user_id = :userId and org_id = :currentOrgId", nativeQuery=true)
    public void unbindUser(@Param(value="currentOrgId") String var1, @Param(value="userId") String var2);

    @Modifying
    @Query(value="insert into engine_org_role_mapping (org_id , role_id) values (:currentOrgId , :roleId)", nativeQuery=true)
    public void bindRole(@Param(value="currentOrgId") String var1, @Param(value="roleId") String var2);

    @Modifying
    @Query(value="delete from engine_org_role_mapping where role_id = :roleId", nativeQuery=true)
    public void unbindRole(@Param(value="roleId") String var1);

    @Modifying
    @Query(value="delete from engine_org_role_mapping where role_id = :roleId and org_id = :currentOrgId", nativeQuery=true)
    public void unbindRole(@Param(value="currentOrgId") String var1, @Param(value="roleId") String var2);

    @Query(value="select distinct org from OrganizationEntity org where org.parent is null order by org.sortIndex, org.createTime desc")
    public Set<OrganizationEntity> findByNullParent();

    @Query(value="from OrganizationEntity org where org.parent.id = :parentId order by org.sortIndex, org.createTime desc")
    public Set<OrganizationEntity> findByParent(@Param(value="parentId") String var1);

    @Query(value="from OrganizationEntity org where org.parent is null and org.tstatus = :status order by org.sortIndex, org.createTime desc")
    public List<OrganizationEntity> findByNullParentAndStatus(@Param(value="status") Integer var1);

    @Query(value="from OrganizationEntity org where org.parent.id = :parentId and org.tstatus = :status order by org.sortIndex, org.createTime desc")
    public Set<OrganizationEntity> findByParentAndStatus(@Param(value="parentId") String var1, @Param(value="status") Integer var2);

    @Query(value="from OrganizationEntity org left join fetch org.parent pp where org.orgName = :orgName order by org.sortIndex, org.createTime desc")
    public Set<OrganizationEntity> findByOrgName(@Param(value="orgName") String var1);

    @Query(value="from OrganizationEntity org  where org.code = :code")
    public OrganizationEntity findByCode(@Param(value="code") String var1);

    @Query(value="select distinct org from OrganizationEntity org left join fetch org.parent left join fetch org.child left join fetch org.users left join fetch org.positions where org.id = :id")
    public OrganizationEntity findDetailsById(@Param(value="id") String var1);

    @Query(value="select distinct org from OrganizationEntity org left join fetch org.users u  where u.id = :userId order by org.sortIndex, org.createTime desc")
    public Set<OrganizationEntity> findByUserId(@Param(value="userId") String var1);

    @Query(value="SELECT COUNT(*) FROM engine_org_role_mapping WHERE org_id = :currentOrgId AND role_id = :roleId", nativeQuery=true)
    public long countByOrgAndRoleId(@Param(value="currentOrgId") String var1, @Param(value="roleId") String var2);

    @Query(value="SELECT COUNT(*) FROM engine_org_user_mapping WHERE org_id = :currentOrgId AND user_id = :userId", nativeQuery=true)
    public long countByOrgIdAndUserId(@Param(value="currentOrgId") String var1, @Param(value="userId") String var2);

    @Query(value="select org from OrganizationEntity org where org.tstatus = 1")
    public List<OrganizationEntity> findAllByStatus();

    @Query(value="from OrganizationEntity org left join fetch org.parent order by org.createTime desc ")
    public List<OrganizationEntity> findAll();

    @Query(value="from OrganizationEntity m where m.id in :ids")
    public Set<OrganizationEntity> findByIds(@Param(value="ids") List<String> var1);

    @Query(value="from OrganizationEntity m left join fetch m.child m_child where m.id in :ids")
    public Set<OrganizationEntity> findDetailsByIds(@Param(value="ids") Set<String> var1);

    @Query(value="from OrganizationEntity org where orgName like CONCAT(CONCAT('%',:orgName),'%') order by org.sortIndex, org.createTime desc")
    public Set<OrganizationEntity> findByOrgNameLike(@Param(value="orgName") String var1);

    @Query(value="SELECT COUNT(*) FROM engine_org_user_mapping WHERE user_id = :userId", nativeQuery=true)
    public long countOrganizationByUserId(@Param(value="userId") String var1);

    @Query(value="SELECT COUNT(*) FROM engine_org_user_mapping WHERE org_id = :currentOrgId", nativeQuery=true)
    public long countUserByOrgId(@Param(value="currentOrgId") String var1);

    @Query(value="SELECT COUNT(*) FROM engine_org_role_mapping WHERE role_id = :roleId", nativeQuery=true)
    public long countOrganizationByRoleId(@Param(value="roleId") String var1);

    @Query(value="SELECT COUNT(*) FROM engine_org_role_mapping WHERE org_id = :currentOrgId", nativeQuery=true)
    public long countRoleByOrgId(@Param(value="currentOrgId") String var1);

    @Query(value="select o from OrganizationEntity o inner join o.child c where c.id = :childId")
    public OrganizationEntity findByChildId(@Param(value="childId") String var1);

    @Query(value="select org from OrganizationEntity org inner join org.users u where org.id = :orgId and u.id = :userId")
    public OrganizationEntity findByIdAndUserId(@Param(value="orgId") String var1, @Param(value="userId") String var2);

    @Query(value="select MAX(org.dimensionalityCode) from OrganizationEntity org where org.level = :level")
    public String findMaxDimensionalityCodeByLevel(@Param(value="level") Integer var1);

    @Query(value="select MAX(org.dimensionalityCode) from OrganizationEntity org where org.parent.id = :parentId and org.id <> :orgId")
    public String findMaxChildrenDimensionalityCodeByParentId(@Param(value="parentId") String var1, @Param(value="orgId") String var2);

    @Query(value="select org from OrganizationEntity org where org.id = :id or org.parent.id = :id")
    public List<OrganizationEntity> findByIdAndParentId(@Param(value="id") String var1);

    @Modifying
    @Query(value="insert into engine_org_region_mapping (org_id , region_id) values (:orgId , :regionId)", nativeQuery=true)
    public void bindRegion(@Param(value="orgId") String var1, @Param(value="regionId") String var2);

    @Modifying
    @Query(value="delete from engine_org_region_mapping where org_id = :orgId", nativeQuery=true)
    public void unbindRegionsByOrgId(@Param(value="orgId") String var1);

    @Modifying
    @Query(value="delete from engine_org_region_mapping where org_id = :orgId and region_id = :regionId", nativeQuery=true)
    public void unbindRegion(@Param(value="orgId") String var1, @Param(value="regionId") String var2);

    @Query(value="select o from OrganizationEntity o where o.level = :level order by o.sortIndex asc")
    public List<OrganizationEntity> findByLevel(@Param(value="level") Integer var1);
}

