/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.local.repository;

import com.bizunited.platform.user.service.local.entity.OrganizationEntity;
import com.bizunited.platform.user.service.local.entity.PositionEntity;
import com.bizunited.platform.user.service.local.repository.internal.PositionRepositoryCustom;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="PositionRepository")
public interface PositionRepository
extends JpaRepository<PositionEntity, String>,
JpaSpecificationExecutor<PositionEntity>,
PositionRepositoryCustom {
    public PositionEntity findByCode(@Param(value="code") String var1);

    public List<PositionEntity> findByName(@Param(value="name") String var1);

    @Query(value="select distinct position from PositionEntity position left join fetch position.organization left join fetch position.users left join fetch position.parent where position.id = :id")
    public PositionEntity findDetailsById(@Param(value="id") String var1);

    @Query(value="select distinct position from PositionEntity position left join fetch position.organization left join fetch position.users left join fetch position.positionLevel where position.code = :code ")
    public PositionEntity findDetailsByCode(@Param(value="code") String var1);

    public List<PositionEntity> findALlByOrAndOrganization(OrganizationEntity var1);

    @Query(value="SELECT COUNT(*) FROM engine_position_user_mapping WHERE user_id = :userId AND position_id = :positionId", nativeQuery=true)
    public long countByUserAndPosition(@Param(value="userId") String var1, @Param(value="positionId") String var2);

    @Modifying
    @Query(value="insert into engine_position_user_mapping(user_id,position_id) values (:userId,:positionId)", nativeQuery=true)
    public void bindUser(@Param(value="userId") String var1, @Param(value="positionId") String var2);

    @Modifying
    @Query(value="delete from engine_position_user_mapping where user_id = :userId and position_id = :positionId", nativeQuery=true)
    public void unbindUser(@Param(value="userId") String var1, @Param(value="positionId") String var2);

    @Modifying
    @Query(value="delete from engine_position_user_mapping where user_id = :userId", nativeQuery=true)
    public void unbindusers(@Param(value="userId") String var1);

    @Query(value="from PositionEntity m where m.id in :ids")
    public Set<PositionEntity> findByIds(@Param(value="ids") List<String> var1);

    @Query(value="select p from PositionEntity p inner join fetch p.users u left join fetch p.children where u.id = :userId")
    public Set<PositionEntity> findDetailsByUserId(@Param(value="userId") String var1);

    @Query(value="select p from PositionEntity p inner join p.users u where u.id = :userId order by p.createTime desc")
    public Set<PositionEntity> findByUserId(@Param(value="userId") String var1);

    @Query(value="select p from PositionEntity p inner join p.users u where u.account = :userAccount order by p.createTime desc")
    public Set<PositionEntity> findByUserAccount(@Param(value="userAccount") String var1);

    @Query(value="SELECT COUNT(*) FROM engine_position_user_mapping WHERE user_id = :userId", nativeQuery=true)
    public long countPositionByUserId(@Param(value="userId") String var1);

    @Query(value="SELECT COUNT(*) FROM engine_position_user_mapping WHERE position_id = :positionId", nativeQuery=true)
    public long countUserByPositionId(@Param(value="positionId") String var1);

    @Query(value="from PositionEntity m where m.tstatus =:tstatus order by m.createTime desc ")
    public List<PositionEntity> findByTstatus(@Param(value="tstatus") int var1);

    @Query(value="SELECT MAX(name) FROM engine_position WHERE position_level_id = :levelId", nativeQuery=true)
    public String findMaxName(@Param(value="levelId") String var1);

    @Query(value="select p from PositionEntity p left join fetch p.positionLevel left join fetch p.users left join fetch p.organization o left join fetch p.children children where o.code = :orgCode ")
    public List<PositionEntity> findDetailsByOrgCode(@Param(value="orgCode") String var1);

    @Query(value="select p from PositionEntity p left join fetch p.users left join fetch p.organization o where p.parent.id = :parentId ")
    public List<PositionEntity> findDetailsByParentId(@Param(value="parentId") String var1);

    @Query(value="select p from PositionEntity p inner join p.users u where u.account = :account order by p.createTime desc")
    public Set<PositionEntity> findByAccount(@Param(value="account") String var1);

    @Query(value="select p from PositionEntity p left join fetch p.positionLevel left join fetch p.organization left join fetch p.users where p.positionLevel.id in :positionLevelIds")
    public Set<PositionEntity> findByPositionLevelIds(@Param(value="positionLevelIds") String[] var1);

    @Query(value="select distinct p from PositionEntity p left join fetch p.users left join fetch p.organization left join fetch p.positionLevel")
    public Set<PositionEntity> findAllDetail();
}

