/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.local.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.user.common.vo.PositionSimpleVo;
import com.bizunited.platform.user.service.local.entity.PositionEntity;
import com.bizunited.platform.user.service.local.repository.internal.PositionRepositoryCustom;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="PositionRepositoryImpl")
public class PositionRepositoryImpl
implements PositionRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    private static final String T_STATUS = "tstatus";
    private static final String NAME = "name";
    private static final String NAME_EQUAL = "nameEqual";
    private static final String USERNAME = "userName";
    private static final String IDS = "ids";
    private static final String CODE = "code";
    private static final String CODES = "codes";
    private static final String POSITIONLEVE = "positionLevel";
    private static final String ORGNAME = "orgName";

    @Override
    public Page<PositionEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
        Object orgName;
        Object positionLevel;
        Object userName;
        Object name;
        Object codes;
        Object flagObject;
        Object tstatus;
        Object code;
        if (conditions == null) {
            conditions = Maps.newHashMap();
        }
        StringBuilder hql = new StringBuilder("from PositionEntity p left join fetch p.positionLevel pl ");
        hql.append(" left join fetch p.users u ");
        hql.append(" left join fetch p.organization organization ");
        hql.append(" where 1 = 1 ");
        StringBuilder countHql = new StringBuilder("select count(DISTINCT p.id) from PositionEntity p left join p.positionLevel pl  left join p.users u left join p.organization o where 1 = 1");
        Object nameEqual = conditions.get(NAME_EQUAL);
        HashMap parameters = Maps.newHashMap();
        StringBuilder condition = new StringBuilder();
        if (nameEqual != null) {
            condition.append(" AND p.name like CONCAT('%',:nameEqual,'%') ");
            parameters.put(NAME_EQUAL, nameEqual);
        }
        if ((code = conditions.get(CODE)) != null) {
            condition.append(" AND p.code = :code ");
            parameters.put(CODE, code);
        }
        if ((tstatus = conditions.get(T_STATUS)) != null) {
            condition.append(" AND p.tstatus = :tstatus ");
            parameters.put(T_STATUS, tstatus);
        }
        int flag = (flagObject = conditions.get("flag")) == null ? 1 : (Integer)flagObject;
        Object ids = conditions.get(IDS);
        if (ids != null && !CollectionUtils.isEmpty((Collection)((Collection)ids))) {
            parameters.put(IDS, ids);
            if (flag == 1) {
                condition.append(" AND p.id in :ids");
            } else {
                condition.append(" AND p.id not in :ids");
            }
        }
        if ((codes = conditions.get(CODES)) != null && !CollectionUtils.isEmpty((Collection)((Collection)codes))) {
            parameters.put(CODES, codes);
            if (flag == 1) {
                condition.append(" AND p.code in :codes");
            } else {
                condition.append(" AND p.code not in :codes");
            }
        }
        if ((name = conditions.get(NAME)) != null && StringUtils.isNotBlank((CharSequence)((CharSequence)name))) {
            parameters.put(NAME, name);
            condition.append(" AND p.name like CONCAT('%',:name,'%')");
        }
        if ((userName = conditions.get(USERNAME)) != null && StringUtils.isNotBlank((CharSequence)((CharSequence)userName))) {
            parameters.put(USERNAME, userName);
            condition.append(" AND u.userName like CONCAT('%',:userName,'%')");
        }
        if ((positionLevel = conditions.get(POSITIONLEVE)) != null) {
            parameters.put(POSITIONLEVE, positionLevel);
            condition.append(" AND pl.id =:positionLevel");
        }
        if ((orgName = conditions.get(ORGNAME)) != null && StringUtils.isNotBlank((CharSequence)((CharSequence)orgName))) {
            parameters.put(ORGNAME, orgName);
            condition.append(" AND o.orgName like CONCAT('%',:orgName,'%')");
        }
        hql.append((CharSequence)condition).append(" order by p.createTime desc ");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
    }

    @Override
    public Page<PositionSimpleVo> findByPositionLevelAndConditions(Pageable pageable, Map<String, Object> conditions) {
        Object positionLevel;
        Object userName;
        Object orgName;
        if (conditions == null || StringUtils.isBlank((CharSequence)((String)conditions.get(POSITIONLEVE)))) {
            return Page.empty((Pageable)pageable);
        }
        StringBuilder sql = new StringBuilder("SELECT ep.id id,ep.`code` code,ep.`name` name,u.user_name userName,eue.`code` userCode,org.org_name orgName, ep.create_time createTime FROM engine_position ep LEFT JOIN engine_position_user_mapping epu ON epu.position_id = ep.id LEFT JOIN engine_user u ON u.id = epu.user_id LEFT JOIN engine_user_extend eue ON u.id = eue.user_id LEFT JOIN engine_org org ON ep.organization_id = org.id where 1 = 1");
        StringBuilder countSql = new StringBuilder("SELECT count(*)FROM engine_position ep LEFT JOIN engine_position_user_mapping epu ON epu.position_id = ep.id LEFT JOIN engine_user u ON u.id = epu.user_id LEFT JOIN engine_user_extend eue ON u.id = eue.user_id LEFT JOIN engine_org org ON ep.organization_id = org.id where 1 = 1");
        StringBuilder condition = new StringBuilder();
        HashMap parameter = Maps.newHashMap();
        Object name = conditions.get(NAME);
        if (name != null) {
            condition.append(" AND ep.name like CONCAT('%', :name, '%')");
            parameter.put(NAME, name);
        }
        if ((orgName = conditions.get(ORGNAME)) != null) {
            condition.append(" AND org.org_name like CONCAT('%', :orgName, '%')");
            parameter.put(ORGNAME, orgName);
        }
        if ((userName = conditions.get(USERNAME)) != null) {
            condition.append(" AND u.user_name like CONCAT('%', :userName, '%')");
            parameter.put(USERNAME, userName);
        }
        if ((positionLevel = conditions.get(POSITIONLEVE)) != null) {
            condition.append(" AND ep.position_level_id = :positionLevel ");
            parameter.put(POSITIONLEVE, positionLevel);
        }
        sql.append((CharSequence)condition).append(" order by ep.create_time");
        countSql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, sql.toString(), countSql.toString(), parameter, pageable, true, PositionSimpleVo.class);
    }
}

