/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.local.service.init;

import com.bizunited.platform.common.service.init.InitProcessService;
import com.bizunited.platform.user.common.service.UserMappingService;
import com.bizunited.platform.user.service.local.entity.UserEntity;
import com.bizunited.platform.user.service.local.repository.UserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component(value="UserInitProcess")
public class UserInitProcess
implements InitProcessService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    @Qualifier(value="passwordEncoder")
    @Lazy
    private PasswordEncoder passwordEncoder;
    @Autowired
    private UserMappingService userMappingService;

    public boolean doProcess() {
        return this.userRepository.findByAccount("admin") == null || this.userMappingService.findOne() == null;
    }

    public int sort() {
        return 1;
    }

    public boolean stopOnException() {
        return true;
    }

    public void init() {
        if (this.userRepository.findByAccount("admin") == null) {
            this.initAdmin();
        }
        this.userMappingService.init();
    }

    private void initAdmin() {
        UserEntity admin = new UserEntity();
        admin.setAccount("admin");
        admin.setGender(0);
        admin.setPassword(this.passwordEncoder.encode((CharSequence)"12345678"));
        admin.setPhone("12345678");
        admin.setUserName("\u540e\u53f0\u8d85\u7ea7\u7ba1\u7406\u5458");
        admin.setUseStatus(1);
        this.userRepository.saveAndFlush((Object)admin);
    }
}

