/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.local.service.internal;

import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.user.common.enums.RegionLevelEnum;
import com.bizunited.platform.user.common.service.region.AdministrativeRegionService;
import com.bizunited.platform.user.common.vo.AdministrativeRegionVo;
import com.bizunited.platform.user.service.local.entity.AdministrativeRegionEntity;
import com.bizunited.platform.user.service.local.repository.AdministrativeRegionRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.CollectionUtils;

public class AdministrativeRegionServiceImpl
implements AdministrativeRegionService {
    @Autowired
    private AdministrativeRegionRepository administrativeRegionRepository;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    private static final String CHILDREN = "children";
    private static final String CHILDREN_CHILDREN = "children.children";

    @Transactional
    public AdministrativeRegionVo create(AdministrativeRegionVo region) {
        this.createValidation(region);
        AdministrativeRegionEntity dbRegion = (AdministrativeRegionEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)region, AdministrativeRegionEntity.class, HashSet.class, ArrayList.class, new String[]{"parent"}));
        dbRegion.setDimensionalityCode("");
        this.initLevel(dbRegion);
        this.administrativeRegionRepository.save((Object)dbRegion);
        return (AdministrativeRegionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbRegion, AdministrativeRegionVo.class, HashSet.class, ArrayList.class, new String[]{"parent"});
    }

    private void initLevel(AdministrativeRegionEntity region) {
        int level = 1;
        AdministrativeRegionEntity parent = region.getParent();
        if (parent != null) {
            AdministrativeRegionEntity dbParent = this.administrativeRegionRepository.findById(parent.getId()).orElse(null);
            Validate.notNull((Object)((Object)dbParent), (String)"\u672a\u627e\u5230\u4e0a\u7ea7\u533a\u57df\uff1a%s", (Object[])new Object[]{parent.getId()});
            ++level;
            while ((dbParent = dbParent.getParent()) != null) {
                ++level;
            }
        }
        region.setRegionLevel(level);
    }

    private void createValidation(AdministrativeRegionVo region) {
        AdministrativeRegionEntity dbRegion;
        Validate.notNull((Object)region, (String)"\u884c\u653f\u533a\u57df\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((region.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u4e0d\u80fd\u6709\u4e3b\u952eID", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)region.getRegionCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)region.getRegionName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)region.getLongitude(), (String)"\u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)region.getLatitude(), (String)"\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        AdministrativeRegionVo parent = region.getParent();
        if (parent != null) {
            Validate.notBlank((CharSequence)parent.getId(), (String)"\u4e0a\u7ea7\u533a\u57dfID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            AdministrativeRegionEntity dbParent = this.administrativeRegionRepository.findById(parent.getId()).orElse(null);
            Validate.notNull((Object)((Object)dbParent), (String)"\u672a\u627e\u5230\u4e0a\u7ea7\u533a\u57df\uff1a%s", (Object[])new Object[]{parent.getId()});
        }
        Validate.isTrue(((dbRegion = this.administrativeRegionRepository.findByRegionCode(region.getRegionCode())) == null ? 1 : 0) != 0, (String)"\u884c\u653f\u533a\u57df\u5df2\u5b58\u5728: %s\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (Object[])new Object[]{region.getRegionCode()});
    }

    @NebulaServiceMethod(name="AdministrativeRegionService.findDetailsById", desc="\u6839\u636eID\u67e5\u8be2\u660e\u7ec6", scope=NebulaServiceMethod.ScopeType.READ, returnPropertiesFilterB="..children,..orgs")
    public AdministrativeRegionVo findDetailsById(@ServiceMethodParam(name="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AdministrativeRegionEntity current = this.administrativeRegionRepository.findDetailsById(id);
        if (current == null) {
            return null;
        }
        return (AdministrativeRegionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, AdministrativeRegionVo.class, HashSet.class, ArrayList.class, new String[]{"..children"});
    }

    public AdministrativeRegionVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AdministrativeRegionEntity administrativeRegionEntity = this.administrativeRegionRepository.findById(id).orElse(null);
        if (administrativeRegionEntity == null) {
            return null;
        }
        return (AdministrativeRegionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)administrativeRegionEntity, AdministrativeRegionVo.class, HashSet.class, ArrayList.class, new String[]{CHILDREN, CHILDREN_CHILDREN});
    }

    @NebulaServiceMethod(name="AdministrativeRegionService.findByParentIdOrConditions", desc="\u6839\u636e\u4e0a\u7ea7\u7ec4\u7ec7ID\u6216\u591a\u6761\u4ef6\u67e5\u8be2", returnPropertiesFilterB="..parent,..orgs", scope=NebulaServiceMethod.ScopeType.READ)
    public List<AdministrativeRegionVo> findByParentIdOrConditions(InvokeParams invokeParams) {
        invokeParams = (InvokeParams)ObjectUtils.defaultIfNull((Object)invokeParams, (Object)new InvokeParams());
        Map params = invokeParams.getInvokeParams();
        HashSet keys = Sets.newHashSet((Object[])new String[]{"parentId", "regionName", "regionCode", "longitude", "latitude"});
        params.entrySet().removeIf(entry -> !keys.contains(entry.getKey()) || entry.getValue() == null || CharSequence.class.isAssignableFrom(entry.getValue().getClass()) && StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue())));
        String parentId = (String)params.get("parentId");
        params.remove("parentId");
        if (CollectionUtils.isEmpty((Map)params)) {
            return this.findByParent(parentId);
        }
        return this.findByConditions(params);
    }

    @NebulaServiceMethod(name="AdministrativeRegionService.findByConditions", desc="\u591a\u6761\u4ef6\u67e5\u8be2\uff0c\u8fd4\u56de\u6811\u7ed3\u6784", returnPropertiesFilterB="..parent,..orgs", scope=NebulaServiceMethod.ScopeType.READ)
    public List<AdministrativeRegionVo> findByConditions(InvokeParams invokeParams) {
        invokeParams = (InvokeParams)ObjectUtils.defaultIfNull((Object)invokeParams, (Object)new InvokeParams());
        Map params = invokeParams.getInvokeParams();
        return this.findByConditions(params);
    }

    public List<AdministrativeRegionVo> findByConditions(Map<String, Object> conditions) {
        List regions;
        conditions = (Map)ObjectUtils.defaultIfNull(conditions, new HashMap());
        HashSet keys = Sets.newHashSet((Object[])new String[]{"parentId", "regionName", "regionCode", "longitude", "latitude"});
        conditions.entrySet().removeIf(entry -> !keys.contains(entry.getKey()) || entry.getValue() == null || CharSequence.class.isAssignableFrom(entry.getValue().getClass()) && StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue())));
        boolean emptyCondition = CollectionUtils.isEmpty((Map)conditions);
        if (emptyCondition) {
            regions = this.administrativeRegionRepository.findAllDetails();
            if (CollectionUtils.isEmpty((Collection)regions)) {
                return Lists.newArrayList();
            }
        } else {
            regions = this.administrativeRegionRepository.findByConditions(conditions);
            if (CollectionUtils.isEmpty((Collection)regions)) {
                return Lists.newArrayList();
            }
            Collection collection = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)regions, AdministrativeRegionEntity.class, AdministrativeRegionEntity.class, LinkedHashSet.class, ArrayList.class, new String[]{"..children", "..orgs"});
            regions = Lists.newArrayList((Iterable)collection);
            this.handleChildren(regions);
        }
        List<AdministrativeRegionEntity> regionTree = this.list2Tree(regions, emptyCondition);
        Collection collection = this.nebulaToolkitService.copyCollectionByBlankList(regionTree, AdministrativeRegionEntity.class, AdministrativeRegionVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"..parent", "..orgs"});
        this.handleEmptyChildren(collection);
        return collection.stream().sorted(Comparator.comparing(UuidVo::getId)).collect(Collectors.toList());
    }

    private void handleEmptyChildren(Collection<AdministrativeRegionVo> collection) {
        for (AdministrativeRegionVo region : collection) {
            List children = region.getChildren();
            if (CollectionUtils.isEmpty((Collection)children)) {
                region.setChildren(null);
                continue;
            }
            this.handleEmptyChildren(children);
        }
    }

    private void handleChildren(List<AdministrativeRegionEntity> regions) {
        for (AdministrativeRegionEntity region : regions) {
            AdministrativeRegionEntity parent = region.getParent();
            while (parent != null) {
                this.addChild(parent, region);
                region = parent;
                parent = region.getParent();
            }
        }
    }

    private void addChild(AdministrativeRegionEntity region, AdministrativeRegionEntity child) {
        List children = region.getChildren();
        children = (List)ObjectUtils.defaultIfNull(children, new ArrayList());
        children.add(child);
        region.setChildren(children);
    }

    public Set<AdministrativeRegionVo> findByRegionLevel(Integer regionLevel) {
        if (regionLevel == null) {
            return Sets.newHashSet();
        }
        List<AdministrativeRegionEntity> administrativeRegionEntities = this.administrativeRegionRepository.findByRegionLevel(regionLevel);
        if (CollectionUtils.isEmpty(administrativeRegionEntities)) {
            return Sets.newHashSet();
        }
        Collection administrativeRegionVos = this.nebulaToolkitService.copyCollectionByWhiteList(administrativeRegionEntities, AdministrativeRegionEntity.class, AdministrativeRegionVo.class, LinkedHashSet.class, LinkedList.class, new String[0]);
        return Sets.newHashSet((Iterable)administrativeRegionVos);
    }

    @NebulaServiceMethod(name="AdministrativeRegionService.findByOrgId", desc="\u6839\u636e\u7ec4\u7ec7ID\u67e5\u8be2\u5173\u8054\u533a\u57df", returnPropertiesFilterB="..children,..orgs", scope=NebulaServiceMethod.ScopeType.READ)
    public List<AdministrativeRegionVo> findByOrgId(@ServiceMethodParam(name="id") String orgId) {
        if (StringUtils.isBlank((CharSequence)orgId)) {
            return Lists.newArrayList();
        }
        Integer level = this.findOrgMappingLevel();
        level = (Integer)ObjectUtils.defaultIfNull((Object)level, (Object)RegionLevelEnum.AREA.getLevel());
        List<AdministrativeRegionEntity> regions = this.administrativeRegionRepository.findByOrgIdAndLevel(orgId, level);
        Collection collection = this.nebulaToolkitService.copyCollectionByBlankList(regions, AdministrativeRegionEntity.class, AdministrativeRegionVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"..children", "..orgs"});
        return Lists.newArrayList((Iterable)collection);
    }

    @NebulaServiceMethod(name="AdministrativeRegionService.findByParent", desc="\u6839\u636e\u7236ID\u67e5\u8be2\u5b50\u533a\u57df", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.READ)
    public List<AdministrativeRegionVo> findByParent(@ServiceMethodParam(name="parentId") String parentId) {
        List<AdministrativeRegionEntity> regions = StringUtils.isBlank((CharSequence)parentId) ? this.administrativeRegionRepository.findByNullParent() : this.administrativeRegionRepository.findByParentId(parentId);
        if (CollectionUtils.isEmpty(regions)) {
            return Lists.newArrayList();
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(regions, AdministrativeRegionEntity.class, AdministrativeRegionVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"..parent"});
        return collection.stream().sorted(Comparator.comparing(UuidVo::getId)).collect(Collectors.toList());
    }

    @NebulaServiceMethod(name="AdministrativeRegionService.findByCode", desc="\u6839\u636e\u7f16\u7801\u67e5\u8be2\u884c\u653f\u533a\u57df", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.READ)
    public AdministrativeRegionVo findByCode(@ServiceMethodParam(name="code") String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        AdministrativeRegionEntity region = this.administrativeRegionRepository.findByRegionCode(code);
        if (region == null) {
            return null;
        }
        return (AdministrativeRegionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)region, AdministrativeRegionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @NebulaServiceMethod(name="AdministrativeRegionService.updateOrgMappingLevel", desc="\u66f4\u65b0\u7ec4\u7ec7\u673a\u6784\u5173\u8054\u884c\u653f\u533a\u57df\u7684\u5c42\u7ea7", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.WRITE)
    public Integer updateOrgMappingLevel(@ServiceMethodParam(name="level") Integer level) {
        Validate.notNull((Object)level, (String)"\u5173\u8054\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RegionLevelEnum regionLevelEnum = RegionLevelEnum.valueOfLevel((Integer)level);
        Validate.notNull((Object)regionLevelEnum, (String)"\u4e0d\u652f\u6301\u7684\u533a\u57df\u5c42\u7ea7", (Object[])new Object[0]);
        RMap map = this.redissonClient.getMap("org:region:level");
        map.put((Object)"level", (Object)level);
        return level;
    }

    @NebulaServiceMethod(name="AdministrativeRegionService.findOrgMappingLevel", desc="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u5173\u8054\u884c\u653f\u533a\u57df\u7684\u5c42\u7ea7", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.READ)
    public Integer findOrgMappingLevel() {
        RMap map = this.redissonClient.getMap("org:region:level");
        return (Integer)map.get((Object)"level");
    }

    private List<AdministrativeRegionEntity> list2Tree(List<AdministrativeRegionEntity> list, boolean emptyCondition) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        HashMap<String, AdministrativeRegionEntity> rootMap = new HashMap<String, AdministrativeRegionEntity>(32);
        for (AdministrativeRegionEntity region : list) {
            AdministrativeRegionEntity parent = region.getParent();
            if (parent == null) {
                rootMap.put(region.getId(), region);
                continue;
            }
            if (emptyCondition) continue;
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
            rootMap.put(parent.getId(), parent);
        }
        return Lists.newArrayList(rootMap.values());
    }
}

