/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.common.enums.RbacRelationEnum;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.user.common.service.UserMappingService;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.service.region.AdministrativeRegionService;
import com.bizunited.platform.user.common.vo.AdministrativeRegionVo;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import com.bizunited.platform.user.common.vo.UserMappingVo;
import com.bizunited.platform.user.service.local.entity.OrganizationEntity;
import com.bizunited.platform.user.service.local.entity.PositionEntity;
import com.bizunited.platform.user.service.local.entity.UserEntity;
import com.bizunited.platform.user.service.local.repository.OrganizationRepository;
import com.bizunited.platform.user.service.local.repository.UserRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.util.CollectionUtils;

public class OrganizationServiceImpl
implements OrganizationService {
    private static final String ERROR_MESS_OGS = "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784";
    private static final String MESS_ORG_NAME = "orgName";
    private static final Logger LOGGER = LoggerFactory.getLogger(OrganizationServiceImpl.class);
    @Value(value="${user.dimensionalityCodeSize:3}")
    private Integer dimensionalityCodeSize;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private OrganizationRepository organizationRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserMappingService userMappingService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private AdministrativeRegionService administrativeRegionEntityService;

    @Transactional
    @NebulaServiceMethod(name="OrganizationService.create", desc="\u7ec4\u7ec7\u673a\u6784\u521b\u5efa\u670d\u52a1\u6e90", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.WRITE)
    public OrganizationVo create(OrganizationVo organization) {
        Validate.notNull((Object)organization, (String)"\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((organization.getId() == null ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u7ec4\u7ec7\u673a\u6784\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165\u7ec4\u7ec7\u673a\u6784id,\u8bf7\u91cd\u65b0\u6dfb\u52a0!!", (Object[])new Object[0]);
        String orgName = organization.getOrgName();
        Validate.notBlank((CharSequence)orgName, (String)"\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)organization.getDescription(), (String)"\u7ec4\u7ec7\u673a\u6784\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)organization.getType(), (String)"\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String code = organization.getCode();
        Validate.notNull((Object)code, (String)"\u7ec4\u7ec7\u673a\u6784\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrganizationEntity oldOrg = this.organizationRepository.findByCode(code);
        Validate.isTrue((null == oldOrg ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u7684code,\u8bf7\u91cd\u65b0\u8f93\u5165\u7ec4\u7ec7\u673a\u6784\u7f16\u7801!!", (Object[])new Object[0]);
        Validate.notNull((Object)organization.getLevel(), (String)"\u7ec4\u7ec7\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (organization.getTstatus() == null) {
            organization.setTstatus(NormalStatusEnum.ENABLE.getStatus());
        }
        OrganizationEntity currentOrg = (OrganizationEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)organization, OrganizationEntity.class, HashSet.class, ArrayList.class, new String[0]));
        OrganizationVo organizationParent = organization.getParent();
        if (organizationParent != null) {
            Validate.notBlank((CharSequence)organizationParent.getId(), (String)"\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u7684id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Optional parentEntityOp = this.organizationRepository.findById(organizationParent.getId());
            OrganizationEntity parentEntity = parentEntityOp.orElse(null);
            Validate.notNull((Object)((Object)parentEntity), (String)"\u521b\u5efa\u7ec4\u7ec7\u673a\u6784\u65f6\uff0c\u4f20\u5165\u4e86\u6307\u5b9a\u7684\u7236\u7ea7\u673a\u6784\u7f16\u53f7\u4fe1\u606f\uff0c\u4f46\u662f\u5e76\u672a\u5728\u672c\u5730\u6570\u636e\u4e2d\u627e\u5230\u8fd9\u6837\u7684\u7236\u7ea7\u673a\u6784\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
            Validate.isTrue((parentEntity.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u521b\u5efa\u7ec4\u7ec7\u673a\u6784\u65f6\uff0c\u4f20\u5165\u4e86\u6307\u5b9a\u7684\u7236\u7ea7\u673a\u6784\u7f16\u53f7\u4fe1\u606f\uff0c\u4f46\u662f\u7236\u7ea7\u673a\u6784\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
            parentEntity.setLeaf(false);
            this.organizationRepository.save((Object)parentEntity);
            currentOrg.setParent(parentEntity);
        }
        try {
            currentOrg.setDimensionalityCode(this.buildDimensionalityCode(organization));
            currentOrg.setLeaf(true);
            currentOrg.setCreateUser(SecurityUtils.getCurrentUser().getUserName());
            this.organizationRepository.save((Object)currentOrg);
            organization.setId(currentOrg.getId());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return organization;
    }

    private Integer buildLevel(OrganizationVo organization) {
        Integer level = null;
        if (organization != null && organization.getParent() != null) {
            OrganizationEntity parent = this.organizationRepository.findById(organization.getParent().getId()).orElse(null);
            Validate.notNull((Object)((Object)parent), (String)"\u672a\u627e\u5230\u8be5\u7ec4\u7ec7\u4e0a\u7ea7\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            if (parent.getLevel() != null) {
                level = parent.getLevel() + 1;
            }
        } else {
            level = 1;
        }
        return level;
    }

    private String buildDimensionalityCode(OrganizationVo organization) {
        String dimensionalityCode = "";
        String temp = "";
        int num = 0;
        if (organization != null && organization.getParent() != null) {
            OrganizationEntity parent = this.organizationRepository.findById(organization.getParent().getId()).orElse(null);
            Validate.notNull((Object)((Object)parent), (String)"\u672a\u627e\u5230\u8be5\u7ec4\u7ec7\u4e0a\u7ea7\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            String maxChildrenDimensionalityCode = this.organizationRepository.findMaxChildrenDimensionalityCodeByParentId(parent.getId(), organization.getId());
            if (StringUtils.isNotBlank((CharSequence)maxChildrenDimensionalityCode)) {
                String tempStr = maxChildrenDimensionalityCode.substring(maxChildrenDimensionalityCode.length() - this.dimensionalityCodeSize);
                num = Integer.parseInt(tempStr);
            }
            String numLength = num + 1 + "";
            temp = StringUtils.leftPad((String)temp, (int)this.dimensionalityCodeSize, (char)'0');
            dimensionalityCode = parent.getDimensionalityCode() + temp + numLength;
        } else {
            String numLength;
            String maxDimensionalityCode = this.organizationRepository.findMaxDimensionalityCodeByLevel(1);
            if (StringUtils.isNotBlank((CharSequence)maxDimensionalityCode)) {
                num = Integer.parseInt(maxDimensionalityCode);
            }
            if ((numLength = num + 1 + "").length() < this.dimensionalityCodeSize) {
                temp = StringUtils.leftPad((String)temp, (int)this.dimensionalityCodeSize, (char)'0');
                dimensionalityCode = temp + numLength;
            }
        }
        return dimensionalityCode;
    }

    @Transactional
    @NebulaServiceMethod(name="OrganizationService.update", desc="\u7ec4\u7ec7\u673a\u6784\u66f4\u65b0\u670d\u52a1\u6e90", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.WRITE)
    public OrganizationVo update(OrganizationVo organization) {
        Validate.notNull((Object)organization, (String)"\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)organization.getId(), (String)"\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u6dfb\u52a0!!", (Object[])new Object[0]);
        OrganizationEntity currentOrg = this.organizationRepository.findById(organization.getId()).orElse(null);
        Validate.notNull((Object)((Object)currentOrg), (String)"\u672a\u5728\u6570\u636e\u5c42\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u7ed3\u6784\u4fe1\u606f!!", (Object[])new Object[0]);
        String orgName = organization.getOrgName();
        Validate.notBlank((CharSequence)orgName, (String)"\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)organization.getDescription(), (String)"\u7ec4\u7ec7\u673a\u6784\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (organization.getType() != null) {
            currentOrg.setType(organization.getType());
        }
        OrganizationVo parent = organization.getParent();
        this.rebindParent(currentOrg, parent);
        currentOrg.setOrgName(orgName);
        currentOrg.setDescription(organization.getDescription());
        currentOrg.setExtend1(organization.getExtend1());
        currentOrg.setExtend2(organization.getExtend2());
        currentOrg.setExtend3(organization.getExtend3());
        currentOrg.setExtend4(organization.getExtend4());
        currentOrg.setExtend5(organization.getExtend5());
        currentOrg.setExtend6(organization.getExtend6());
        currentOrg.setExtend7(organization.getExtend7());
        currentOrg.setExtend8(organization.getExtend8());
        currentOrg.setExtend9(organization.getExtend9());
        currentOrg.setExtend10(organization.getExtend10());
        if (organization.getTstatus() != null) {
            currentOrg.setTstatus(organization.getTstatus());
        }
        this.organizationRepository.save((Object)currentOrg);
        return (OrganizationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentOrg, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void updateLeaf(OrganizationEntity oldParent, OrganizationEntity newParent) {
        if (oldParent != null && (newParent == null || !oldParent.getId().equals(newParent.getId())) && CollectionUtils.isEmpty(oldParent.getChild())) {
            oldParent.setLeaf(true);
            this.organizationRepository.save((Object)oldParent);
        }
        if (newParent != null) {
            newParent.setLeaf(false);
            this.organizationRepository.save((Object)newParent);
        }
    }

    @Transactional
    public OrganizationVo updateStatus(String orgId) {
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Optional op = this.organizationRepository.findById(orgId);
        OrganizationEntity organization = op.orElse(null);
        Validate.notNull((Object)((Object)organization), (String)"\u6ca1\u6709\u8be5\u7ec4\u7ec7\u673a\u6784\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Integer status = organization.getTstatus();
        status = status == NormalStatusEnum.ENABLE.getStatus() ? NormalStatusEnum.DISABLE.getStatus() : NormalStatusEnum.ENABLE.getStatus();
        organization.setTstatus(status);
        this.organizationRepository.save((Object)organization);
        this.updateChildrenStatus(organization, status);
        return (OrganizationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)organization, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public Set<OrganizationVo> enables(String[] orgIds) {
        HashSet<OrganizationEntity> organizations = new HashSet<OrganizationEntity>();
        Validate.notEmpty((Object[])orgIds, (String)"\u7ec4\u7ec7\u673a\u6784ids\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        for (String orgId : orgIds) {
            Optional op = this.organizationRepository.findById(orgId);
            OrganizationEntity organization = op.orElse(null);
            Validate.notNull((Object)((Object)organization), (String)"\u6ca1\u6709\u8be5\u7ec4\u7ec7\u673a\u6784\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Integer status = NormalStatusEnum.ENABLE.getStatus();
            organization.setTstatus(status);
            organizations.add(organization);
            this.organizationRepository.save((Object)organization);
        }
        return (Set)this.nebulaToolkitService.copyCollectionByWhiteList(organizations, OrganizationEntity.class, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public Set<OrganizationVo> disables(String[] orgIds) {
        HashSet<OrganizationEntity> organizations = new HashSet<OrganizationEntity>();
        Validate.notEmpty((Object[])orgIds, (String)"\u7ec4\u7ec7\u673a\u6784ids\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        for (String orgId : orgIds) {
            Optional op = this.organizationRepository.findById(orgId);
            OrganizationEntity organization = op.orElse(null);
            Validate.notNull((Object)((Object)organization), (String)"\u6ca1\u6709\u8be5\u7ec4\u7ec7\u673a\u6784\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Integer status = NormalStatusEnum.DISABLE.getStatus();
            organization.setTstatus(status);
            organizations.add(organization);
            this.organizationRepository.save((Object)organization);
        }
        return (Set)this.nebulaToolkitService.copyCollectionByWhiteList(organizations, OrganizationEntity.class, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void updateChildrenStatus(OrganizationEntity organization, Integer status) {
        Validate.notNull((Object)((Object)organization), (String)"\u672a\u5728\u6570\u636e\u5c42\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u7ed3\u6784\u4fe1\u606f!!", (Object[])new Object[0]);
        Set<OrganizationEntity> organizations = this.organizationRepository.findByParent(organization.getId());
        if (CollectionUtils.isEmpty(organizations)) {
            return;
        }
        for (OrganizationEntity child : organizations) {
            child.setTstatus(status);
            this.organizationRepository.save((Object)child);
            this.updateChildrenStatus(child, status);
        }
    }

    @Transactional
    public void bindParent(String currentOrgId, String parentOrgId) {
        Validate.isTrue((!StringUtils.equals((CharSequence)currentOrgId, (CharSequence)parentOrgId) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u4e0d\u80fd\u4e0e\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u91cd\u590d", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)currentOrgId, (String)"\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)parentOrgId, (String)"\u6307\u5b9a\u7684\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Optional op = this.organizationRepository.findById(currentOrgId);
        Validate.isTrue((boolean)op.isPresent(), (String)ERROR_MESS_OGS, (Object[])new Object[0]);
        Validate.isTrue((((OrganizationEntity)((Object)op.get())).getParent() == null ? 1 : 0) != 0, (String)"\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u5df2\u7ecf\u7ed1\u5b9a\u7236\u7ea7\uff0c\u8bf7\u5148\u89e3\u7ed1\u540e\u518d\u91cd\u65b0\u7ed1\u5b9a", (Object[])new Object[0]);
        Optional optional = this.organizationRepository.findById(parentOrgId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784!!", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.equals((CharSequence)currentOrgId, (CharSequence)parentOrgId) ? 1 : 0) != 0, (String)"\u7ed1\u5b9a\u7ec4\u7ec7\u673a\u6784\u65f6\uff0c\u4e0d\u80fd\u81ea\u5df1\u7ed1\u5b9a\u81ea\u5df1!!", (Object[])new Object[0]);
        OrganizationEntity cycleParent = null;
        String cycleParentId = parentOrgId;
        LinkedList allParentIds = Lists.newLinkedList();
        if (((OrganizationEntity)((Object)optional.get())).getParent() != null) {
            allParentIds.add(((OrganizationEntity)((Object)optional.get())).getParent().getId());
        }
        int index = 0;
        while (index < Integer.MAX_VALUE) {
            Validate.isTrue((!allParentIds.contains(currentOrgId) ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u7236\u7ea7\u8282\u70b9\u7ed1\u5b9a\u65f6\uff0c\u53d1\u73b0\u6307\u5b9a\u7684\u7236\u7ea7\u8282\u70b9\u51fa\u73b0\u4e86\u5faa\u73af\u7ed1\u5b9a\u7ed3\u6784\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((!StringUtils.equals((CharSequence)currentOrgId, (CharSequence)cycleParentId) ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u7236\u7ea7\u8282\u70b9\u7ed1\u5b9a\u65f6\uff0c\u53d1\u73b0\u6307\u5b9a\u7684\u7236\u7ea7\u8282\u548c\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u8282\u70b9\u51fa\u73b0\u4e86\u5faa\u73af\u7ed1\u5b9a\u7684\u7ed3\u6784\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            allParentIds.push(cycleParentId);
            cycleParent = this.organizationRepository.findByChildId(cycleParentId);
            if (cycleParent == null) break;
            cycleParentId = cycleParent.getId();
        }
        this.organizationRepository.bindParent(currentOrgId, parentOrgId);
        this.organizationRepository.flush();
        this.updateLeaf(((OrganizationEntity)op.orElse(null)).getParent(), optional.orElse(null));
        try {
            this.redisMutexService.lock("lock:organization:".concat(currentOrgId));
            OrganizationEntity entity = op.orElse(null);
            entity.setParent(optional.orElse(null));
            OrganizationVo organizationVo = (OrganizationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, OrganizationVo.class, HashSet.class, ArrayList.class, new String[]{"parent"});
            String dimensionalityCode = this.buildDimensionalityCode(organizationVo);
            entity.setDimensionalityCode(dimensionalityCode);
            Integer level = this.buildLevel(organizationVo);
            entity.setLevel(level);
            this.organizationRepository.save((Object)entity);
            this.buildChildrenDimensionalityCode(entity);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.redisMutexService.unlock("lock:organization:".concat(currentOrgId));
        }
    }

    private void buildChildrenDimensionalityCode(OrganizationEntity organization) {
        Set<OrganizationEntity> children = organization.getChild();
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        for (OrganizationEntity org : children) {
            OrganizationVo organizationVo = (OrganizationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)org, OrganizationVo.class, HashSet.class, ArrayList.class, new String[]{"parent"});
            String dimensionalityCode = this.buildDimensionalityCode(organizationVo);
            org.setDimensionalityCode(dimensionalityCode);
            this.organizationRepository.save((Object)org);
            this.buildChildrenDimensionalityCode(org);
        }
    }

    @Transactional
    public void unbindParent(String currentOrgId) {
        Validate.notBlank((CharSequence)currentOrgId, (String)"\u8fdb\u884c\u7ed1\u5b9a\u7ed3\u6784\u6d88\u9664\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.organizationRepository.findById(currentOrgId);
        Validate.isTrue((boolean)op.isPresent(), (String)ERROR_MESS_OGS, (Object[])new Object[0]);
        this.organizationRepository.unbindParent(currentOrgId);
        ((OrganizationEntity)((Object)op.get())).setParent(null);
        this.organizationRepository.flush();
        this.updateLeaf(((OrganizationEntity)op.orElse(null)).getParent(), null);
        try {
            this.redisMutexService.lock("lock:organization:".concat(currentOrgId));
            OrganizationEntity entity = op.orElse(null);
            entity.setParent(null);
            OrganizationVo organizationVo = (OrganizationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, OrganizationVo.class, HashSet.class, ArrayList.class, new String[]{"parent"});
            String dimensionalityCode = this.buildDimensionalityCode(organizationVo);
            entity.setDimensionalityCode(dimensionalityCode);
            Integer level = this.buildLevel(organizationVo);
            entity.setLevel(level);
            this.organizationRepository.save((Object)entity);
            this.buildChildrenDimensionalityCode(entity);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.redisMutexService.unlock("lock:organization:".concat(currentOrgId));
        }
    }

    @Transactional
    public void mergeOrgById(String id, String currentOrgId) {
        Set<PositionEntity> positionEntities;
        Validate.notBlank((CharSequence)currentOrgId, (String)"\u4f20\u5165\u66ff\u6362\u7ec4\u7ec7\u673a\u6784\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)id, (String)"\u4f20\u5165\u88ab\u66ff\u6362\u7ec4\u7ec7\u673a\u6784\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.equals((CharSequence)currentOrgId, (CharSequence)id) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u5408\u5e76\u81ea\u5df1\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        OrganizationEntity currentEntity = this.organizationRepository.findDetailsById(currentOrgId);
        OrganizationEntity entity = this.organizationRepository.findDetailsById(id);
        Validate.notNull((Object)((Object)currentEntity), (String)"\u5408\u5e76\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)entity), (String)"\u88ab\u5408\u5e76\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Set<OrganizationEntity> organizationChild = entity.getChild();
        this.handleCircular(organizationChild, currentOrgId);
        if (!CollectionUtils.isEmpty(organizationChild)) {
            for (OrganizationEntity organizationEntity : organizationChild) {
                this.rebindParent(organizationEntity.getId(), currentOrgId);
            }
        }
        if (!CollectionUtils.isEmpty(positionEntities = entity.getPositions())) {
            for (PositionEntity positionEntity : positionEntities) {
                this.positionService.reBindOrg(currentOrgId, positionEntity.getId());
            }
        }
        Set<UserEntity> set = entity.getUsers();
        ArrayList<String> list = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(set)) {
            for (UserEntity userEntity : set) {
                list.add(userEntity.getId());
            }
            String[] userIds = (String[])list.toArray();
            this.rebindUsers(currentOrgId, userIds);
        }
        entity.setTstatus(0);
        entity.setLeaf(true);
        this.organizationRepository.save((Object)entity);
    }

    @Transactional
    public void rebindParent(String currentOrgId, String parentOrgId) {
        this.unbindParent(currentOrgId);
        if (StringUtils.isNotBlank((CharSequence)parentOrgId)) {
            this.bindParent(currentOrgId, parentOrgId);
        }
    }

    private void rebindParent(OrganizationEntity org, OrganizationVo newParent) {
        OrganizationEntity oldParent = org.getParent();
        if (newParent != null) {
            Validate.notBlank((CharSequence)newParent.getId(), (String)"\u7ec4\u7ec7\u673a\u6784\u7684\u7236\u7ea7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (oldParent == null && newParent == null) {
            return;
        }
        if (oldParent != null && newParent != null && newParent.getId().equals(oldParent.getId())) {
            return;
        }
        String newParentId = newParent == null ? null : newParent.getId();
        this.rebindParent(org.getId(), newParentId);
    }

    private void validateBindUser(UserMappingVo mappingVo, String currentOrgId, String userId) {
        Optional optional = this.userRepository.findById(userId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u6ca1\u6709\u8be5\u7528\u6237[%s],\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
        if (mappingVo == null) {
            long count = this.organizationRepository.countByOrgIdAndUserId(currentOrgId, userId);
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
        } else {
            long count;
            int bindRelation = mappingVo.getUserOrgRelation();
            if (bindRelation == RbacRelationEnum.MANY_TO_MANY.getRelation()) {
                count = this.organizationRepository.countByOrgIdAndUserId(currentOrgId, userId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u7ec4\u7ec7\u591a\u5bf9\u591a\uff0c\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
            }
            if (bindRelation == RbacRelationEnum.MANY_TO_ONE.getRelation()) {
                count = this.organizationRepository.countOrganizationByUserId(userId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u7ec4\u7ec7\u591a\u5bf9\u4e00\uff0c\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
            }
            if (bindRelation == RbacRelationEnum.ONE_TO_MANY.getRelation()) {
                count = this.organizationRepository.countUserByOrgId(currentOrgId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u7ec4\u7ec7\u4e00\u5bf9\u591a\uff0c\u6307\u5b9a\u7ec4\u7ec7[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u7528\u6237\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{currentOrgId});
            }
            if (bindRelation == RbacRelationEnum.ONE_TO_ONE.getRelation()) {
                long countOrganization = this.organizationRepository.countOrganizationByUserId(userId);
                Validate.isTrue((countOrganization == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u7ec4\u7ec7\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
                long countUser = this.organizationRepository.countUserByOrgId(currentOrgId);
                Validate.isTrue((countUser == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u7ec4\u7ec7\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u7ec4\u7ec7[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u7528\u6237\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{currentOrgId});
            }
        }
    }

    @Transactional
    public void bindUsers(String currentOrgId, String[] userIds) {
        Validate.notBlank((CharSequence)currentOrgId, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.organizationRepository.findById(currentOrgId);
        Validate.isTrue((boolean)op.isPresent(), (String)ERROR_MESS_OGS, (Object[])new Object[0]);
        Validate.isTrue((userIds != null && userIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u7ed1\u5b9a\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u4eba\u5458\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        UserMappingVo mapping = this.userMappingService.findOne();
        for (String userId : userIds) {
            this.validateBindUser(mapping, currentOrgId, userId);
            this.organizationRepository.bindUsers(currentOrgId, userId);
        }
    }

    @Transactional
    public void unbindUsers(String currentOrgId, String[] userIds) {
        Validate.notBlank((CharSequence)currentOrgId, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.organizationRepository.findById(currentOrgId);
        Validate.isTrue((boolean)op.isPresent(), (String)ERROR_MESS_OGS, (Object[])new Object[0]);
        Validate.notNull((Object)userIds, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u4eba\u5458\u4fe1\u606f!!", (Object[])new Object[0]);
        for (String userId : userIds) {
            Optional optional = this.userRepository.findById(userId);
            Validate.isTrue((boolean)optional.isPresent(), (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u89e3\u7ed1\u7ed1\u5b9a\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u4eba\u5458\u4fe1\u606f\u3010id=%s\u3011", (Object[])new Object[]{userId});
            this.organizationRepository.unbindUser(currentOrgId, userId);
        }
    }

    @Transactional
    public void rebindUsers(String currentOrgId, String[] userIds) {
        Validate.notBlank((CharSequence)currentOrgId, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f!!", (Object[])new Object[0]);
        if (userIds == null) {
            userIds = new String[]{};
        }
        OrganizationEntity org = this.organizationRepository.findById(currentOrgId).orElse(null);
        Validate.notNull((Object)((Object)org), (String)ERROR_MESS_OGS, (Object[])new Object[0]);
        Set newUserIds = Arrays.stream(userIds).collect(Collectors.toSet());
        HashSet users = org.getUsers();
        if (users == null) {
            users = Sets.newHashSet();
        }
        Set oldUserIds = users.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        Sets.SetView insertUsers = Sets.difference(newUserIds, oldUserIds);
        Sets.SetView deleteUsers = Sets.difference(oldUserIds, newUserIds);
        UserMappingVo mapping = this.userMappingService.findOne();
        for (String userId : deleteUsers) {
            this.organizationRepository.unbindUser(currentOrgId, userId);
        }
        for (String userId : insertUsers) {
            this.validateBindUser(mapping, currentOrgId, userId);
            this.organizationRepository.bindUsers(currentOrgId, userId);
        }
    }

    public List<OrganizationVo> findByNullParent() {
        Set<OrganizationEntity> organizationEntitys = this.organizationRepository.findByNullParent();
        if (organizationEntitys == null || organizationEntitys.isEmpty()) {
            return Lists.newArrayList();
        }
        Collection orgVos = this.nebulaToolkitService.copyCollectionByWhiteList(organizationEntitys, OrganizationEntity.class, OrganizationVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)orgVos);
    }

    public List<OrganizationVo> findByParent(String parentId) {
        if (StringUtils.isBlank((CharSequence)parentId)) {
            return Lists.newArrayList();
        }
        Set<OrganizationEntity> organizationEntitys = this.organizationRepository.findByParent(parentId);
        if (organizationEntitys == null || organizationEntitys.isEmpty()) {
            return Lists.newArrayList();
        }
        Collection orgVos = this.nebulaToolkitService.copyCollectionByWhiteList(organizationEntitys, OrganizationEntity.class, OrganizationVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)orgVos);
    }

    public List<OrganizationVo> findByParentAndFilterConditions(InvokeParams invokeParams) {
        Map parameters = (invokeParams = (InvokeParams)ObjectUtils.defaultIfNull((Object)invokeParams, (Object)new InvokeParams())).getInvokeParams();
        if (parameters.get("parentId") == null) {
            return Lists.newArrayList();
        }
        List organizationEntitys = this.organizationRepository.findAllByConditions(parameters);
        if (organizationEntitys == null || organizationEntitys.isEmpty()) {
            return Lists.newArrayList();
        }
        Collection orgVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)organizationEntitys, OrganizationEntity.class, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)orgVos);
    }

    @NebulaServiceMethod(name="OrganizationService.findTreeByConditions", desc="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u6811", returnPropertiesFilter="parent", scope=NebulaServiceMethod.ScopeType.READ)
    public List<OrganizationVo> findTreeByConditions(InvokeParams invokeParams) {
        Map parameters = (invokeParams = (InvokeParams)ObjectUtils.defaultIfNull((Object)invokeParams, (Object)new InvokeParams())).getInvokeParams();
        List orgs = this.organizationRepository.findAllByConditions(parameters);
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return Lists.newArrayList();
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)orgs, OrganizationEntity.class, OrganizationVo.class, HashSet.class, ArrayList.class, new String[]{"parent"});
        ArrayList orgVos = Lists.newArrayList();
        HashSet<String> orgIds = new HashSet<String>();
        collection.forEach(o -> orgIds.add(o.getId()));
        orgVos.addAll(collection);
        Iterator iterator = orgs.iterator();
        while (iterator.hasNext()) {
            OrganizationEntity org;
            OrganizationEntity parent = org = (OrganizationEntity)((Object)iterator.next());
            while ((parent = parent.getParent()) != null) {
                if (!orgIds.add(parent.getId())) continue;
                OrganizationVo parentVo = (OrganizationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)parent, OrganizationVo.class, HashSet.class, ArrayList.class, new String[]{"parent"});
                orgVos.add(parentVo);
            }
        }
        return orgVos.stream().sorted(Comparator.comparing(OrganizationVo::getSortIndex)).collect(Collectors.toList());
    }

    @NebulaServiceMethod(name="OrganizationService.findByNullParentAndStatus", desc="\u6839\u636e\u72b6\u6001\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u7684\u6700\u9876\u7ea7\u6570\u636e", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.READ)
    public List<OrganizationVo> findByNullParentAndStatus(@ServiceMethodParam(name="status") Integer status) {
        if (status == null) {
            return Collections.emptyList();
        }
        List<OrganizationEntity> organizationEntitys = this.organizationRepository.findByNullParentAndStatus(status);
        if (CollectionUtils.isEmpty(organizationEntitys)) {
            return Collections.emptyList();
        }
        Collection orgVos = this.nebulaToolkitService.copyCollectionByWhiteList(organizationEntitys, OrganizationEntity.class, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)orgVos);
    }

    @NebulaServiceMethod(name="OrganizationService.findByParentAndStatus", desc="\u6839\u636e\u7236\u7ea7ID\u548c\u72b6\u6001\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u7684\u6700\u9876\u7ea7\u6570\u636e", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.READ)
    public List<OrganizationVo> findByParentAndStatus(@ServiceMethodParam(name="parentId") String parentId, @ServiceMethodParam(name="status") Integer status) {
        if (StringUtils.isBlank((CharSequence)parentId) || status == null) {
            return Lists.newArrayList();
        }
        Set<OrganizationEntity> organizationEntitys = this.organizationRepository.findByParentAndStatus(parentId, status);
        if (organizationEntitys == null || organizationEntitys.isEmpty()) {
            return Lists.newArrayList();
        }
        Collection orgVos = this.nebulaToolkitService.copyCollectionByWhiteList(organizationEntitys, OrganizationEntity.class, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)orgVos);
    }

    public JSONArray findByOrgName(String orgName) {
        if (StringUtils.isBlank((CharSequence)orgName)) {
            return null;
        }
        Set<OrganizationEntity> currentOrgs = this.organizationRepository.findByOrgName(orgName);
        if (currentOrgs == null || currentOrgs.isEmpty()) {
            return null;
        }
        JSONArray jsonObjects = new JSONArray();
        for (OrganizationEntity orgItem : currentOrgs) {
            JSONObject jsonObject = this.recursiveFindParent(orgItem);
            if (jsonObject == null) continue;
            jsonObjects.add((Object)jsonObject);
        }
        return jsonObjects;
    }

    public Set<OrganizationVo> findByOrgNameLike(String orgName) {
        Set<OrganizationEntity> entitySet = this.organizationRepository.findByOrgNameLike(orgName);
        if (CollectionUtils.isEmpty(entitySet)) {
            return Sets.newHashSet();
        }
        Collection organizationVos = this.nebulaToolkitService.copyCollectionByWhiteList(entitySet, OrganizationEntity.class, OrganizationVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet((Iterable)organizationVos);
    }

    private JSONObject recursiveFindParent(OrganizationEntity currentOrg) {
        if (currentOrg == null || currentOrg.getTstatus() != 1) {
            return null;
        }
        JSONObject orgObject = new JSONObject();
        orgObject.put("id", (Object)currentOrg.getId());
        orgObject.put(MESS_ORG_NAME, (Object)currentOrg.getOrgName());
        orgObject.put("code", (Object)currentOrg.getCode());
        orgObject.put("createTime", (Object)currentOrg.getCreateTime());
        orgObject.put("sortIndex", (Object)currentOrg.getSortIndex());
        orgObject.put("status", (Object)currentOrg.getTstatus());
        orgObject.put("type", (Object)currentOrg.getType());
        OrganizationEntity parent = currentOrg.getParent();
        if (parent != null) {
            orgObject.put("parent", (Object)this.recursiveFindParent(parent));
        }
        return orgObject;
    }

    public OrganizationVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        OrganizationEntity org = this.organizationRepository.findByCode(code);
        if (org == null) {
            return null;
        }
        return (OrganizationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)org, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @NebulaServiceMethod(name="OrganizationService.findDetailsById", desc="\u6839\u636e\u7ec4\u7ec7\u673a\u6784ID\u67e5\u8be2\u660e\u7ec6\u670d\u52a1\u6e90", returnPropertiesFilter="parent,child,roles,users,positions", scope=NebulaServiceMethod.ScopeType.READ)
    public OrganizationVo findDetailsById(@ServiceMethodParam(name="id") String id) {
        Validate.notBlank((CharSequence)id, (String)"\u7ec4\u7ec7\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        OrganizationEntity currentOrg = this.organizationRepository.findDetailsById(id);
        if (currentOrg == null) {
            return null;
        }
        return (OrganizationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentOrg, OrganizationVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"parent", "child", "roles", "users", "positions"});
    }

    public Set<OrganizationVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Sets.newHashSet();
        }
        Set<OrganizationEntity> orgs = this.organizationRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(orgs)) {
            return Sets.newHashSet();
        }
        Collection ovos = this.nebulaToolkitService.copyCollectionByWhiteList(orgs, OrganizationEntity.class, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet((Iterable)ovos);
    }

    public OrganizationVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        OrganizationEntity organizationEntity = this.organizationRepository.findById(id).orElse(null);
        if (organizationEntity == null) {
            return null;
        }
        return this.findOrgTree(organizationEntity);
    }

    public JSONArray findByUserId(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return null;
        }
        Set<OrganizationEntity> currentOrgs = this.organizationRepository.findByUserId(userId);
        if (currentOrgs == null || currentOrgs.isEmpty()) {
            return null;
        }
        JSONArray jsonObjects = new JSONArray();
        for (OrganizationEntity orgItem : currentOrgs) {
            JSONObject jsonObject = this.recursiveFindParent(orgItem);
            if (jsonObject == null) continue;
            jsonObjects.add((Object)jsonObject);
        }
        return jsonObjects;
    }

    public Object[] findUnbindOrgById(String currentOrgId) {
        String parentOrgId;
        Optional optional;
        if (StringUtils.isBlank((CharSequence)currentOrgId)) {
            return new Object[0];
        }
        List<OrganizationEntity> allOrganizations = this.organizationRepository.findAllByStatus();
        JSONArray jsonArray = new JSONArray();
        if (null != allOrganizations && !allOrganizations.isEmpty()) {
            for (OrganizationEntity org : allOrganizations) {
                JSONObject orgAllObject = new JSONObject();
                orgAllObject.put("id", (Object)org.getId());
                orgAllObject.put(MESS_ORG_NAME, (Object)org.getOrgName());
                jsonArray.add((Object)orgAllObject);
            }
        }
        LOGGER.debug("\u6240\u6709\u7ec4\u7ec7\u673a\u6784\u8282\u70b9: {}", (Object)JSON.toJSONString((Object)jsonArray));
        Optional op = this.organizationRepository.findById(currentOrgId);
        OrganizationEntity childOrg = op.orElse(null);
        if (childOrg == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u4efb\u4f55\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!");
        }
        JSONArray array = this.findChildOrgs(childOrg, new JSONArray());
        if (null != childOrg.getParent() && StringUtils.isNotBlank((CharSequence)childOrg.getParent().getId()) && (optional = this.organizationRepository.findById(parentOrgId = childOrg.getParent().getId())).isPresent()) {
            JSONObject jsonObject = new JSONObject();
            OrganizationEntity parentOrg = (OrganizationEntity)((Object)optional.get());
            jsonObject.put("id", (Object)parentOrg.getId());
            jsonObject.put(MESS_ORG_NAME, (Object)parentOrg.getOrgName());
            array.add((Object)jsonObject);
        }
        LOGGER.debug("\u4e0d\u5141\u8bb8\u7ed1\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\u8282\u70b9(\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u4ee5\u53ca\u6240\u6709\u5b50\u7ea7\u7ec4\u7ec7\u673a\u6784): {}", (Object)JSON.toJSONString((Object)array));
        if (!array.isEmpty()) {
            jsonArray.removeAll((Collection)array);
        }
        LOGGER.debug("\u5141\u8bb8\u7ed1\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\u8282\u70b9: {}", (Object)JSON.toJSONString((Object)jsonArray));
        return jsonArray.toArray();
    }

    private JSONArray findChildOrgs(OrganizationEntity currentOrg, JSONArray jsonArray) {
        if (currentOrg != null) {
            Optional op = this.organizationRepository.findById(currentOrg.getId());
            OrganizationEntity organization = op.orElse(null);
            Validate.notNull((Object)((Object)organization), (String)"\u6ca1\u6709\u53ef\u7528\u7684\u7ec4\u7ec7\u673a\u6784,\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            JSONObject orgObject = new JSONObject();
            orgObject.put("id", (Object)organization.getId());
            orgObject.put(MESS_ORG_NAME, (Object)organization.getOrgName());
            jsonArray.add((Object)orgObject);
            Set<OrganizationEntity> childs = this.organizationRepository.findByParent(organization.getId());
            if (childs != null && !childs.isEmpty()) {
                for (OrganizationEntity child : childs) {
                    this.findChildOrgs(child, jsonArray);
                }
            }
        }
        return jsonArray;
    }

    public Set<OrganizationVo> findOrgByUserId(String userId) {
        Validate.notBlank((CharSequence)userId, (String)"\u4f20\u5165\u7684\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        UserEntity user = this.userRepository.findDetailsById(userId);
        if (user == null) {
            return Sets.newHashSet();
        }
        Set<OrganizationEntity> orgs = user.getOrgs();
        if (CollectionUtils.isEmpty(orgs)) {
            return Sets.newHashSet();
        }
        Collection vos = this.nebulaToolkitService.copyCollectionByWhiteList(orgs, OrganizationEntity.class, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet((Iterable)vos);
    }

    private OrganizationVo findOrgTree(OrganizationEntity currentOrg) {
        OrganizationVo organizationVo = (OrganizationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentOrg, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
        organizationVo.setChild(this.findChildren(organizationVo));
        return organizationVo;
    }

    private Set<OrganizationVo> findChildren(OrganizationVo currentOrg) {
        if (Objects.isNull(currentOrg)) {
            return Sets.newHashSet();
        }
        HashSet<OrganizationVo> organizationVoSet = new HashSet<OrganizationVo>();
        Set<OrganizationEntity> childs = this.organizationRepository.findByParent(currentOrg.getId());
        if (CollectionUtils.isEmpty(childs)) {
            return Sets.newHashSet();
        }
        for (OrganizationEntity child : childs) {
            OrganizationVo organizationVo = (OrganizationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)child, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
            organizationVoSet.add(organizationVo);
            organizationVo.setChild(this.findChildren(organizationVo));
        }
        return organizationVoSet;
    }

    public OrganizationVo findByChild(String childId) {
        Validate.notBlank((CharSequence)childId, (String)"\u5b50\u7ea7\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrganizationEntity org = this.organizationRepository.findByChildId(childId);
        if (org == null) {
            return null;
        }
        return (OrganizationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)org, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<OrganizationVo> findAll() {
        List orgs = this.organizationRepository.findAll(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        if (orgs == null) {
            return Collections.emptyList();
        }
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)orgs, OrganizationEntity.class, OrganizationVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"parent"});
        return new ArrayList<OrganizationVo>(result);
    }

    public OrganizationVo findMainOrgByUserId(String userId) {
        Set<OrganizationVo> orgs;
        OrganizationVo org;
        OrganizationEntity organization;
        Validate.notBlank((CharSequence)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RMap userMap = this.redissonClient.getMap("rbac:user:" + userId);
        Object obj = userMap.get((Object)"mainOrg");
        OrganizationVo mainOrg = null;
        if (obj != null && (organization = this.organizationRepository.findByIdAndUserId((org = (OrganizationVo)JSON.parseObject((String)((String)obj), OrganizationVo.class)).getId(), userId)) != null) {
            mainOrg = org;
        }
        if (mainOrg == null && !CollectionUtils.isEmpty(orgs = this.findOrgByUserId(userId))) {
            mainOrg = orgs.iterator().next();
            userMap.put((Object)"mainOrg", (Object)JSON.toJSONString((Object)mainOrg));
        }
        return mainOrg;
    }

    @Transactional
    public void updateUserMainOrg(String userId, String orgId) {
        Validate.notBlank((CharSequence)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserEntity user = this.userRepository.findById(userId).orElse(null);
        Validate.notNull((Object)((Object)user), (String)"\u7528\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        OrganizationEntity org = this.organizationRepository.findByIdAndUserId(orgId, userId);
        Validate.notNull((Object)((Object)org), (String)"\u672a\u627e\u5230\u7528\u6237\u5173\u8054\u7684\u7ec4\u7ec7\u673a\u6784", (Object[])new Object[0]);
        RMap userMap = this.redissonClient.getMap("rbac:user:" + userId);
        OrganizationVo orgVo = (OrganizationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)org, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
        userMap.put((Object)"mainOrg", (Object)JSON.toJSONString((Object)orgVo));
    }

    public Set<OrganizationVo> findByPrincipal(Integer type, Principal principal) {
        Validate.notNull((Object)type, (String)"\u4f20\u5165\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String account = principal.getName();
        UserEntity user = this.userRepository.findByAccount(account);
        Validate.notNull((Object)((Object)user), (String)"\u672a\u83b7\u53d6\u767b\u9646\u4eba\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Set<OrganizationVo> orgs = null;
        switch (type) {
            case 1: {
                orgs = this.findParent(user);
                break;
            }
            case 2: {
                orgs = this.findChildren(user);
                break;
            }
            case 3: {
                orgs = this.findParentAndChildren(user);
                break;
            }
            case 4: {
                orgs = this.findOrg(user);
                break;
            }
        }
        if (CollectionUtils.isEmpty(orgs)) {
            return Sets.newHashSet();
        }
        return orgs;
    }

    private Set<OrganizationVo> findOrg(UserEntity user) {
        Set<OrganizationEntity> orgs = this.organizationRepository.findByUserId(user.getId());
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList(orgs, OrganizationEntity.class, OrganizationVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet((Iterable)result);
    }

    private Set<OrganizationVo> findParentAndChildren(UserEntity user) {
        HashSet<OrganizationVo> result = new HashSet<OrganizationVo>();
        HashSet<OrganizationVo> removes = new HashSet<OrganizationVo>();
        HashMap<String, OrganizationVo> childMap = new HashMap<String, OrganizationVo>();
        HashMap<String, OrganizationVo> parentMap = new HashMap<String, OrganizationVo>();
        Set<OrganizationVo> rootOrgs = this.findOrg(user);
        for (OrganizationVo rootOrg : rootOrgs) {
            rootOrg.setChild(this.findAllChildren(rootOrg, childMap));
            rootOrg.setParent(this.findAllParent(rootOrg, parentMap));
            result.add(rootOrg);
        }
        for (OrganizationVo item : result) {
            if (!childMap.containsKey(item.getId())) continue;
            removes.add(item);
        }
        for (OrganizationVo remove : removes) {
            result.remove(remove);
        }
        return result;
    }

    private Set<OrganizationVo> findChildren(UserEntity user) {
        HashSet<OrganizationVo> result = new HashSet<OrganizationVo>();
        HashSet<OrganizationVo> removes = new HashSet<OrganizationVo>();
        HashMap<String, OrganizationVo> childMap = new HashMap<String, OrganizationVo>();
        Set<OrganizationVo> rootOrgs = this.findOrg(user);
        for (OrganizationVo rootOrg : rootOrgs) {
            rootOrg.setChild(this.findAllChildren(rootOrg, childMap));
            result.add(rootOrg);
        }
        for (OrganizationVo item : result) {
            if (!childMap.containsKey(item.getId())) continue;
            removes.add(item);
        }
        for (OrganizationVo remove : removes) {
            result.remove(remove);
        }
        return result;
    }

    private Set<OrganizationVo> findAllChildren(OrganizationVo org, Map<String, OrganizationVo> childMap) {
        HashSet<OrganizationVo> result = new HashSet<OrganizationVo>();
        OrganizationEntity currentOrg = this.organizationRepository.findById(org.getId()).orElse(null);
        Set<OrganizationEntity> children = currentOrg.getChild();
        if (CollectionUtils.isEmpty(children)) {
            return Sets.newHashSet();
        }
        for (OrganizationEntity child : children) {
            OrganizationVo organizationVo = (OrganizationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)child, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
            childMap.put(organizationVo.getId(), organizationVo);
            organizationVo.setChild(this.findAllChildren(organizationVo, childMap));
            result.add(organizationVo);
        }
        return result;
    }

    private Set<OrganizationVo> findParent(UserEntity user) {
        HashSet<OrganizationVo> result = new HashSet<OrganizationVo>();
        HashSet<OrganizationVo> removes = new HashSet<OrganizationVo>();
        HashMap<String, OrganizationVo> parentMap = new HashMap<String, OrganizationVo>();
        Set<OrganizationVo> rootOrgs = this.findOrg(user);
        for (OrganizationVo rootOrg : rootOrgs) {
            rootOrg.setParent(this.findAllParent(rootOrg, parentMap));
            result.add(rootOrg);
        }
        for (OrganizationVo item : result) {
            if (!parentMap.containsKey(item.getId())) continue;
            removes.add(item);
        }
        for (OrganizationVo remove : removes) {
            result.remove(remove);
        }
        return result;
    }

    private OrganizationVo findAllParent(OrganizationVo rootOrg, Map<String, OrganizationVo> parentMap) {
        OrganizationEntity currentOrg = this.organizationRepository.findById(rootOrg.getId()).orElse(null);
        OrganizationEntity parent = currentOrg.getParent();
        if (parent == null) {
            return null;
        }
        OrganizationVo organizationVo = (OrganizationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)parent, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
        parentMap.put(organizationVo.getId(), organizationVo);
        organizationVo.setParent(this.findAllParent(organizationVo, parentMap));
        return organizationVo;
    }

    public Set<OrganizationVo> findByTypeAndLevel(Integer type, String account, Integer level) {
        Validate.notNull((Object)type, (String)"\u4f20\u5165\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notNull((Object)account, (String)"\u4f20\u5165\u8d26\u53f7\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notNull((Object)level, (String)"\u4f20\u5165\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        UserEntity user = this.userRepository.findByAccount(account);
        Validate.notNull((Object)((Object)user), (String)"\u672a\u83b7\u53d6\u767b\u9646\u4eba\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Set<OrganizationVo> orgs = null;
        String[] propertiesFilter = new String[level.intValue()];
        HashSet<OrganizationVo> newOrgs = new HashSet<OrganizationVo>();
        switch (type) {
            case 1: {
                orgs = this.findParent(user);
                this.bindPropertiesFilter(level, propertiesFilter, "parent");
                break;
            }
            case 2: {
                orgs = this.findChildren(user);
                this.bindPropertiesFilter(level, propertiesFilter, "child");
                break;
            }
        }
        if (CollectionUtils.isEmpty(orgs)) {
            return Sets.newHashSet();
        }
        for (OrganizationVo org : orgs) {
            OrganizationVo organizationVo = (OrganizationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)org, OrganizationVo.class, HashSet.class, ArrayList.class, propertiesFilter);
            newOrgs.add(organizationVo);
        }
        return newOrgs;
    }

    private void bindPropertiesFilter(Integer level, String[] propertiesFilter, String type) {
        String temp = "";
        for (int i = 0; i < level; ++i) {
            temp = temp + type + ".";
            if (i + 1 == level) {
                temp = temp.substring(0, temp.length() - 1);
            }
            propertiesFilter[i] = temp;
        }
    }

    @Transactional
    @NebulaServiceMethod(name="OrganizationService.bindRegions", desc="\u7ed1\u5b9a\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u7684\u884c\u653f\u533a\u57df", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.WRITE)
    public void bindRegions(@ServiceMethodParam(name="orgId") String orgId, @ServiceMethodParam(name="regionIds") String[] regionIds) {
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Object[])regionIds, (String)"\u884c\u653f\u533a\u57dfID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrganizationEntity org = this.organizationRepository.findById(orgId).orElse(null);
        Validate.notNull((Object)((Object)org), (String)"\u7ec4\u7ec7\u673a\u6784\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01", (Object[])new Object[0]);
        Set regions = (Set)ObjectUtils.defaultIfNull(org.getRegions(), (Object)Sets.newHashSet());
        Set regionsSet = regions.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        Integer orgMappingLevel = this.administrativeRegionEntityService.findOrgMappingLevel();
        Validate.notNull((Object)orgMappingLevel, (String)"\u7ec4\u7ec7\u673a\u6784\u5173\u8054\u533a\u57df\u5c42\u7ea7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e!!", (Object[])new Object[0]);
        for (String regionId : regionIds) {
            if (regionsSet.contains(regionId)) continue;
            AdministrativeRegionVo region = this.administrativeRegionEntityService.findById(regionId);
            Validate.notNull((Object)region, (String)"\u533a\u57df\u4e0d\u5b58\u5728\uff1a%s", (Object[])new Object[]{regionId});
            if (!orgMappingLevel.equals(region.getRegionLevel())) continue;
            this.organizationRepository.bindRegion(orgId, regionId);
            regionsSet.add(regionId);
        }
    }

    @Transactional
    @NebulaServiceMethod(name="OrganizationService.rebindRegions", desc="\u91cd\u65b0\u7ed1\u5b9a\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u7684\u884c\u653f\u533a\u57df", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.WRITE)
    public void rebindRegions(@ServiceMethodParam(name="orgId") String orgId, @ServiceMethodParam(name="regionIds") String[] regionIds) {
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.organizationRepository.unbindRegionsByOrgId(orgId);
        if (ArrayUtils.isEmpty((Object[])regionIds)) {
            return;
        }
        this.bindRegions(orgId, regionIds);
    }

    @Transactional
    @NebulaServiceMethod(name="OrganizationService.unbindRegions", desc="\u89e3\u7ed1\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u7684\u884c\u653f\u533a\u57df", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.WRITE)
    public void unbindRegions(@ServiceMethodParam(name="orgId") String orgId, @ServiceMethodParam(name="regionIds") String[] regionIds) {
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Object[])regionIds, (String)"\u884c\u653f\u533a\u57dfID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrganizationEntity org = this.organizationRepository.findById(orgId).orElse(null);
        Validate.notNull((Object)((Object)org), (String)"\u7ec4\u7ec7\u673a\u6784\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01", (Object[])new Object[0]);
        Set regions = (Set)ObjectUtils.defaultIfNull(org.getRegions(), (Object)Sets.newHashSet());
        Set regionsSet = regions.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        HashSet regionIdsSet = Sets.newHashSet((Object[])regionIds);
        for (String regionId : regionIdsSet) {
            if (!regionsSet.contains(regionId)) continue;
            this.organizationRepository.unbindRegion(orgId, regionId);
        }
    }

    public List<OrganizationVo> findChildrenByIdsOrCodes(String[] ids, String[] codes) {
        OrganizationVo org;
        ArrayList<OrganizationVo> orgs = new ArrayList<OrganizationVo>();
        if (ids != null && ids.length > 0) {
            for (String id : ids) {
                org = this.findById(id);
                if (org == null) continue;
                orgs.add(org);
            }
        }
        if (codes != null && codes.length > 0) {
            for (String code : codes) {
                org = this.findChildrenByCode(code);
                if (org == null) continue;
                orgs.add(org);
            }
        }
        if (CollectionUtils.isEmpty(orgs)) {
            return Lists.newArrayList();
        }
        return orgs;
    }

    @NebulaServiceMethod(name="OrganizationService.findByIdStruSelfAndDescendant", desc="\u6839\u636eID\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u53ca\u5f53\u524d\u7ec4\u7ec7\u7684\u6240\u6709\u4e0b\u7ea7,\u4ee5\u4e00\u7ef4\u6570\u7ec4\u7684\u683c\u5f0f\u8fd4\u56de\u6570\u636e", returnPropertiesFilter="parent", scope=NebulaServiceMethod.ScopeType.READ)
    public List<OrganizationVo> findByIdStruSelfAndDescendant(@ServiceMethodParam(name="id") String id) {
        Iterable orgs;
        if (StringUtils.isBlank((CharSequence)id)) {
            orgs = this.organizationRepository.findAll();
        } else {
            OrganizationEntity org = this.organizationRepository.findDetailsById(id);
            if (org == null) {
                return Lists.newArrayList();
            }
            orgs = Lists.newArrayList();
            orgs.add(org);
            orgs.addAll(this.findDescendant(org));
        }
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return Lists.newArrayList();
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(orgs, OrganizationEntity.class, OrganizationVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"parent"});
        return Lists.newArrayList((Iterable)collection);
    }

    @NebulaServiceMethod(name="OrganizationService.findByLevel", desc="\u6839\u636e\u7ec4\u7ec7\u5c42\u7ea7\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.READ)
    public List<OrganizationVo> findByLevel(@ServiceMethodParam(name="level") Integer level) {
        if (level == null) {
            return Lists.newArrayList();
        }
        List<OrganizationEntity> orgs = this.organizationRepository.findByLevel(level);
        if (CollectionUtils.isEmpty(orgs)) {
            return Lists.newArrayList();
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(orgs, OrganizationEntity.class, OrganizationVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)collection);
    }

    @NebulaServiceMethod(name="OrganizationService.findParentsByLevel", desc="\u6839\u636e\u5c42\u7ea7\u67e5\u8be2\u4e0a\u7ea7\u7ec4\u7ec7\u673a\u6784", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.READ)
    public List<OrganizationVo> findParentsByLevel(@ServiceMethodParam(name="level") Integer level) {
        if (level == null || level <= 1) {
            return Lists.newArrayList();
        }
        Integer n = level;
        Integer n2 = level = Integer.valueOf(level - 1);
        return this.findByLevel(level);
    }

    private List<OrganizationEntity> findDescendant(OrganizationEntity org) {
        ArrayList<OrganizationEntity> orgs = new ArrayList<OrganizationEntity>();
        Set<OrganizationEntity> children = org.getChild();
        if (CollectionUtils.isEmpty(children)) {
            return Lists.newArrayList();
        }
        Set<String> childrenIds = children.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        orgs.addAll(children);
        Set<OrganizationEntity> childOrgs = this.organizationRepository.findDetailsByIds(childrenIds);
        for (OrganizationEntity chid : childOrgs) {
            List<OrganizationEntity> descendant = this.findDescendant(chid);
            if (CollectionUtils.isEmpty(descendant)) continue;
            orgs.addAll(descendant);
        }
        return orgs;
    }

    private OrganizationVo findChildrenByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        OrganizationEntity organizationEntity = this.organizationRepository.findByCode(code);
        if (organizationEntity == null) {
            return null;
        }
        return this.findOrgTree(organizationEntity);
    }

    private void handleCircular(Set<OrganizationEntity> children, String parentId) {
        if (CollectionUtils.isEmpty(children) || StringUtils.isBlank((CharSequence)parentId)) {
            return;
        }
        for (OrganizationEntity child : children) {
            Validate.isTrue((!StringUtils.equals((CharSequence)child.getId(), (CharSequence)parentId) ? 1 : 0) != 0, (String)"\u5f62\u6210\u5faa\u73af\u4f9d\u8d56\uff0c\u66f4\u65b0\u5931\u8d25", (Object[])new Object[0]);
            this.handleCircular(child.getChild(), parentId);
        }
    }
}

