/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.local.service.internal;

import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.user.common.service.UserModelCodeGenerateService;
import com.bizunited.platform.user.common.service.position.PositionLevelEventListener;
import com.bizunited.platform.user.common.service.position.PositionLevelService;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.vo.PositionLevelVo;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.user.service.local.entity.PositionLevelEntity;
import com.bizunited.platform.user.service.local.repository.PositionLevelRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PositionLevelServiceImpl
implements PositionLevelService {
    @Autowired
    private PositionLevelRepository positionLevelRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private UserModelCodeGenerateService userModelCodeGenerateService;
    @Autowired(required=false)
    private List<PositionLevelEventListener> positionLevelEventListeners;

    @Transactional
    @NebulaServiceMethod(name="PositionLevelService.create", desc="\u521b\u5efa\u6a21\u578b\u5bf9\u8c61PositionLevelVo\u7684\u804c\u7ea7", scope=NebulaServiceMethod.ScopeType.WRITE, returnPropertiesFilter="")
    public PositionLevelVo create(PositionLevelVo positionLevelVo) {
        this.createValidation(positionLevelVo);
        if (StringUtils.isBlank((CharSequence)positionLevelVo.getCreateUser()) || StringUtils.isBlank((CharSequence)positionLevelVo.getModifyUser())) {
            UserVo user = SecurityUtils.getCurrentUser();
            positionLevelVo.setCreateUser(user.getAccount());
            positionLevelVo.setModifyUser(user.getAccount());
        }
        Date date = new Date();
        if (StringUtils.isNotBlank((CharSequence)positionLevelVo.getRoleCodeStr())) {
            positionLevelVo.setRoleCodes(Arrays.asList(positionLevelVo.getRoleCodeStr().split(",")));
        }
        PositionLevelEntity positionLevel = (PositionLevelEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)positionLevelVo, PositionLevelEntity.class, HashSet.class, ArrayList.class, new String[]{"roles"}));
        positionLevel.setCreateTime(date);
        positionLevel.setModifyDate(date);
        positionLevel.setState((Integer)ObjectUtils.defaultIfNull((Object)positionLevel.getState(), (Object)NormalStatusEnum.ENABLE.getStatus()));
        this.positionLevelRepository.save((Object)positionLevel);
        positionLevelVo.setId(positionLevel.getId());
        if (!CollectionUtils.isEmpty(this.positionLevelEventListeners)) {
            for (PositionLevelEventListener eventListener : this.positionLevelEventListeners) {
                eventListener.onPositionLevelCreated(positionLevelVo);
            }
        }
        return positionLevelVo;
    }

    private void createValidation(PositionLevelVo positionLevelVo) {
        Validate.notNull((Object)positionLevelVo, (String)"\u804c\u4f4d\u7ea7\u522b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)positionLevelVo.getId()), (String)"\u6dfb\u52a0\u804c\u4f4d\u7ea7\u522b\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165\u804c\u4f4d\u7ea7\u522bid,\u8bf7\u91cd\u65b0\u6dfb\u52a0!!", (Object[])new Object[0]);
        String name = positionLevelVo.getName();
        Validate.notBlank((CharSequence)name, (String)"\u804c\u4f4d\u7ea7\u522b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)positionLevelVo.getCode())) {
            positionLevelVo.setCode(this.userModelCodeGenerateService.positionLevelCodeGenerate());
        }
        Validate.isTrue((name == null || name.length() < 255 ? 1 : 0) != 0, (String)"\u804c\u7ea7\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        PositionLevelEntity currentPositionLevel = this.positionLevelRepository.findByCode(positionLevelVo.getCode());
        Validate.isTrue((currentPositionLevel == null ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u7684code,\u8bf7\u91cd\u65b0\u8f93\u5165\u804c\u4f4d\u7ea7\u522b\u7f16\u7801!!", (Object[])new Object[0]);
        PositionLevelEntity byName = this.positionLevelRepository.findByName(name);
        Validate.isTrue((byName == null ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u7684\u540d\u79f0,\u8bf7\u91cd\u65b0\u8f93\u5165\u804c\u4f4d\u7ea7\u522b\u540d\u79f0!!", (Object[])new Object[0]);
    }

    @Transactional
    @NebulaServiceMethod(name="PositionLevelService.update", desc="\u4fee\u6539\u6a21\u578bPositionLevelVo\u7684\u804c\u7ea7", scope=NebulaServiceMethod.ScopeType.WRITE, returnPropertiesFilter="")
    public PositionLevelVo update(PositionLevelVo positionLevelVo) {
        this.updateValidation(positionLevelVo);
        if (StringUtils.isNotBlank((CharSequence)positionLevelVo.getRoleCodeStr())) {
            positionLevelVo.setRoleCodes(Arrays.asList(positionLevelVo.getRoleCodeStr().split(",")));
        }
        String currentId = positionLevelVo.getId();
        PositionLevelEntity positionLevel = this.positionLevelRepository.findById(currentId).orElse(null);
        Validate.notNull((Object)((Object)positionLevel), (String)"\u672a\u5728\u6570\u636e\u5c42\u627e\u5230\u5bf9\u5e94\u7684\u804c\u4f4d\u7ea7\u522b\u4fe1\u606f", (Object[])new Object[0]);
        positionLevel.setName(positionLevelVo.getName());
        if (positionLevelVo.getState() != null) {
            positionLevel.setState(positionLevelVo.getState());
        }
        positionLevel.setExtend1(positionLevelVo.getExtend1());
        positionLevel.setExtend2(positionLevelVo.getExtend2());
        positionLevel.setExtend3(positionLevelVo.getExtend3());
        positionLevel.setExtend4(positionLevelVo.getExtend4());
        positionLevel.setExtend5(positionLevelVo.getExtend5());
        positionLevel.setExtend6(positionLevelVo.getExtend6());
        positionLevel.setExtend7(positionLevelVo.getExtend7());
        positionLevel.setExtend8(positionLevelVo.getExtend8());
        positionLevel.setExtend9(positionLevelVo.getExtend9());
        positionLevel.setExtend10(positionLevelVo.getExtend10());
        this.positionLevelRepository.save((Object)positionLevel);
        PositionLevelVo dbPositionLevel = (PositionLevelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)positionLevel, PositionLevelVo.class, HashSet.class, ArrayList.class, new String[0]);
        dbPositionLevel.setRoleCodes(positionLevelVo.getRoleCodes());
        if (!CollectionUtils.isEmpty(this.positionLevelEventListeners)) {
            for (PositionLevelEventListener eventListener : this.positionLevelEventListeners) {
                eventListener.onPositionLevelUpdated(dbPositionLevel);
            }
        }
        return dbPositionLevel;
    }

    private void updateValidation(PositionLevelVo positionLevelVo) {
        Validate.notNull((Object)positionLevelVo, (String)"\u804c\u4f4d\u7ea7\u522b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String id = positionLevelVo.getId();
        Validate.isTrue((!StringUtils.isBlank((CharSequence)id) ? 1 : 0) != 0, (String)"\u4fee\u6539\u804c\u4f4d\u7ea7\u522b\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u804c\u4f4d\u7ea7\u522bid,\u8bf7\u91cd\u65b0\u4fee\u6539!!", (Object[])new Object[0]);
        String name = positionLevelVo.getName();
        Validate.notBlank((CharSequence)name, (String)"\u804c\u4f4d\u7ea7\u522b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        PositionLevelEntity dbPositionLevel = this.positionLevelRepository.findByName(name);
        Validate.isTrue((dbPositionLevel == null || StringUtils.equals((CharSequence)dbPositionLevel.getId(), (CharSequence)id) ? 1 : 0) != 0, (String)"\u540d\u79f0\u4e3a[%s]\u7684\u804c\u7ea7\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[]{name});
    }

    @Transactional
    public void disableByIds(String[] positionLevelIds) {
        UserVo user = SecurityUtils.getCurrentUser();
        for (String positionLevelId : positionLevelIds) {
            PositionLevelEntity positionLevel = this.positionLevelRepository.findById(positionLevelId).orElse(null);
            Validate.notNull((Object)((Object)positionLevel), (String)"\u804c\u4f4d\u7ea7\u522b\u4e0d\u5b58\u5728:%s", (Object[])new Object[]{positionLevelId});
            if (NormalStatusEnum.DISABLE.getStatus().equals(positionLevel.getState())) continue;
            positionLevel.setState(NormalStatusEnum.DISABLE.getStatus());
            positionLevel.setModifyUser(user.getAccount());
            positionLevel.setModifyDate(new Date());
            this.positionLevelRepository.save((Object)positionLevel);
        }
    }

    @Transactional
    public void enableByIds(String[] ids) {
        UserVo user = SecurityUtils.getCurrentUser();
        for (String id : ids) {
            PositionLevelEntity positionLevel = this.positionLevelRepository.findById(id).orElse(null);
            Validate.notNull((Object)((Object)positionLevel), (String)"\u804c\u4f4d\u7ea7\u522b\u4e0d\u5b58\u5728:%s", (Object[])new Object[]{id});
            if (NormalStatusEnum.ENABLE.getStatus().equals(positionLevel.getState())) continue;
            positionLevel.setState(NormalStatusEnum.ENABLE.getStatus());
            positionLevel.setModifyUser(user.getAccount());
            positionLevel.setModifyDate(new Date());
            this.positionLevelRepository.save((Object)positionLevel);
        }
    }

    public PositionLevelVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        PositionLevelEntity positionLevel = this.positionLevelRepository.findByCode(code);
        if (positionLevel == null) {
            return null;
        }
        return (PositionLevelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)positionLevel, PositionLevelVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @NebulaServiceMethod(name="PositionLevelService.findById", desc="\u6839\u636eid\u67e5\u8be2\u804c\u7ea7", scope=NebulaServiceMethod.ScopeType.READ, returnPropertiesFilter="")
    public PositionLevelVo findById(@ServiceMethodParam(name="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        PositionLevelEntity positionLevel = this.positionLevelRepository.findById(id).orElse(null);
        PositionLevelVo positionLevelVo = (PositionLevelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)positionLevel, PositionLevelVo.class, HashSet.class, ArrayList.class, new String[0]);
        return positionLevelVo;
    }

    @Transactional
    public void deleteByIds(String[] ids) {
        Validate.notEmpty((Object[])ids, (String)"\u9700\u8981\u5220\u9664\u7684\u804c\u7ea7\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set positionVos = this.positionService.findByPositionLevelIds(ids);
        if (!CollectionUtils.isEmpty((Collection)positionVos)) {
            positionVos.forEach(p -> this.positionService.unbindParent(p.getId()));
        }
        for (String id : ids) {
            PositionLevelEntity positionLevel = this.positionLevelRepository.findById(id).orElse(null);
            Validate.notNull((Object)((Object)positionLevel), (String)"\u804c\u4f4d\u7ea7\u522b\u4e0d\u5b58\u5728:%s", (Object[])new Object[]{id});
            this.positionLevelRepository.delete((Object)positionLevel);
            PositionLevelVo positionLevelVo = (PositionLevelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)positionLevel, PositionLevelVo.class, HashSet.class, ArrayList.class, new String[]{"roleIds", "positions"});
            this.sendDeleteEvent(positionLevelVo);
        }
    }

    private void sendDeleteEvent(PositionLevelVo positionLevel) {
        if (CollectionUtils.isEmpty(this.positionLevelEventListeners) || positionLevel == null) {
            return;
        }
        this.positionLevelEventListeners.forEach(listener -> listener.onPositionLevelDeleted(positionLevel));
    }

    @NebulaServiceMethod(name="PositionLevelService.findAll", desc="\u67e5\u8be2\u6240\u6709\u804c\u7ea7\u5217\u8868(\u4e0d\u5305\u62ec\u5df2\u5220\u9664\u7684)", scope=NebulaServiceMethod.ScopeType.READ, returnPropertiesFilter="")
    public List<PositionLevelVo> findAll() {
        List positionLevelEntities = this.positionLevelRepository.findAll();
        if (CollectionUtils.isEmpty((Collection)positionLevelEntities)) {
            return Lists.newArrayList();
        }
        Collection positionVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)positionLevelEntities, PositionLevelEntity.class, PositionLevelVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isEmpty((Collection)positionVos)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)positionVos);
    }

    @NebulaServiceMethod(name="PositionLevelService.findByConditions", desc="\u6761\u4ef6\u67e5\u8be2\u804c\u7ea7\u5217\u8868", scope=NebulaServiceMethod.ScopeType.READ, returnPropertiesFilter="")
    public Page<PositionLevelVo> findByConditions(InvokeParams invokeParams, @ServiceMethodParam(name="pageable") Pageable pageable) {
        Map conditions;
        Page page = this.positionLevelRepository.findByConditions(pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50)), conditions = (Map)ObjectUtils.defaultIfNull((Object)(invokeParams = (InvokeParams)ObjectUtils.defaultIfNull((Object)invokeParams, (Object)new InvokeParams())).getInvokeParams(), (Object)Maps.newHashMap()));
        List positionLevels = page.getContent();
        if (positionLevels.isEmpty()) {
            return Page.empty((Pageable)pageable);
        }
        Collection positionLevelVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)positionLevels, PositionLevelEntity.class, PositionLevelVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new PageImpl(new ArrayList(positionLevelVos), pageable, page.getTotalElements());
    }
}

