/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.common.enums.RbacRelationEnum;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.user.common.service.UserMappingService;
import com.bizunited.platform.user.common.service.UserModelCodeGenerateService;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.service.position.PositionEventListener;
import com.bizunited.platform.user.common.service.position.PositionLevelService;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import com.bizunited.platform.user.common.vo.PositionLevelVo;
import com.bizunited.platform.user.common.vo.PositionSimpleVo;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.common.vo.UserMappingVo;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.user.service.local.entity.OrganizationEntity;
import com.bizunited.platform.user.service.local.entity.PositionEntity;
import com.bizunited.platform.user.service.local.entity.UserEntity;
import com.bizunited.platform.user.service.local.repository.PositionRepository;
import com.bizunited.platform.user.service.local.repository.UserRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.CollectionUtils;

public class PositionServiceImpl
implements PositionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionServiceImpl.class);
    @Autowired
    private PositionRepository positionRepository;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserMappingService userMappingService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private PositionLevelService positionLevelService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private UserModelCodeGenerateService userModelCodeGenerateService;
    @Autowired(required=false)
    private List<PositionEventListener> positionLevelEventListeners;

    @Transactional
    @NebulaServiceMethod(name="PositionService.create", desc="\u521b\u5efa\u4e00\u6761\u6a21\u578b\u4e3aPositionVo\u7684\u804c\u4f4d\u4fe1\u606f", scope=NebulaServiceMethod.ScopeType.WRITE, returnPropertiesFilter="")
    public PositionVo create(PositionVo positionVo) {
        Validate.notNull((Object)positionVo, (String)"\u5c97\u4f4d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)positionVo.getId()), (String)"\u6dfb\u52a0\u5c97\u4f4d\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165\u5c97\u4f4did,\u8bf7\u91cd\u65b0\u6dfb\u52a0!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionVo.getName(), (String)"\u5c97\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)positionVo.getCode())) {
            positionVo.setCode(this.userModelCodeGenerateService.positionCodeGenerate());
        }
        positionVo.setCreateTime(new Date());
        PositionEntity currentPosition = this.positionRepository.findByCode(positionVo.getCode());
        Validate.isTrue((null == currentPosition ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u7684code,\u8bf7\u91cd\u65b0\u8f93\u5165\u5c97\u4f4d\u7f16\u7801!!", (Object[])new Object[0]);
        if (positionVo.getParent() != null) {
            Validate.notBlank((CharSequence)positionVo.getParent().getId(), (String)"\u672a\u627e\u5230\u8be5\u5c97\u4f4d\u7684\u4e0a\u7ea7\u5c97\u4f4d\u7684id\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            PositionEntity parent = this.positionRepository.findById(positionVo.getParent().getId()).orElse(null);
            Validate.notNull((Object)((Object)parent), (String)"\u672a\u627e\u5230\u8be5\u5c97\u4f4d\u7684\u4e0a\u7ea7\u5c97\u4f4d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        }
        if (positionVo.getOrganization() != null) {
            Validate.notBlank((CharSequence)positionVo.getOrganization().getId(), (String)"\u672a\u627e\u5230\u8be5\u5c97\u4f4d\u7ed1\u5b9a\u7684\u7ec4\u7ec7id\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            OrganizationVo organizationVo = this.organizationService.findById(positionVo.getOrganization().getId());
            Validate.notNull((Object)organizationVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8be5\u5c97\u4f4d\u7ed1\u5b9a\u7684\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        }
        PositionEntity positionEntity = (PositionEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)positionVo, PositionEntity.class, HashSet.class, ArrayList.class, new String[]{"parent", "organization"}));
        this.positionRepository.save((Object)positionEntity);
        positionVo.setId(positionEntity.getId());
        if (!CollectionUtils.isEmpty(this.positionLevelEventListeners)) {
            for (PositionEventListener listener : this.positionLevelEventListeners) {
                listener.onPositionCreated(positionVo);
            }
        }
        return positionVo;
    }

    @Transactional
    @NebulaServiceMethod(name="PositionService.update", desc="\u4fee\u6539\u4e00\u6761\u6a21\u578b\u4e3aPositionVo\u7684\u804c\u4f4d\u4fe1\u606f", scope=NebulaServiceMethod.ScopeType.WRITE, returnPropertiesFilter="")
    public PositionVo update(PositionVo positionVo) {
        Validate.notNull((Object)positionVo, (String)"\u5c97\u4f4d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.isBlank((CharSequence)positionVo.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u5c97\u4f4d\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u5c97\u4f4did,\u8bf7\u91cd\u65b0\u4fee\u6539!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionVo.getName(), (String)"\u5c97\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Optional op = this.positionRepository.findById(positionVo.getId());
        PositionEntity position = op.orElse(null);
        Validate.notNull((Object)((Object)position), (String)"\u672a\u5728\u6570\u636e\u5c42\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\u4fe1\u606f", (Object[])new Object[0]);
        if (positionVo.getParent() != null) {
            String parentId = positionVo.getParent().getId();
            Validate.notBlank((CharSequence)parentId, (String)"\u672a\u627e\u5230\u8be5\u5c97\u4f4d\u7684\u4e0a\u7ea7\u5c97\u4f4d\u7684id\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            Validate.isTrue((!positionVo.getId().equals(parentId) ? 1 : 0) != 0, (String)"\u7981\u6b62\u5c06\u8be5\u5c97\u4f4d\u672c\u8eab\u8bbe\u7f6e\u4e3a\u4e0a\u7ea7\u5c97\u4f4d", (Object[])new Object[0]);
            PositionEntity parent = this.positionRepository.findById(parentId).orElse(null);
            Validate.notNull((Object)((Object)parent), (String)"\u672a\u627e\u5230\u8be5\u5c97\u4f4d\u7684\u4e0a\u7ea7\u5c97\u4f4d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            position.setParent(parent);
            HashSet<String> positionStack = new HashSet<String>();
            positionStack.add(parentId);
            this.validateCircular(position, positionStack);
        } else {
            position.setParent(null);
        }
        if (positionVo.getOrganization() != null) {
            OrganizationVo organizationVo = this.organizationService.findById(positionVo.getOrganization().getId());
            Validate.notNull((Object)organizationVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6240\u5c5e\u7ec4\u7ec7", (Object[])new Object[0]);
            OrganizationEntity organizationEntity = new OrganizationEntity();
            organizationEntity.setId(organizationVo.getId());
            position.setOrganization(organizationEntity);
        } else {
            position.setOrganization(null);
        }
        position.setName(positionVo.getName());
        position.setExtend1(positionVo.getExtend1());
        position.setExtend2(positionVo.getExtend2());
        position.setExtend3(positionVo.getExtend3());
        position.setExtend4(positionVo.getExtend4());
        position.setExtend5(positionVo.getExtend5());
        position.setExtend6(positionVo.getExtend6());
        position.setExtend7(positionVo.getExtend7());
        position.setExtend8(positionVo.getExtend8());
        position.setExtend9(positionVo.getExtend9());
        position.setExtend10(positionVo.getExtend10());
        this.positionRepository.save((Object)position);
        if (!CollectionUtils.isEmpty(this.positionLevelEventListeners)) {
            for (PositionEventListener listener : this.positionLevelEventListeners) {
                listener.onPositionUpdated(positionVo);
            }
        }
        return (PositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)position, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void validateCircular(PositionEntity parent, Set<String> positionStack) {
        if (CollectionUtils.isEmpty(parent.getChildren())) {
            return;
        }
        for (PositionEntity positionEntity : parent.getChildren()) {
            Validate.isTrue((!positionStack.contains(positionEntity.getId()) ? 1 : 0) != 0, (String)"\u5f62\u6210\u5faa\u73af\u4f9d\u8d56\uff0c\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            positionStack.add(positionEntity.getId());
            this.validateCircular(positionEntity, positionStack);
        }
    }

    @Transactional
    public PositionVo updateStatus(String positionId) {
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4did\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Optional op = this.positionRepository.findById(positionId);
        PositionEntity position = op.orElse(null);
        Validate.notNull((Object)((Object)position), (String)"\u6ca1\u6709\u8be5\u5c97\u4f4d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Integer status = position.getTstatus();
        status = status == 1 ? 0 : 1;
        position.setTstatus(status);
        this.positionRepository.save((Object)position);
        return (PositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)position, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @NebulaServiceMethod(name="PositionService.findDetailsById", desc="\u6839\u636eid\u67e5\u8be2\u804c\u4f4d\u8be6\u60c5", scope=NebulaServiceMethod.ScopeType.READ, returnPropertiesFilter="organization,roles,users,parent")
    public PositionVo findDetailsById(@ServiceMethodParam(name="id") String positionId) {
        if (StringUtils.isBlank((CharSequence)positionId)) {
            return null;
        }
        PositionEntity positionEntity = this.positionRepository.findDetailsById(positionId);
        Validate.notNull((Object)((Object)positionEntity), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f20\u53c2!!", (Object[])new Object[0]);
        return (PositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)positionEntity, PositionVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"organization", "roles", "users", "parent"});
    }

    @Transactional
    @NebulaServiceMethod(name="PositionService.bindOrg", desc="\u804c\u4f4d\u7ed1\u5b9a\u7ec4\u7ec7", scope=NebulaServiceMethod.ScopeType.WRITE, returnPropertiesFilter="")
    public void bindOrg(@ServiceMethodParam(name="orgId") String orgId, @ServiceMethodParam(name="positionId") String positionId) {
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        OrganizationVo organizationVo = this.organizationService.findById(orgId);
        Validate.notNull((Object)organizationVo, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784!", (Object[])new Object[0]);
        OrganizationEntity organization = (OrganizationEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)organizationVo, OrganizationEntity.class, HashSet.class, ArrayList.class, new String[0]));
        Optional op = this.positionRepository.findById(positionId);
        PositionEntity position = op.orElse(null);
        Validate.notNull((Object)((Object)position), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d!", (Object[])new Object[0]);
        Validate.isTrue((null == position.getOrganization() ? 1 : 0) != 0, (String)"\u8be5\u5c97\u4f4d\u5df2\u7ed1\u5b9a\u6709\u7ec4\u7ec7\u673a\u6784\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        position.setOrganization(organization);
        this.positionRepository.saveAndFlush((Object)position);
    }

    @Transactional
    @NebulaServiceMethod(name="PositionService.unbindOrg", desc="\u804c\u4f4d\u89e3\u7ed1\u7ec4\u7ec7", scope=NebulaServiceMethod.ScopeType.WRITE, returnPropertiesFilter="")
    public void unbindOrg(@ServiceMethodParam(name="positionId") String positionId) {
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional op = this.positionRepository.findById(positionId);
        PositionEntity position = op.orElse(null);
        Validate.notNull((Object)((Object)position), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d!", (Object[])new Object[0]);
        position.setOrganization(null);
        this.positionRepository.saveAndFlush((Object)position);
    }

    @Transactional
    public void reBindOrg(String orgId, String positionId) {
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        OrganizationVo organizationVo = this.organizationService.findById(orgId);
        Validate.notNull((Object)organizationVo, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784", (Object[])new Object[0]);
        OrganizationEntity organization = (OrganizationEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)organizationVo, OrganizationEntity.class, HashSet.class, ArrayList.class, new String[0]));
        Optional op = this.positionRepository.findById(positionId);
        PositionEntity position = op.orElse(null);
        Validate.notNull((Object)((Object)position), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d!", (Object[])new Object[0]);
        position.setOrganization(organization);
        this.positionRepository.saveAndFlush((Object)position);
    }

    @Transactional
    public void bindUsersAndPosition(List<String> userIds, String positionId) {
        Validate.isTrue((!CollectionUtils.isEmpty(userIds) ? 1 : 0) != 0, (String)"\u7528\u6237ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        UserMappingVo mappingVo = this.userMappingService.findOne();
        userIds.stream().forEach(o -> this.bindUserAndPosition(mappingVo, (String)o, positionId));
    }

    private void validateBindUser(UserMappingVo mappingVo, String positionId, String userId) {
        if (mappingVo == null) {
            long count = this.positionRepository.countByUserAndPosition(userId, positionId);
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
        } else {
            long count;
            int bindRelation = mappingVo.getUserPositionRelation();
            if (bindRelation == RbacRelationEnum.MANY_TO_MANY.getRelation()) {
                count = this.positionRepository.countByUserAndPosition(userId, positionId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5c97\u4f4d\u591a\u5bf9\u591a\uff0c\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
            }
            if (bindRelation == RbacRelationEnum.MANY_TO_ONE.getRelation()) {
                count = this.positionRepository.countPositionByUserId(userId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5c97\u4f4d\u591a\u5bf9\u4e00\uff0c\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5c97\u4f4d\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
            }
            if (bindRelation == RbacRelationEnum.ONE_TO_MANY.getRelation()) {
                count = this.positionRepository.countUserByPositionId(positionId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5c97\u4f4d\u4e00\u5bf9\u591a\uff0c\u6307\u5b9a\u5c97\u4f4d[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u7528\u6237\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{positionId});
            }
            if (bindRelation == RbacRelationEnum.ONE_TO_ONE.getRelation()) {
                long countUser = this.positionRepository.countUserByPositionId(positionId);
                Validate.isTrue((countUser == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5c97\u4f4d\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u5c97\u4f4d[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u7528\u6237\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{positionId});
                long countPosition = this.positionRepository.countPositionByUserId(userId);
                Validate.isTrue((countPosition == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5c97\u4f4d\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5c97\u4f4d\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
            }
        }
    }

    private void bindUserAndPosition(UserMappingVo mappingVo, String userId, String positionId) {
        Validate.notBlank((CharSequence)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        UserVo user = this.userService.findByUserId(userId);
        Validate.notNull((Object)user, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7528\u6237!", (Object[])new Object[0]);
        Optional optional = this.positionRepository.findById(positionId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d!", (Object[])new Object[0]);
        this.validateBindUser(mappingVo, positionId, userId);
        this.positionRepository.bindUser(userId, positionId);
    }

    @Transactional
    public void unbindUsersAndPosition(List<String> userIds, String positionId) {
        Validate.notEmpty(userIds, (String)"\u7528\u6237ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        userIds.stream().forEach(o -> this.unbindUserAndPosition((String)o, positionId));
    }

    private void unbindUserAndPosition(String userId, String positionId) {
        Validate.notBlank((CharSequence)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        UserVo user = this.userService.findByUserId(userId);
        Validate.notNull((Object)user, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7528\u6237!", (Object[])new Object[0]);
        PositionEntity position = this.positionRepository.findById(positionId).orElse(null);
        Validate.notNull((Object)((Object)position), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d!", (Object[])new Object[0]);
        Validate.isTrue((0L != this.positionRepository.countByUserAndPosition(userId, positionId) ? 1 : 0) != 0, (String)"\u8be5\u7528\u6237\u4e0e\u8be5\u5c97\u4f4d\u672a\u6709\u7ed1\u5b9a\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        PositionVo positionVo = null;
        String key = "rbac:user:" + userId;
        RMap mainPosition = this.redissonClient.getMap(key);
        if (mainPosition.containsKey("mainPosition")) {
            positionVo = (PositionVo)JSONObject.parseObject((String)((String)mainPosition.get("mainPosition")), PositionVo.class);
        }
        if (positionVo != null) {
            Validate.isTrue((!positionId.equals(positionVo.getId()) ? 1 : 0) != 0, (String)"[%s]\u662f\u7528\u6237\u7684\u4e3b\u5c97\u4f4d\u4e0d\u80fd\u89e3\u7ed1", (Object[])new Object[]{position.getName()});
        }
        this.positionRepository.unbindUser(userId, positionId);
        if (!CollectionUtils.isEmpty(this.positionLevelEventListeners)) {
            PositionVo dbPositionVo = (PositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)position, PositionVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            for (PositionEventListener positionLevelEventListener : this.positionLevelEventListeners) {
                positionLevelEventListener.onUnbindUser(dbPositionVo, user);
            }
        }
    }

    public List<PositionVo> findByUserId(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Lists.newArrayList();
        }
        Set<PositionEntity> positions = this.positionRepository.findByUserId(userId);
        if (CollectionUtils.isEmpty(positions)) {
            return Lists.newArrayList();
        }
        Collection positionVos = this.nebulaToolkitService.copyCollectionByWhiteList(positions, PositionEntity.class, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)positionVos);
    }

    public List<PositionVo> findByUserAccount(String userAccount) {
        if (StringUtils.isBlank((CharSequence)userAccount)) {
            return Lists.newArrayList();
        }
        Set<PositionEntity> positions = this.positionRepository.findByUserAccount(userAccount);
        if (CollectionUtils.isEmpty(positions)) {
            return Lists.newArrayList();
        }
        Collection positionVos = this.nebulaToolkitService.copyCollectionByWhiteList(positions, PositionEntity.class, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)positionVos);
    }

    public Set<PositionVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Sets.newHashSet();
        }
        Set<PositionEntity> pos = this.positionRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(pos)) {
            return Sets.newHashSet();
        }
        Collection pvo = this.nebulaToolkitService.copyCollectionByWhiteList(pos, PositionEntity.class, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet((Iterable)pvo);
    }

    public Page<PositionVo> findByConditions(Map<String, Object> conditions, Pageable pageable) {
        Page page;
        List content;
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (CollectionUtils.isEmpty((Collection)(content = (page = this.positionRepository.queryPage(pageable, conditions)).getContent()))) {
            return Page.empty((Pageable)pageable);
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)content, PositionEntity.class, PositionVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"parent", "organization", "positionLevel"});
        return new PageImpl((List)Lists.newArrayList((Iterable)collection), pageable, page.getTotalElements());
    }

    @NebulaServiceMethod(name="PositionService.findByConditions", desc="\u6761\u4ef6\u67e5\u8be2\u804c\u4f4d\u5217\u8868", scope=NebulaServiceMethod.ScopeType.READ, returnPropertiesFilter="positionLevel,parent,organization")
    public Page<PositionVo> findByConditions(@ServiceMethodParam(name="pageable") Pageable pageable, InvokeParams invokeParams) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        invokeParams = (InvokeParams)ObjectUtils.defaultIfNull((Object)invokeParams, (Object)new InvokeParams());
        Map params = invokeParams.getInvokeParams();
        return this.findByConditions(params, pageable);
    }

    public PositionVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        PositionEntity position = this.positionRepository.findByCode(code);
        if (position == null) {
            return null;
        }
        return (PositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)position, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public UserVo changePosition(String positionId, String userId) {
        Validate.notBlank((CharSequence)positionId, (String)"\u5207\u6362\u5c97\u4f4did\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)userId, (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserVo user = this.userService.findByUserId(userId);
        Validate.notNull((Object)user, (String)"\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        PositionEntity positionEntity = this.positionRepository.findById(positionId).orElse(null);
        Validate.notNull((Object)((Object)positionEntity), (String)"\u672a\u83b7\u53d6\u5230\u5c97\u4f4d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        PositionVo positionVo = (PositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)positionEntity, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<PositionVo> positionVos = this.findByUserId(userId);
        user.setPositions((Set)Sets.newLinkedHashSet(positionVos));
        user.setMainPosition(positionId);
        RMap mainPosition = this.redissonClient.getMap("rbac:user:" + userId);
        mainPosition.put("mainPosition", JSONObject.toJSON((Object)positionVo).toString());
        return user;
    }

    @NebulaServiceMethod(name="PositionService.findMainPositionByUserId", desc="\u67e5\u8be2\u4eba\u5458\u5f53\u524d\u767b\u5f55\u804c\u4f4d", scope=NebulaServiceMethod.ScopeType.READ, returnPropertiesFilter="")
    public PositionVo findMainPositionByUserId(@ServiceMethodParam(name="userId") String userId) {
        Validate.notBlank((CharSequence)userId, (String)"\u4f20\u5165\u7684\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PositionVo positionVo = null;
        String key = "rbac:user:" + userId;
        RMap mainPosition = this.redissonClient.getMap(key);
        if (mainPosition.containsKey("mainPosition")) {
            positionVo = (PositionVo)JSONObject.parseObject((String)((String)mainPosition.get("mainPosition")), PositionVo.class);
        }
        if (positionVo == null) {
            List<PositionVo> positionVoList = this.findByUserId(userId);
            if (CollectionUtils.isEmpty(positionVoList)) {
                return null;
            }
            positionVo = positionVoList.get(0);
            String json = JSONObject.toJSON((Object)positionVo).toString();
            mainPosition.put("mainPosition", json);
        }
        return positionVo;
    }

    @Transactional
    public void rebindUsers(String[] userIds, String positionId) {
        Sets.SetView needUnbindsUserIds;
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Set users = this.userService.findByPositionId(positionId);
        if (users == null) {
            users = Sets.newHashSet();
        }
        Set bindedUserIds = users.stream().map(UuidVo::getId).collect(Collectors.toSet());
        HashSet<String> currentUserIds = new HashSet<String>();
        if (userIds != null) {
            for (String userId : userIds) {
                currentUserIds.add(userId);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(needUnbindsUserIds = Sets.difference(bindedUserIds, currentUserIds)))) {
            for (String userId : needUnbindsUserIds) {
                if (StringUtils.isBlank((CharSequence)userId)) continue;
                this.unbindUserAndPosition(userId, positionId);
            }
        }
        Sets.SetView needbindsUserIds = Sets.difference(currentUserIds, bindedUserIds);
        UserMappingVo mappingVo = this.userMappingService.findOne();
        if (!CollectionUtils.isEmpty((Collection)needbindsUserIds)) {
            for (String userId : needbindsUserIds) {
                if (StringUtils.isBlank((CharSequence)userId)) continue;
                this.bindUserAndPosition(mappingVo, userId, positionId);
            }
        }
    }

    public List<PositionVo> findAll() {
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")});
        List positions = this.positionRepository.findAll(sort);
        if (CollectionUtils.isEmpty((Collection)positions)) {
            return Lists.newArrayList();
        }
        Collection positionVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)positions, PositionEntity.class, PositionVo.class, HashSet.class, ArrayList.class, new String[]{"parent"});
        return Lists.newArrayList((Iterable)positionVos);
    }

    public List<PositionVo> findByStatus(Integer status) {
        List<PositionEntity> positions = this.positionRepository.findByTstatus(status);
        if (CollectionUtils.isEmpty(positions)) {
            return Lists.newArrayList();
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(positions, PositionEntity.class, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)collection);
    }

    public Set<PositionVo> findByPrincipal(Integer type, Principal principal) {
        Validate.notNull((Object)type, (String)"\u4f20\u5165\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String account = principal.getName();
        UserEntity user = this.userRepository.findByAccount(account);
        Validate.notNull((Object)((Object)user), (String)"\u672a\u83b7\u53d6\u767b\u9646\u4eba\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Set<PositionVo> positions = null;
        switch (type) {
            case 1: {
                positions = this.findParent(user);
                break;
            }
            case 2: {
                positions = this.findChildren(user);
                break;
            }
            case 3: {
                positions = this.findParentAndChildren(user);
                break;
            }
            case 4: {
                positions = this.findPosition(user);
                break;
            }
        }
        if (CollectionUtils.isEmpty(positions)) {
            return Sets.newHashSet();
        }
        return positions;
    }

    private Set<PositionVo> findParent(UserEntity user) {
        HashSet<PositionVo> result = new HashSet<PositionVo>();
        HashSet<PositionVo> removes = new HashSet<PositionVo>();
        HashMap<String, PositionVo> parentMap = new HashMap<String, PositionVo>();
        Set<PositionVo> rootPositions = this.findPosition(user);
        for (PositionVo rootPosition : rootPositions) {
            rootPosition.setParent(this.findAllParent(rootPosition, parentMap));
            result.add(rootPosition);
        }
        for (PositionVo item : result) {
            if (!parentMap.containsKey(item.getId())) continue;
            removes.add(item);
        }
        for (PositionVo remove : removes) {
            result.remove(remove);
        }
        return result;
    }

    private Set<PositionVo> findPosition(UserEntity user) {
        Set<PositionEntity> positions = this.positionRepository.findByUserId(user.getId());
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList(positions, PositionEntity.class, PositionVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet((Iterable)result);
    }

    private PositionVo findAllParent(PositionVo rootPosition, Map<String, PositionVo> parentMap) {
        PositionEntity currentPosition = this.positionRepository.findById(rootPosition.getId()).orElse(null);
        PositionEntity parent = currentPosition.getParent();
        if (parent == null) {
            return null;
        }
        PositionVo positionVo = (PositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)parent, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
        parentMap.put(positionVo.getId(), positionVo);
        positionVo.setParent(this.findAllParent(positionVo, parentMap));
        return positionVo;
    }

    private Set<PositionVo> findChildren(UserEntity user) {
        HashSet<PositionVo> result = new HashSet<PositionVo>();
        HashSet<PositionVo> removes = new HashSet<PositionVo>();
        HashMap<String, PositionVo> childMap = new HashMap<String, PositionVo>();
        Set<PositionVo> rootPositions = this.findPosition(user);
        for (PositionVo rootPosition : rootPositions) {
            rootPosition.setChildren(this.findAllChildren(rootPosition, childMap));
            result.add(rootPosition);
        }
        for (PositionVo item : result) {
            if (!childMap.containsKey(item.getId())) continue;
            removes.add(item);
        }
        for (PositionVo remove : removes) {
            result.remove(remove);
        }
        return result;
    }

    private Set<PositionVo> findAllChildren(PositionVo position, Map<String, PositionVo> childMap) {
        HashSet<PositionVo> result = new HashSet<PositionVo>();
        PositionEntity currentPosition = this.positionRepository.findById(position.getId()).orElse(null);
        Set<PositionEntity> children = currentPosition.getChildren();
        if (CollectionUtils.isEmpty(children)) {
            return Sets.newHashSet();
        }
        for (PositionEntity child : children) {
            PositionVo positionVo = (PositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)child, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
            childMap.put(positionVo.getId(), positionVo);
            positionVo.setChildren(this.findAllChildren(positionVo, childMap));
            result.add(positionVo);
        }
        return result;
    }

    private Set<PositionVo> findParentAndChildren(UserEntity user) {
        HashSet<PositionVo> result = new HashSet<PositionVo>();
        HashSet<PositionVo> removes = new HashSet<PositionVo>();
        HashMap<String, PositionVo> childMap = new HashMap<String, PositionVo>();
        HashMap<String, PositionVo> parentMap = new HashMap<String, PositionVo>();
        Set<PositionVo> rootPositions = this.findPosition(user);
        for (PositionVo rootPosition : rootPositions) {
            rootPosition.setChildren(this.findAllChildren(rootPosition, childMap));
            rootPosition.setParent(this.findAllParent(rootPosition, parentMap));
            result.add(rootPosition);
        }
        for (PositionVo item : result) {
            if (!childMap.containsKey(item.getId())) continue;
            removes.add(item);
        }
        for (PositionVo remove : removes) {
            result.remove(remove);
        }
        return result;
    }

    public Set<PositionVo> findByTypeAndLevel(Integer type, Principal principal, Integer level) {
        Validate.notNull((Object)type, (String)"\u4f20\u5165\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notNull((Object)level, (String)"\u4f20\u5165\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String account = principal.getName();
        UserEntity user = this.userRepository.findByAccount(account);
        Validate.notNull((Object)((Object)user), (String)"\u672a\u83b7\u53d6\u767b\u9646\u4eba\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Set<PositionVo> positions = null;
        String[] propertiesFilter = new String[level.intValue()];
        HashSet<PositionVo> newPositions = new HashSet<PositionVo>();
        switch (type) {
            case 1: {
                positions = this.findParent(user);
                this.bindPropertiesFilter(level, propertiesFilter, "parent");
                break;
            }
            case 2: {
                positions = this.findChildren(user);
                this.bindPropertiesFilter(level, propertiesFilter, "children");
                break;
            }
        }
        if (CollectionUtils.isEmpty(positions)) {
            return Sets.newHashSet();
        }
        for (PositionVo position : positions) {
            PositionVo positionVo = (PositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)position, PositionVo.class, HashSet.class, ArrayList.class, propertiesFilter);
            newPositions.add(positionVo);
        }
        return newPositions;
    }

    public Set<PositionVo> findByPositionLevelIds(String[] positionLevelIds) {
        if (ArrayUtils.isEmpty((Object[])positionLevelIds)) {
            return Sets.newHashSet();
        }
        Set<PositionEntity> positionEntities = this.positionRepository.findByPositionLevelIds(positionLevelIds);
        if (CollectionUtils.isEmpty(positionEntities)) {
            return Sets.newHashSet();
        }
        Collection positionVos = this.nebulaToolkitService.copyCollectionByWhiteList(positionEntities, PositionEntity.class, PositionVo.class, LinkedHashSet.class, LinkedList.class, new String[0]);
        return Sets.newHashSet((Iterable)positionVos);
    }

    @Transactional
    public void disableByIds(String[] ids) {
        Validate.notEmpty((Object[])ids, (String)"\u804c\u7ea7\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (String id : ids) {
            PositionEntity positionEntity = this.positionRepository.findById(id).orElse(null);
            Validate.notNull((Object)((Object)positionEntity), (String)"\u627e\u4e0d\u5230\u4e3b\u952e\u5bf9\u5e94\u7684\u804c\u4f4d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            positionEntity.setTstatus(0);
            this.positionRepository.save((Object)positionEntity);
        }
    }

    @Transactional
    public void enableByIds(String[] ids) {
        Validate.notEmpty((Object[])ids, (String)"\u804c\u4f4d\u4e3b\u952e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (String id : ids) {
            PositionEntity positionEntity = this.positionRepository.findById(id).orElse(null);
            Validate.notNull((Object)((Object)positionEntity), (String)"\u627e\u4e0d\u5230\u4e3b\u952e\u5bf9\u5e94\u7684\u804c\u4f4d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            positionEntity.setTstatus(1);
            this.positionRepository.save((Object)positionEntity);
        }
    }

    @Transactional
    public void reBindOrgCode(String[] codes, String orgCode) {
        Validate.notEmpty((Object[])codes, (String)"\u5c97\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orgCode, (String)"\u7ec4\u7ec7\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        OrganizationVo organizationVo = this.organizationService.findByCode(orgCode);
        Validate.notNull((Object)organizationVo, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784!", (Object[])new Object[0]);
        OrganizationEntity entity = new OrganizationEntity();
        entity.setId(organizationVo.getId());
        for (String code : codes) {
            PositionEntity position = this.positionRepository.findByCode(code);
            Validate.notNull((Object)((Object)position), (String)"\u672a\u627e\u5230\u6307\u5b9a[%s]\u7684\u5c97\u4f4d!", (Object[])new Object[]{code});
            position.setOrganization(entity);
            this.positionRepository.saveAndFlush((Object)position);
        }
    }

    public Page<PositionSimpleVo> findByPositionLevelAndConditions(Pageable pageable, Map<String, Object> conditions) {
        if (conditions == null) {
            conditions = Maps.newHashMap();
        }
        return this.positionRepository.findByPositionLevelAndConditions(pageable, conditions);
    }

    public List<PositionVo> findByUserIdStruDescendant(String userId) {
        Set<PositionEntity> positionEntities = this.positionRepository.findDetailsByUserId(userId);
        ArrayList resultList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(positionEntities)) {
            return Lists.newArrayList();
        }
        positionEntities.forEach(p -> this.findStruDescendant((PositionEntity)((Object)p), resultList));
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)resultList, PositionEntity.class, PositionVo.class, HashSet.class, ArrayList.class, new String[]{"users"}));
    }

    @Transactional
    public PositionVo bindParent(String id, String parentId) {
        Validate.notBlank((CharSequence)id, (String)"\u5f53\u524d\u804c\u4f4did\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)parentId, (String)"\u9700\u8981\u7ed1\u5b9a\u7684\u7236\u7ea7\u804c\u4f4did\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PositionEntity positionEntity = this.positionRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)positionEntity), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u5f53\u524d\u804c\u4f4d\u4fe1\u606f", (Object[])new Object[0]);
        PositionEntity parent = this.positionRepository.findById(parentId).orElse(null);
        Validate.notNull((Object)((Object)parent), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u7236\u7ea7\u804c\u4f4d\u4fe1\u606f", (Object[])new Object[0]);
        positionEntity.setParent(parent);
        this.positionRepository.saveAndFlush((Object)positionEntity);
        return (PositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)positionEntity, PositionVo.class, HashSet.class, ArrayList.class, new String[]{"organization", "users", "parent", "positionLevel"});
    }

    private void findStruDescendant(PositionEntity positionEntity, List<PositionEntity> resultList) {
        if (positionEntity == null || resultList == null) {
            return;
        }
        Set<PositionEntity> children = positionEntity.getChildren();
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        children.forEach(p -> {
            resultList.add((PositionEntity)((Object)p));
            this.findStruDescendant((PositionEntity)((Object)p), resultList);
        });
    }

    @Transactional
    public void unbindParent(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u804c\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PositionEntity position = this.positionRepository.findById(id).orElse(null);
        position.setParent(null);
        this.positionRepository.save((Object)position);
    }

    private void bindPropertiesFilter(Integer level, String[] propertiesFilter, String type) {
        String temp = "";
        for (int i = 0; i < level; ++i) {
            temp = temp + type + ".";
            if (i + 1 == level) {
                temp = temp.substring(0, temp.length() - 1);
            }
            propertiesFilter[i] = temp;
        }
    }

    @Transactional
    public PositionVo createByPositionLevelCode(String levelCode) {
        Validate.notBlank((CharSequence)levelCode, (String)"\u804c\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PositionLevelVo positionLevel = this.positionLevelService.findByCode(levelCode);
        Validate.notNull((Object)positionLevel, (String)"\u804c\u7ea7\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        PositionVo position = new PositionVo();
        position.setCode(this.userModelCodeGenerateService.positionCodeGenerate());
        position.setName(this.buildName(positionLevel));
        position.setCreateTime(new Date());
        position.setPositionLevel(positionLevel);
        position.setTstatus(NormalStatusEnum.ENABLE.getStatus());
        return this.create(position);
    }

    @NebulaServiceMethod(name="PositionService.findDetailsByOrgCode", desc="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u76f8\u5173\u4fe1\u606f\uff08\u5305\u62ec\u7ec4\u7ec7\uff0c\u804c\u7ea7\uff0c\u7528\u6237\uff0c\u4e0b\u7ea7\u804c\u4f4d\uff09", scope=NebulaServiceMethod.ScopeType.READ, returnPropertiesFilter="positionLevel,users,organization,children")
    public List<PositionVo> findDetailsByOrgCode(@ServiceMethodParam(name="orgCode") String orgCode) {
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            return Lists.newArrayList();
        }
        List<PositionEntity> positions = this.positionRepository.findDetailsByOrgCode(orgCode);
        if (CollectionUtils.isEmpty(positions)) {
            return Lists.newArrayList();
        }
        Collection positionVos = this.nebulaToolkitService.copyCollectionByWhiteList(positions, PositionEntity.class, PositionVo.class, HashSet.class, ArrayList.class, new String[]{"positionLevel", "users", "organization", "children"});
        if (CollectionUtils.isEmpty((Collection)positionVos)) {
            return Lists.newArrayList();
        }
        positionVos.forEach(p -> this.buildViewName((PositionVo)p));
        return Lists.newArrayList((Iterable)positionVos);
    }

    private void buildViewName(PositionVo positionVo) {
        OrganizationVo organizationVo = positionVo.getOrganization();
        Set userVos = positionVo.getUsers();
        StringBuilder viewName = new StringBuilder();
        if (organizationVo != null) {
            viewName.append(organizationVo.getOrgName()).append("/");
        }
        viewName.append(positionVo.getName());
        if (!CollectionUtils.isEmpty((Collection)userVos)) {
            viewName.append("/");
            Iterator<UserVo> userVoIterator = userVos.iterator();
            userVoIterator.forEachRemaining(u -> viewName.append(u.getUserName()).append(userVoIterator.hasNext() ? "\u3001" : ""));
        }
        positionVo.setViewName(viewName.toString());
    }

    public List<PositionVo> findDetailsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return Lists.newArrayList();
        }
        PositionEntity parent = this.positionRepository.findByCode(code);
        if (parent == null) {
            return Lists.newArrayList();
        }
        List<PositionEntity> positions = this.positionRepository.findDetailsByParentId(parent.getId());
        if (CollectionUtils.isEmpty(positions)) {
            return Lists.newArrayList();
        }
        Collection positionVos = this.nebulaToolkitService.copyCollectionByWhiteList(positions, PositionEntity.class, PositionVo.class, HashSet.class, ArrayList.class, new String[]{"positionLevel", "users", "organization"});
        return Lists.newArrayList((Iterable)positionVos);
    }

    public PositionVo findPositionDetailByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        PositionEntity detailsByCode = this.positionRepository.findDetailsByCode(code);
        if (detailsByCode == null) {
            return null;
        }
        return (PositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)detailsByCode, PositionVo.class, LinkedHashSet.class, LinkedList.class, new String[]{"organization", "users", "positionLevel"});
    }

    private String buildName(PositionLevelVo positionLevel) {
        Validate.notNull((Object)positionLevel, (String)"\u804c\u7ea7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionLevel.getName(), (String)"\u804c\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String positionName = "";
        try {
            String regEx;
            Pattern p;
            Matcher m;
            String trim;
            this.redisMutexService.lock("lock:position:".concat(positionLevel.getId()));
            String maxName = this.positionRepository.findMaxName(positionLevel.getId());
            int maxNum = 1;
            int item = 0;
            if (StringUtils.isNotBlank((CharSequence)maxName) && StringUtils.isNotBlank((CharSequence)(trim = (m = (p = Pattern.compile(regEx = "[^0-9]")).matcher(maxName)).replaceAll("").trim()))) {
                item = Integer.parseInt(trim);
            }
            maxNum = item + 1;
            positionName = positionLevel.getName() + maxNum;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        finally {
            this.redisMutexService.unlock("lock:position:".concat(positionLevel.getId()));
        }
        return positionName;
    }
}

