/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.local.service.internal;

import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.user.common.service.UserExtentFieldService;
import com.bizunited.platform.user.common.vo.UserExtentFieldVo;
import com.bizunited.platform.user.service.local.entity.UserExtentFieldEntity;
import com.bizunited.platform.user.service.local.repository.UserExtentFieldServiceRepository;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class UserExtentFieldServiceImpl
implements UserExtentFieldService {
    @Autowired
    private UserExtentFieldServiceRepository userExtentFieldServiceRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Transactional
    public List<UserExtentFieldVo> save(List<UserExtentFieldVo> userExtentFieldVos) {
        this.validateUserExtentField(userExtentFieldVos);
        HashSet needInsertUserExtentFields = new HashSet();
        HashSet needUpdateUserExtentFields = new HashSet();
        HashSet needDeleteUserExtentFields = new HashSet();
        HashSet result = new HashSet();
        HashMap<String, UserExtentFieldVo> fieldVoMap = new HashMap<String, UserExtentFieldVo>();
        for (UserExtentFieldVo fieldVo : userExtentFieldVos) {
            fieldVoMap.put(fieldVo.getFieldName(), fieldVo);
        }
        List existUserExtentFields = this.userExtentFieldServiceRepository.findAll();
        Collection userExtentFields = this.nebulaToolkitService.copyCollectionByWhiteList(userExtentFieldVos, UserExtentFieldVo.class, UserExtentFieldEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.nebulaToolkitService.collectionDiscrepancy(userExtentFields, (Collection)existUserExtentFields, UserExtentFieldEntity::getFieldName, needDeleteUserExtentFields, needUpdateUserExtentFields, needInsertUserExtentFields);
        if (!CollectionUtils.isEmpty(needInsertUserExtentFields)) {
            this.userExtentFieldServiceRepository.saveAll(needInsertUserExtentFields);
            result.addAll(needInsertUserExtentFields);
        }
        if (!CollectionUtils.isEmpty(needUpdateUserExtentFields)) {
            for (UserExtentFieldEntity fieldEntity : needUpdateUserExtentFields) {
                UserExtentFieldVo updateField = (UserExtentFieldVo)fieldVoMap.get(fieldEntity.getFieldName());
                fieldEntity.setFieldComment(updateField.getFieldComment());
                fieldEntity.setRequired(updateField.getRequired());
                fieldEntity.setShowSearch(updateField.getShowSearch());
                fieldEntity.setState(updateField.getState());
                this.userExtentFieldServiceRepository.save((Object)fieldEntity);
                result.add(fieldEntity);
            }
        }
        if (!CollectionUtils.isEmpty(needDeleteUserExtentFields)) {
            result.addAll(needDeleteUserExtentFields);
        }
        Collection resultUserExtentFields = this.nebulaToolkitService.copyCollectionByWhiteList(result, UserExtentFieldEntity.class, UserExtentFieldVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)resultUserExtentFields);
    }

    public List<UserExtentFieldVo> findAll() {
        List userExtentFields = this.userExtentFieldServiceRepository.findAll();
        if (CollectionUtils.isEmpty((Collection)userExtentFields)) {
            return Lists.newArrayList();
        }
        Collection userExtentFieldVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)userExtentFields, UserExtentFieldEntity.class, UserExtentFieldVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)userExtentFieldVos);
    }

    private void validateUserExtentField(List<UserExtentFieldVo> userExtentFieldVos) {
        Validate.notEmpty(userExtentFieldVos, (String)"\u914d\u7f6e\u5b57\u6bb5\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        for (UserExtentFieldVo userExtentFieldVo : userExtentFieldVos) {
            Validate.notBlank((CharSequence)userExtentFieldVo.getFieldName(), (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)userExtentFieldVo.getFieldComment(), (String)"\u5b57\u6bb5\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)userExtentFieldVo.getState(), (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)userExtentFieldVo.getShowSearch(), (String)"\u663e\u793a\u6846\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)userExtentFieldVo.getRequired(), (String)"\u662f\u5426\u5fc5\u586b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

