/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.local.service.internal;

import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.common.enums.RbacRelationEnum;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.user.common.service.UserMappingService;
import com.bizunited.platform.user.common.service.userGroup.UserGroupService;
import com.bizunited.platform.user.common.vo.UserGroupVo;
import com.bizunited.platform.user.common.vo.UserMappingVo;
import com.bizunited.platform.user.service.local.entity.UserGroupEntity;
import com.bizunited.platform.user.service.local.repository.UserGroupRepository;
import com.bizunited.platform.user.service.local.repository.UserRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class UserGroupServiceImpl
implements UserGroupService {
    @Autowired
    private UserGroupRepository userGroupRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserMappingService userMappingService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    private static final String ERROR_GROUP_ID = "\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5";
    private static final String ERROR_NOT_FOUND = "\u6ca1\u6709\u8be5\u5de5\u4f5c\u7ec4\uff0c\u8bf7\u68c0\u67e5!!";

    @Transactional
    @NebulaServiceMethod(name="UserGroupService.create", desc="\u521b\u5efa\u4e00\u6761\u6a21\u578b\u4e3aUserGroupVo\u7684\u7528\u6237\u7ec4\u4fe1\u606f", scope=NebulaServiceMethod.ScopeType.WRITE, returnPropertiesFilter="")
    public UserGroupVo create(UserGroupVo userGroup) {
        Validate.notNull((Object)userGroup, (String)"\u5206\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)userGroup.getId()), (String)"\u6dfb\u52a0\u5206\u7ec4\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165\u5206\u7ec4id,\u8bf7\u91cd\u65b0\u6dfb\u52a0!!", (Object[])new Object[0]);
        String groupName = userGroup.getGroupName();
        Validate.notBlank((CharSequence)groupName, (String)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String groupCode = userGroup.getGroupCode();
        Validate.notBlank((CharSequence)groupCode, (String)"\u5206\u7ec4\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)userGroup.getGroupDescription(), (String)"\u5206\u7ec4\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Integer tstatus = (Integer)ObjectUtils.defaultIfNull((Object)userGroup.getTstatus(), (Object)NormalStatusEnum.ENABLE.getStatus());
        userGroup.setTstatus(tstatus);
        UserGroupEntity entity = this.userGroupRepository.findByGroupCode(groupCode);
        Validate.isTrue((null == entity ? 1 : 0) != 0, (String)"\u8be5\u5206\u7ec4\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u5206\u7ec4\u7f16\u53f7", (Object[])new Object[0]);
        UserGroupEntity userGroupEntity = (UserGroupEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)userGroup, UserGroupEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.userGroupRepository.save((Object)userGroupEntity);
        userGroup.setId(userGroupEntity.getId());
        return userGroup;
    }

    @Transactional
    @NebulaServiceMethod(name="UserGroupService.update", desc="\u4fee\u6539\u4e00\u6761\u6a21\u578b\u4e3aUserGroupVo\u7684\u7528\u6237\u7ec4\u4fe1\u606f", scope=NebulaServiceMethod.ScopeType.WRITE, returnPropertiesFilter="")
    public UserGroupVo update(UserGroupVo userGroup) {
        Validate.notNull((Object)userGroup, (String)"\u5206\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String groupId = userGroup.getId();
        Validate.notNull((Object)groupId, (String)ERROR_GROUP_ID, (Object[])new Object[0]);
        Optional op = this.userGroupRepository.findById(groupId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u8be5\u5206\u7ec4\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u5206\u7ec4\u540d", (Object[])new Object[0]);
        UserGroupEntity currentGroup = (UserGroupEntity)((Object)op.get());
        if (!StringUtils.isBlank((CharSequence)userGroup.getGroupName())) {
            currentGroup.setGroupName(userGroup.getGroupName());
        }
        if (!StringUtils.isBlank((CharSequence)userGroup.getGroupDescription())) {
            currentGroup.setGroupDescription(userGroup.getGroupDescription());
        }
        this.userGroupRepository.save((Object)currentGroup);
        return (UserGroupVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentGroup, UserGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public UserGroupVo updateStatus(String groupId) {
        Validate.notNull((Object)groupId, (String)ERROR_GROUP_ID, (Object[])new Object[0]);
        Optional op = this.userGroupRepository.findById(groupId);
        Validate.isTrue((boolean)op.isPresent(), (String)ERROR_NOT_FOUND, (Object[])new Object[0]);
        UserGroupEntity userGroup = (UserGroupEntity)((Object)op.get());
        Integer status = userGroup.getTstatus();
        status = status == 1 ? 0 : 1;
        userGroup.setTstatus(status);
        this.userGroupRepository.save((Object)userGroup);
        return (UserGroupVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)userGroup, UserGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void validateBindUser(UserMappingVo mappingVo, String groupId, String userId) {
        Optional optional = this.userRepository.findById(userId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u6ca1\u6709\u8be5\u7528\u6237[%s],\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
        if (mappingVo == null) {
            long count = this.userGroupRepository.countUserGroup(groupId, userId);
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
        } else {
            long count;
            int bindRelation = mappingVo.getUserGroupRelation();
            if (bindRelation == RbacRelationEnum.MANY_TO_MANY.getRelation()) {
                count = this.userGroupRepository.countUserGroup(groupId, userId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5206\u7ec4\u591a\u5bf9\u591a\uff0c\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
            }
            if (bindRelation == RbacRelationEnum.MANY_TO_ONE.getRelation()) {
                count = this.userGroupRepository.countGroupByUserId(userId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5206\u7ec4\u591a\u5bf9\u4e00\uff0c\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5206\u7ec4\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
            }
            if (bindRelation == RbacRelationEnum.ONE_TO_MANY.getRelation()) {
                count = this.userGroupRepository.countUserByGroupId(groupId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5206\u7ec4\u4e00\u5bf9\u591a\uff0c\u6307\u5b9a\u5206\u7ec4[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u7528\u6237\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{groupId});
            }
            if (bindRelation == RbacRelationEnum.ONE_TO_ONE.getRelation()) {
                long countGroup = this.userGroupRepository.countGroupByUserId(userId);
                Validate.isTrue((countGroup == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5206\u7ec4\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5206\u7ec4\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
                long countUser = this.userGroupRepository.countUserByGroupId(groupId);
                Validate.isTrue((countUser == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5206\u7ec4\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u5206\u7ec4[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u7528\u6237\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{groupId});
            }
        }
    }

    @Transactional
    public void bindUser(String groupId, String[] userIds) {
        Validate.notNull((Object)groupId, (String)ERROR_GROUP_ID, (Object[])new Object[0]);
        Validate.isTrue((userIds != null && userIds.length > 0 ? 1 : 0) != 0, (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff08\u81f3\u5c11\u9700\u8981\u4f20\u5165\u4e00\u4e2a\uff09\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Optional op = this.userGroupRepository.findById(groupId);
        Validate.isTrue((boolean)op.isPresent(), (String)ERROR_NOT_FOUND, (Object[])new Object[0]);
        UserMappingVo mappingVo = this.userMappingService.findOne();
        for (String userId : userIds) {
            this.validateBindUser(mappingVo, groupId, userId);
            this.userGroupRepository.bindUser(groupId, userId);
        }
    }

    @Transactional
    public void unBindUser(String groupId, String[] userIds) {
        Validate.notNull((Object)groupId, (String)ERROR_GROUP_ID, (Object[])new Object[0]);
        Validate.isTrue((userIds != null && userIds.length > 0 ? 1 : 0) != 0, (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff08\u81f3\u5c11\u9700\u8981\u4f20\u5165\u4e00\u4e2a\uff09\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Optional op = this.userGroupRepository.findById(groupId);
        Validate.isTrue((boolean)op.isPresent(), (String)ERROR_NOT_FOUND, (Object[])new Object[0]);
        for (String userId : userIds) {
            Optional optional = this.userRepository.findById(userId);
            Validate.isTrue((boolean)optional.isPresent(), (String)"\u6ca1\u6709\u8be5\u7528\u6237,\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            this.userGroupRepository.unBindUser(groupId, userId);
        }
    }

    @Transactional
    public void reBindUser(String groupId, String[] userIds) {
        Validate.notBlank((CharSequence)groupId, (String)"\u7528\u6237\u4e0e\u7528\u6237\u7ec4\u7684\u91cd\u65b0\u7ed1\u5b9a\u65f6\uff0c\u7528\u6237\u7ec4Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (userIds == null) {
            userIds = new String[]{};
        }
        UserGroupEntity userGroup = this.userGroupRepository.findById(groupId).orElse(null);
        Validate.notNull((Object)((Object)userGroup), (String)ERROR_NOT_FOUND, (Object[])new Object[0]);
        Set<String> existUserIds = this.userGroupRepository.findByGroupId(groupId);
        HashSet<Object> newUserIds = userIds.length == 0 ? new HashSet() : new HashSet<String>(Arrays.asList(userIds));
        Sets.SetView needDelete = Sets.difference(existUserIds, newUserIds);
        Sets.SetView needInsert = Sets.difference(newUserIds, existUserIds);
        for (String userId : needDelete) {
            this.userGroupRepository.unBindUser(groupId, userId);
        }
        UserMappingVo mappingVo = this.userMappingService.findOne();
        for (String userId : needInsert) {
            this.validateBindUser(mappingVo, groupId, userId);
            this.userGroupRepository.bindUser(groupId, userId);
        }
    }

    public UserGroupVo findByCode(String groupCode) {
        if (StringUtils.isBlank((CharSequence)groupCode)) {
            return null;
        }
        UserGroupEntity entity = this.userGroupRepository.findByGroupCode(groupCode);
        if (entity == null) {
            return null;
        }
        return (UserGroupVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, UserGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @NebulaServiceMethod(name="UserGroupService.findDetailsById", desc="\u6839\u636eid\u67e5\u8be2\u7528\u6237\u7ec4\u8be6\u60c5", scope=NebulaServiceMethod.ScopeType.READ, returnPropertiesFilter="roles,users")
    public UserGroupVo findDetailsById(@ServiceMethodParam(name="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        UserGroupEntity userGroupEntity = this.userGroupRepository.findDetailsById(id);
        if (userGroupEntity == null) {
            return null;
        }
        UserGroupVo userGroupVo = (UserGroupVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)userGroupEntity, UserGroupVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"roles", "users"});
        return userGroupVo;
    }

    public Set<UserGroupVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Sets.newHashSet();
        }
        Set<UserGroupEntity> groups = this.userGroupRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(groups)) {
            return Sets.newHashSet();
        }
        Collection ugroups = this.nebulaToolkitService.copyCollectionByWhiteList(groups, UserGroupEntity.class, UserGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet((Iterable)ugroups);
    }

    public Set<UserGroupVo> findByUserId(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Sets.newHashSet();
        }
        Set<UserGroupEntity> userGroups = this.userGroupRepository.findByUserId(userId);
        if (CollectionUtils.isEmpty(userGroups)) {
            return Sets.newHashSet();
        }
        Collection groups = this.nebulaToolkitService.copyCollectionByWhiteList(userGroups, UserGroupEntity.class, UserGroupVo.class, HashSet.class, ArrayList.class, new String[]{"users", "roles"});
        return Sets.newLinkedHashSet((Iterable)groups);
    }

    @NebulaServiceMethod(name="UserGroupService.findByCondition", desc="\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u7ec4\u5217\u8868", scope=NebulaServiceMethod.ScopeType.READ, returnPropertiesFilter="")
    public Page<UserGroupVo> findByCondition(@ServiceMethodParam(name="groupName") String groupName, @ServiceMethodParam(name="groupCode") String groupCode, @ServiceMethodParam(name="tstatus") Integer status, @ServiceMethodParam(name="pageable") Pageable pageable) {
        PageImpl userGroupVoPage;
        Page userGroupPage;
        List userGroupEntitys;
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)groupName)) {
            conditions.put("groupName", groupName);
        }
        if (StringUtils.isNotBlank((CharSequence)groupCode)) {
            conditions.put("groupCode", groupCode);
        }
        if (status != null) {
            conditions.put("status", status);
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (!(userGroupEntitys = (userGroupPage = this.userGroupRepository.queryPage(pageable, conditions)).getContent()).isEmpty()) {
            Collection userGroupVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)userGroupEntitys, UserGroupEntity.class, UserGroupVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            userGroupVoPage = new PageImpl(new ArrayList(userGroupVos), pageable, userGroupPage.getTotalElements());
        } else {
            userGroupVoPage = new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        return userGroupVoPage;
    }

    public UserGroupVo findByGroupName(String groupName) {
        if (StringUtils.isBlank((CharSequence)groupName)) {
            return null;
        }
        UserGroupEntity userGroup = this.userGroupRepository.findByGroupName(groupName);
        if (userGroup == null) {
            return null;
        }
        return (UserGroupVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)userGroup, UserGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<UserGroupVo> findByGroupCodes(List<String> groupCodes) {
        if (CollectionUtils.isEmpty(groupCodes)) {
            return Lists.newArrayList();
        }
        List<UserGroupEntity> userGroups = this.userGroupRepository.findByGroupCodes(groupCodes);
        if (CollectionUtils.isEmpty(userGroups)) {
            return Lists.newArrayList();
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(userGroups, UserGroupEntity.class, UserGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)collection);
    }

    public List<UserGroupVo> findAll() {
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")});
        List entitySet = this.userGroupRepository.findAll(sort);
        if (CollectionUtils.isEmpty((Collection)entitySet)) {
            return Lists.newArrayList();
        }
        Collection groups = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entitySet, UserGroupEntity.class, UserGroupVo.class, HashSet.class, ArrayList.class, new String[]{"users", "roles"});
        return Lists.newArrayList((Iterable)groups);
    }
}

