/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.local.service.internal;

import com.bizunited.platform.common.enums.RbacRelationEnum;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.user.common.service.UserMappingService;
import com.bizunited.platform.user.common.vo.UserMappingVo;
import com.bizunited.platform.user.service.local.entity.UserMappingEntity;
import com.bizunited.platform.user.service.local.repository.UserMappingRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="UserMappingServiceImpl")
public class UserMappingServiceImpl
implements UserMappingService {
    @Autowired
    private UserMappingRepository userMappingRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Transactional
    public UserMappingVo init() {
        List mappings = this.userMappingRepository.findAll();
        if (!CollectionUtils.isEmpty((Collection)mappings)) {
            return (UserMappingVo)this.nebulaToolkitService.copyObjectByWhiteList(mappings.get(0), UserMappingVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        UserMappingEntity mapping = new UserMappingEntity();
        mapping.setUserGroupRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
        mapping.setUserOrgRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
        mapping.setUserPositionRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
        mapping.setOrgPositionRelation(RbacRelationEnum.ONE_TO_MANY.getRelation());
        this.userMappingRepository.save((Object)mapping);
        return (UserMappingVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)mapping, UserMappingVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public UserMappingVo update(UserMappingVo mappingVo) {
        Validate.notBlank((CharSequence)mappingVo.getId(), (String)"\u66f4\u65b0\u65f6\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a!!!", (Object[])new Object[0]);
        UserMappingEntity mapping = this.userMappingRepository.findById(mappingVo.getId()).orElse(null);
        Validate.notNull((Object)((Object)mapping), (String)"\u66f4\u65b0\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01\uff01\uff01", (Object[])new Object[0]);
        if (mappingVo.getUserGroupRelation() != null) {
            mapping.setUserGroupRelation(mappingVo.getUserGroupRelation());
        }
        if (mappingVo.getUserOrgRelation() != null) {
            mapping.setUserOrgRelation(mappingVo.getUserOrgRelation());
        }
        if (mappingVo.getUserPositionRelation() != null) {
            mapping.setUserPositionRelation(mappingVo.getUserPositionRelation());
        }
        if (mappingVo.getOrgPositionRelation() != null) {
            mapping.setOrgPositionRelation(mappingVo.getOrgPositionRelation());
        }
        this.userMappingRepository.save((Object)mapping);
        return (UserMappingVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)mapping, UserMappingVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public UserMappingVo findOne() {
        List mappings = this.userMappingRepository.findAll();
        if (CollectionUtils.isEmpty((Collection)mappings)) {
            return this.init();
        }
        return (UserMappingVo)this.nebulaToolkitService.copyObjectByWhiteList(mappings.get(0), UserMappingVo.class, HashSet.class, ArrayList.class, new String[0]);
    }
}

