/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.service.local.service.internal;

import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.service.user.UserEventListener;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.user.service.local.entity.UserEntity;
import com.bizunited.platform.user.service.local.repository.UserRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.CollectionUtils;

public class UserServiceImpl
implements UserService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    @Qualifier(value="passwordEncoder")
    @Lazy
    private PasswordEncoder passwordEncoder;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<UserEventListener> localUserEventListeners;

    @Transactional
    @NebulaServiceMethod(name="UserService.create", desc="\u521b\u5efa\u4e00\u4e2a\u65b0\u7684UserVo\u6a21\u578b\u5bf9\u8c61\uff08\u5305\u62ec\u4e86\u53ef\u80fd\u7684\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8c03\u7528\u3001\u590d\u6742\u903b\u8f91\u5904\u7406\u7b49\uff09", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.WRITE)
    public UserVo create(UserVo userVo) {
        Validate.notNull((Object)userVo, (String)"\u5fc5\u987b\u4f20\u5165\u8981\u6dfb\u52a0\u7684\u7528\u6237\u4fe1\u606f!", (Object[])new Object[0]);
        String userName = userVo.getUserName();
        String account = userVo.getAccount();
        Validate.notBlank((CharSequence)userName, (String)"\u7528\u6237\u771f\u5b9e\u59d3\u540d\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account, (String)"\u7528\u6237\u8d26\u53f7\u4fe1\u606f\uff08\u53ef\u80fd\u662f\u624b\u673a\u53f7\uff09\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        UserEntity currentUser = this.userRepository.findByAccount(account);
        Validate.isTrue((currentUser == null ? 1 : 0) != 0, (String)"\u8be5\u8d26\u53f7\u4fe1\u606f\u5728\u672c\u5730\u7cfb\u7edf\u4e2d\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u586b\u5199!", (Object[])new Object[0]);
        String phone = userVo.getPhone();
        if (!StringUtils.isBlank((CharSequence)phone)) {
            currentUser = this.userRepository.findByPhone(phone);
            Validate.isTrue((currentUser == null ? 1 : 0) != 0, (String)"\u8be5\u624b\u673a\u4fe1\u606f\u5728\u672c\u4f8b\u7cfb\u7edf\u4e2d\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u586b\u5199!", (Object[])new Object[0]);
        } else {
            userVo.setPhone(null);
        }
        userVo.setCreateTime(new Date());
        userVo.setUseStatus((Integer)ObjectUtils.defaultIfNull((Object)userVo.getUseStatus(), (Object)NormalStatusEnum.ENABLE.getStatus()));
        String password = userVo.getPassword();
        Validate.notBlank((CharSequence)password, (String)"\u5bc6\u7801\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        userVo.setPassword(this.passwordEncoder.encode((CharSequence)password));
        currentUser = (UserEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)userVo, UserEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.userRepository.saveAndFlush((Object)currentUser);
        if (this.localUserEventListeners != null) {
            for (UserEventListener eventListener : this.localUserEventListeners) {
                eventListener.onUserCreated(userVo);
            }
        }
        userVo.setId(currentUser.getId());
        return userVo;
    }

    private void doUpdateNotify(UserVo user) {
        if (this.localUserEventListeners != null) {
            for (UserEventListener eventListener : this.localUserEventListeners) {
                eventListener.onUserUpgraded(user);
            }
        }
    }

    @Transactional
    @NebulaServiceMethod(name="UserService.update", desc="\u4fee\u6539\u4e00\u4e2a\u65b0\u7684UserVo\u6a21\u578b\u5bf9\u8c61\uff08\u5305\u62ec\u4e86\u53ef\u80fd\u7684\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8c03\u7528\u3001\u590d\u6742\u903b\u8f91\u5904\u7406\u7b49\uff09", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.WRITE)
    public UserVo update(UserVo user) {
        Validate.notNull((Object)user, (String)"\u5fc5\u987b\u4f20\u5165\u8981\u4fee\u6539\u7684\u7528\u6237\u4fe1\u606f!", (Object[])new Object[0]);
        String userId = user.getId();
        String userName = user.getUserName();
        String account = user.getAccount();
        Validate.notBlank((CharSequence)userId, (String)"\u4fee\u6539\u65f6\uff0c\u7528\u6237\u6570\u636e\u7684\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)userName, (String)"\u7528\u6237\u771f\u5b9e\u59d3\u540d\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account, (String)"\u7528\u6237\u8d26\u53f7\u4fe1\u606f\uff08\u4e00\u822c\u662f\u624b\u673a\u53f7\uff09\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        UserEntity currentUser = this.userRepository.findByAccount(account);
        Validate.isTrue((currentUser == null || StringUtils.equals((CharSequence)currentUser.getId(), (CharSequence)userId) ? 1 : 0) != 0, (String)"\u8be5\u8d26\u53f7\u4fe1\u606f\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u586b\u5199!", (Object[])new Object[0]);
        String phone = user.getPhone();
        if (!StringUtils.isBlank((CharSequence)phone)) {
            currentUser = this.userRepository.findByPhone(phone);
            Validate.isTrue((currentUser == null || StringUtils.equals((CharSequence)currentUser.getId(), (CharSequence)userId) ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u7535\u8bdd\u4fe1\u606f\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        Optional op = this.userRepository.findById(userId);
        UserEntity oldUser = op.orElse(null);
        Validate.notNull((Object)((Object)oldUser), (String)"\u672a\u627e\u5230\u539f\u59cb\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        oldUser.setEntryTime(user.getEntryTime());
        oldUser.setPhone(phone);
        oldUser.setUserHead(user.getUserHead());
        oldUser.setUserName(userName);
        oldUser.setGender(user.getGender());
        if (user.getUseStatus() != null) {
            oldUser.setUseStatus(user.getUseStatus());
        }
        oldUser.setExtend1(user.getExtend1());
        oldUser.setExtend2(user.getExtend2());
        oldUser.setExtend3(user.getExtend3());
        oldUser.setExtend4(user.getExtend4());
        oldUser.setExtend5(user.getExtend5());
        oldUser.setExtend6(user.getExtend6());
        oldUser.setExtend7(user.getExtend7());
        oldUser.setExtend8(user.getExtend8());
        oldUser.setExtend9(user.getExtend9());
        oldUser.setExtend10(user.getExtend10());
        this.userRepository.save((Object)oldUser);
        this.doUpdateNotify(user);
        return user;
    }

    @Transactional
    @NebulaServiceMethod(name="UserService.updatePassword", desc="\u4fee\u6539\u5bc6\u7801", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.WRITE)
    public UserVo updatePassword(@ServiceMethodParam(name="userId") String userId, @ServiceMethodParam(name="newPassword") String newPassword) {
        Validate.notBlank((CharSequence)userId, (String)"\u4fee\u6539\u5bc6\u7801\u65f6 ,\u7528\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)newPassword, (String)"\u4fee\u6539\u5bc6\u7801\u65f6 ,\u65b0\u7684\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Optional op = this.userRepository.findById(userId);
        UserEntity user = op.orElse(null);
        Validate.notNull((Object)((Object)user), (String)"\u6307\u5b9a\u7684\u7528\u6237\u6ca1\u6709\u88ab\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return this.updatePassword(user, newPassword);
    }

    private UserVo updatePassword(UserEntity user, String newPassword) {
        user.setPassword(this.passwordEncoder.encode((CharSequence)newPassword));
        this.userRepository.saveAndFlush((Object)user);
        UserVo currentUserVo = (UserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)user, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.doUpdateNotify(currentUserVo);
        return currentUserVo;
    }

    @Transactional
    public UserVo updatePassword(String userId, String newPassword, String oldPassword) {
        Validate.notBlank((CharSequence)userId, (String)"\u4fee\u6539\u5bc6\u7801\u65f6 ,\u7528\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)newPassword, (String)"\u4fee\u6539\u5bc6\u7801\u65f6 ,\u65b0\u7684\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)oldPassword, (String)"\u4fee\u6539\u5bc6\u7801\u65f6 ,\u539f\u6709\u7684\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Optional op = this.userRepository.findById(userId);
        UserEntity user = op.orElse(null);
        Validate.notNull((Object)((Object)user), (String)"\u6307\u5b9a\u7684\u7528\u6237\u6ca1\u6709\u88ab\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.passwordEncoder.matches((CharSequence)oldPassword, user.getPassword()), (String)"\u539f\u59cb\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return this.updatePassword(user, newPassword);
    }

    @Transactional
    public void updateLastloginTime(String account) {
        Validate.notBlank((CharSequence)account, (String)"\u4fee\u6539\u6700\u540e\u767b\u5f55\u65f6\u95f4\u65f6 ,\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Date lastloginTime = new Date();
        UserVo cuser = this.findByAccount(account);
        Validate.notNull((Object)cuser, (String)"\u672a\u5728\u672c\u5730\u7cfb\u7edf\u4e2d\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.userRepository.updateLastloginTime(account, lastloginTime);
        this.userRepository.flush();
        this.doUpdateNotify(cuser);
    }

    @Transactional
    public UserVo enabled(String account) {
        Validate.notBlank((CharSequence)account, (String)"\u7528\u6237\u8d26\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        UserVo user = this.findByAccount(account);
        Validate.notNull((Object)user, (String)"\u672a\u627e\u5230\u9700\u8981\u4fee\u6539\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        user.setUseStatus(Integer.valueOf(1));
        UserEntity ruser = (UserEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)user, UserEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.userRepository.saveAndFlush((Object)ruser);
        this.doUpdateNotify(user);
        return user;
    }

    @Transactional
    public UserVo disable(String account) {
        Validate.notBlank((CharSequence)account, (String)"\u7528\u6237\u8d26\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        UserVo user = this.findByAccount(account);
        Validate.notNull((Object)user, (String)"\u672a\u627e\u5230\u9700\u8981\u4fee\u6539\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        user.setUseStatus(Integer.valueOf(0));
        UserEntity ruser = (UserEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)user, UserEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.userRepository.saveAndFlush((Object)ruser);
        this.doUpdateNotify(user);
        return user;
    }

    @NebulaServiceMethod(name="UserService.findDetailsById", desc="\u6839\u636eid\u67e5\u8be2\u660e\u7ec6\u8bb0\u5f55", returnPropertiesFilter="positions,groups,orgs", scope=NebulaServiceMethod.ScopeType.READ)
    public UserVo findDetailsById(@ServiceMethodParam(name="id") String id) {
        OrganizationVo mainOrg;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        UserEntity currentUser = this.userRepository.findDetailsById(id);
        if (currentUser == null) {
            return null;
        }
        UserVo userVo = (UserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentUser, UserVo.class, HashSet.class, ArrayList.class, new String[]{"positions", "orgs", "groups"});
        PositionVo mainPosition = this.positionService.findMainPositionByUserId(id);
        if (mainPosition != null) {
            userVo.setMainPosition(mainPosition.getId());
        }
        if ((mainOrg = this.organizationService.findMainOrgByUserId(id)) != null) {
            userVo.setMainOrg(mainOrg.getId());
        }
        return userVo;
    }

    public UserVo findByAccount(String account) {
        OrganizationVo mainOrg;
        if (StringUtils.isBlank((CharSequence)account)) {
            return null;
        }
        UserEntity currentUser = this.userRepository.findDetailsByAccount(account);
        if (currentUser == null) {
            return null;
        }
        PositionVo mainPosition = this.positionService.findMainPositionByUserId(currentUser.getId());
        UserVo userVo = (UserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentUser, UserVo.class, HashSet.class, ArrayList.class, new String[]{"positions", "orgs"});
        if (mainPosition != null) {
            userVo.setMainPosition(mainPosition.getId());
        }
        if ((mainOrg = this.organizationService.findMainOrgByUserId(currentUser.getId())) != null) {
            userVo.setMainOrg(mainOrg.getId());
        }
        return userVo;
    }

    public List<UserVo> findByAccountLikeOrNameLike(String param) {
        List<UserEntity> accountLike = this.userRepository.findByAccountLike(param);
        List<UserEntity> nameLike = this.userRepository.findByUserNameLike(param);
        ArrayList<UserEntity> total = new ArrayList<UserEntity>();
        total.addAll(accountLike);
        total.addAll(nameLike);
        return total.stream().distinct().map(o -> (UserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)o, UserVo.class, HashSet.class, ArrayList.class, new String[0])).collect(Collectors.toList());
    }

    public UserVo findByUserId(String userId) {
        Validate.notBlank((CharSequence)userId, (String)"\u4f20\u5165\u7684\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        UserEntity user = this.userRepository.findDetailsById(userId);
        if (user == null) {
            return null;
        }
        return (UserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)user, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Set<UserVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Sets.newHashSet();
        }
        Set<UserEntity> users = this.userRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(users)) {
            return Sets.newHashSet();
        }
        return (Set)this.nebulaToolkitService.copyCollectionByWhiteList(users, UserEntity.class, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Set<UserVo> findByOrgId(String orgId) {
        if (StringUtils.isBlank((CharSequence)orgId)) {
            return Sets.newHashSet();
        }
        Set<UserEntity> users = this.userRepository.findByOrgId(orgId);
        if (CollectionUtils.isEmpty(users)) {
            return Sets.newHashSet();
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(users, UserEntity.class, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Sets.newLinkedHashSet((Iterable)collection);
    }

    public UserVo findByPhone(String phone) {
        if (StringUtils.isBlank((CharSequence)phone)) {
            return null;
        }
        UserEntity user = this.userRepository.findByPhone(phone);
        if (user == null) {
            return null;
        }
        return (UserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)user, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Set<UserVo> findByPositionId(String positionId) {
        if (StringUtils.isBlank((CharSequence)positionId)) {
            return null;
        }
        Set<UserEntity> users = this.userRepository.findByPositionId(positionId);
        if (CollectionUtils.isEmpty(users)) {
            return Sets.newHashSet();
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(users, UserEntity.class, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet((Iterable)collection);
    }

    public Page<UserVo> findByConditions(UserVo user, Pageable pageable) {
        PageImpl page;
        Page userPage = this.userRepository.findByConditions(pageable, user);
        List users = userPage.getContent();
        if (!users.isEmpty()) {
            Collection userVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)users, UserEntity.class, UserVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            page = new PageImpl(new ArrayList(userVos), pageable, userPage.getTotalElements());
        } else {
            page = new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        return page;
    }

    @NebulaServiceMethod(name="UserService.findByConditions", desc="\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868", returnPropertiesFilter="positions,groups,orgs,roles", scope=NebulaServiceMethod.ScopeType.READ)
    public Page<UserVo> findByConditions(@ServiceMethodParam(name="pageable") Pageable pageable, InvokeParams invokeParams) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        invokeParams = (InvokeParams)ObjectUtils.defaultIfNull((Object)invokeParams, (Object)new InvokeParams());
        Map params = invokeParams.getInvokeParams();
        UserVo user = (UserVo)JsonUtils.convert((Object)params, UserVo.class);
        return this.findByConditions(user, pageable);
    }

    public List<UserVo> findByAccountAndTypeStruDescendant(String account, Integer type) {
        if (StringUtils.isBlank((CharSequence)account)) {
            return Lists.newArrayList();
        }
        if (Objects.equals(type, new Integer(1)) || Objects.equals(type, new Integer(0))) {
            return this.findByUserAccountAndPositionStrDescendant(account);
        }
        return Lists.newArrayList();
    }

    private List<UserVo> findByUserAccountAndPositionStrDescendant(String account) {
        if (StringUtils.isBlank((CharSequence)account)) {
            return Lists.newArrayList();
        }
        UserEntity userEntity = this.userRepository.findByAccount(account);
        if (userEntity == null) {
            return Lists.newArrayList();
        }
        List positionVos = this.positionService.findByUserIdStruDescendant(userEntity.getId());
        if (CollectionUtils.isEmpty((Collection)positionVos)) {
            return Lists.newArrayList();
        }
        HashSet positionIds = Sets.newHashSet();
        positionVos.forEach(p -> positionIds.add(p.getId()));
        List<UserEntity> userEntities = this.userRepository.findByPositionIds(positionIds);
        if (CollectionUtils.isEmpty(userEntities)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(userEntities, UserEntity.class, UserVo.class, HashSet.class, ArrayList.class, new String[0]));
    }
}

