package com.bizunited.platform.user.service.local.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.util.List;
import java.util.Set;

/**
 * 行政区域
 * @Author: chengzhongxiang
 * @Date: 2020/8/19 15:12
 */
@Entity
@ApiModel(value = "AdministrativeRegionEntity", description = "行政区域")
@Table(name = "engine_administrative_region")
@org.hibernate.annotations.Table(appliesTo = "engine_administrative_region" , comment = "行政区域信息")
public class AdministrativeRegionEntity extends UuidEntity {

  private static final long serialVersionUID = 4731650721553495338L;

  @ApiModelProperty(name = "dimensionalityCode", value = "降维编码", required = true)
  @Column(name = "dimensionality_code", nullable = false, columnDefinition = "varchar(128) COMMENT '降维编码'")
  @SaturnColumn(description = "降维编码")
  private String dimensionalityCode;

  @ApiModelProperty(name = "regionName", value = "区域名称", required = true)
  @Column(name = "region_name", nullable = false, columnDefinition = "varchar(128) COMMENT '区域名称'")
  @SaturnColumn(description = "区域名称")
  private String regionName;

  @ApiModelProperty(name = "regionCode", value = "区域编码", required = true)
  @Column(name = "region_code", nullable = false, columnDefinition = "varchar(128) COMMENT '区域编码'")
  @SaturnColumn(description = "区域编码")
  private String regionCode;

  @ApiModelProperty(name = "longitude", value = "经度", required = true)
  @Column(name = "longitude", nullable = false, columnDefinition = "varchar(128) COMMENT '经度'")
  @SaturnColumn(description = "经度")
  private String longitude;

  @ApiModelProperty(name = "latitude", value = "纬度", required = true)
  @Column(name = "latitude", nullable = false, columnDefinition = "varchar(128) COMMENT '纬度'")
  @SaturnColumn(description = "纬度")
  private String latitude;

  @ApiModelProperty(name = "regionLevel", value = "区域层级", required = true)
  @Column(name = "region_level", nullable = false, columnDefinition = "int(11) COMMENT '区域层级'")
  @SaturnColumn(description = "区域层级")
  private Integer regionLevel;

  @ManyToOne(fetch = FetchType.LAZY, targetEntity = AdministrativeRegionEntity.class)
  @JoinColumn(name = "parent_id",nullable = true, columnDefinition = "varchar(255) COMMENT '父级组织'")
  @SaturnColumn(description="父级区域")
  private AdministrativeRegionEntity parent;

  @ApiModelProperty(name = "email", value = "邮编", required = false)
  @Column(name = "email", nullable = true, columnDefinition = "varchar(128) COMMENT '邮编'")
  @SaturnColumn(description = "邮编")
  private String email;

  @OneToMany(fetch = FetchType.LAZY,  mappedBy="parent")
  @SaturnColumn(description="子级区域")
  private List<AdministrativeRegionEntity> children;

  @SaturnColumn(description="关联的组织机构")
  @ManyToMany(fetch = FetchType.LAZY, mappedBy = "regions")
  private Set<OrganizationEntity> orgs;

  /**
   * 扩展字段1
   */
  @ApiModelProperty(name="extend1", value="扩展字段1", required=false)
  @SaturnColumn(description="扩展字段1")
  @Column(name = "extend1", nullable = true, columnDefinition = "varchar(255) comment '扩展字段1'")
  private String extend1;

  /**
   * 扩展字段2
   */
  @ApiModelProperty(name="extend2", value="扩展字段2", required=false)
  @Column(name = "extend2", nullable = true, columnDefinition = "varchar(255) comment '扩展字段2'")
  @SaturnColumn(description="扩展字段2")
  private String extend2;

  /**
   * 扩展字段3
   */
  @ApiModelProperty(name="extend3", value="扩展字段3", required=false)
  @Column(name = "extend3", nullable = true, columnDefinition = "varchar(255) comment '扩展字段3'")
  @SaturnColumn(description="扩展字段3")
  private String extend3;

  /**
   * 扩展字段4
   */
  @ApiModelProperty(name="extend4", value="扩展字段4", required=false)
  @Column(name = "extend4", nullable = true, columnDefinition = "varchar(255) comment '扩展字段4'")
  @SaturnColumn(description="扩展字段4")
  private String extend4;

  /**
   * 扩展字段5
   */
  @ApiModelProperty(name="extend5", value="扩展字段5", required=false)
  @Column(name = "extend5", nullable = true, columnDefinition = "varchar(255) comment '扩展字段5'")
  @SaturnColumn(description="扩展字段5")
  private String extend5;

  /**
   * 扩展字段6
   */
  @ApiModelProperty(name="extend6", value="扩展字段6", required=false)
  @Column(name = "extend6", nullable = true, columnDefinition = "varchar(255) comment '扩展字段6'")
  @SaturnColumn(description="扩展字段6")
  private String extend6;

  /**
   * 扩展字段7
   */
  @ApiModelProperty(name="extend7", value="扩展字段7", required=false)
  @Column(name = "extend7", nullable = true, columnDefinition = "varchar(255) comment '扩展字段7'")
  @SaturnColumn(description="扩展字段7")
  private String extend7;

  /**
   * 扩展字段8
   */
  @ApiModelProperty(name="extend8", value="扩展字段8", required=false)
  @Column(name = "extend8", nullable = true, columnDefinition = "varchar(255) comment '扩展字段8'")
  @SaturnColumn(description="扩展字段8")
  private String extend8;

  /**
   * 扩展字段9
   */
  @ApiModelProperty(name="extend9", value="扩展字段9", required=false)
  @Column(name = "extend9", nullable = true, columnDefinition = "varchar(255) comment '扩展字段9'")
  @SaturnColumn(description="扩展字段9")
  private String extend9;

  /**
   * 扩展字段10
   */
  @ApiModelProperty(name="extend10", value="扩展字段10", required=false)
  @Column(name = "extend10", nullable = true, columnDefinition = "varchar(255) comment '扩展字段10'")
  @SaturnColumn(description="扩展字段10")
  private String extend10;

  public List<AdministrativeRegionEntity> getChildren() {
    return children;
  }

  public void setChildren(List<AdministrativeRegionEntity> children) {
    this.children = children;
  }

  public String getDimensionalityCode() {
    return dimensionalityCode;
  }

  public void setDimensionalityCode(String dimensionalityCode) {
    this.dimensionalityCode = dimensionalityCode;
  }

  public String getRegionName() {
    return regionName;
  }

  public void setRegionName(String regionName) {
    this.regionName = regionName;
  }

  public String getRegionCode() {
    return regionCode;
  }

  public void setRegionCode(String regionCode) {
    this.regionCode = regionCode;
  }

  public String getLongitude() {
    return longitude;
  }

  public void setLongitude(String longitude) {
    this.longitude = longitude;
  }

  public String getLatitude() {
    return latitude;
  }

  public void setLatitude(String latitude) {
    this.latitude = latitude;
  }

  public Integer getRegionLevel() {
    return regionLevel;
  }

  public void setRegionLevel(Integer regionLevel) {
    this.regionLevel = regionLevel;
  }

  public AdministrativeRegionEntity getParent() {
    return parent;
  }

  public void setParent(AdministrativeRegionEntity parent) {
    this.parent = parent;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public Set<OrganizationEntity> getOrgs() {
    return orgs;
  }

  public void setOrgs(Set<OrganizationEntity> orgs) {
    this.orgs = orgs;
  }

  public String getExtend1() {
    return extend1;
  }

  public void setExtend1(String extend1) {
    this.extend1 = extend1;
  }

  public String getExtend2() {
    return extend2;
  }

  public void setExtend2(String extend2) {
    this.extend2 = extend2;
  }

  public String getExtend3() {
    return extend3;
  }

  public void setExtend3(String extend3) {
    this.extend3 = extend3;
  }

  public String getExtend4() {
    return extend4;
  }

  public void setExtend4(String extend4) {
    this.extend4 = extend4;
  }

  public String getExtend5() {
    return extend5;
  }

  public void setExtend5(String extend5) {
    this.extend5 = extend5;
  }

  public String getExtend6() {
    return extend6;
  }

  public void setExtend6(String extend6) {
    this.extend6 = extend6;
  }

  public String getExtend7() {
    return extend7;
  }

  public void setExtend7(String extend7) {
    this.extend7 = extend7;
  }

  public String getExtend8() {
    return extend8;
  }

  public void setExtend8(String extend8) {
    this.extend8 = extend8;
  }

  public String getExtend9() {
    return extend9;
  }

  public void setExtend9(String extend9) {
    this.extend9 = extend9;
  }

  public String getExtend10() {
    return extend10;
  }

  public void setExtend10(String extend10) {
    this.extend10 = extend10;
  }
}
