package com.bizunited.platform.user.service.local.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.util.Date;
import java.util.Set;

/**
 * 描述业务系统中的组织机构信息
 * @author yinwenjie
 */
@ApiModel(value = "OrganizationEntity", description = "组织机构")
@Entity
@Table(name = "engine_org")
@org.hibernate.annotations.Table(appliesTo = "engine_org" , comment = "描述业务系统中的组织机构信息")
public class OrganizationEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -7899327347113427246L;

  @ApiModelProperty(name="code" , value="组织机构唯一编号", required=true)
  @Column(name="org_code" , length=128 , nullable=false , unique = true , columnDefinition = "varchar(128) COMMENT '组织机构唯一编号'")
  @SaturnColumn(description="组织机构的唯一编号")
  private String code;

  @ApiModelProperty(name = "org_name", value = "组织机构名称", required = true)
  @Column(name = "org_name", length = 64, nullable = false , columnDefinition = "varchar(64) COMMENT '组织机构名称'")
  @SaturnColumn(description = "组织机构名称")
  private String orgName;

  @ApiModelProperty(name = "type", value = "组织机构类型(0:部门,1:单位)", required = true)
  @Column(name = "org_type", nullable = false, columnDefinition = "int(11) COMMENT '组织机构类型(0:部门,1:单位)'")
  @SaturnColumn(description = "组织机构类型")
  private Integer type;

  @ApiModelProperty(name = "description", value = "组织机构描述", required = true)
  @Column(name = "org_desc", nullable = false, length = 512, columnDefinition = "varchar(512) COMMENT '组织机构描述'")
  @SaturnColumn(description = "组织机构描述")
  private String description = "";

  @ApiModelProperty(name = "sortIndex", value = "排序", required = true)
  @Column(name = "org_sort_index", nullable = false, columnDefinition = "int(11) COMMENT '组织机构排序'")
  @SaturnColumn(description = "组织机构排序")
  private Integer sortIndex = 100;

  @ApiModelProperty(name = "createTime", value = "创建时间", required = false)
  @Column(name = "createTime", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime = new Date();
 
  @ApiModelProperty(name = "users", value = "组织机构绑定的用户信息", hidden = true, required = true)
  @ManyToMany(fetch = FetchType.LAZY)
  @JoinTable(name = "engine_org_user_mapping", joinColumns = {@JoinColumn(name = "org_id")}, inverseJoinColumns = {@JoinColumn(name = "user_id")})
  @SaturnColumn(description = "组织机构绑定的用户信息")
  @OrderBy("createTime")
  private Set<UserEntity> users;

  @ApiModelProperty(name = "tstatus", value = "组织机构状态（1正常；0不正常）", required = false)
  @Column(name = "tstatus", nullable = false, columnDefinition = "int(11) COMMENT '组织机构状态'")
  @SaturnColumn(description = "组织机构状态")
  private Integer tstatus;

  @ManyToOne(fetch = FetchType.LAZY, targetEntity = OrganizationEntity.class)
  @JoinColumn(name = "parent_id",nullable = true, columnDefinition = "varchar(255) COMMENT '父级组织'")
  @SaturnColumn(description="父级组织")
  private OrganizationEntity parent;

  @OneToMany(fetch = FetchType.LAZY,  mappedBy="parent")
  @SaturnColumn(description="子级组织")
  private Set<OrganizationEntity> child;

  @OneToMany(fetch = FetchType.LAZY,mappedBy = "organization")
  @SaturnColumn(description = "一对多对应的岗位")
  private Set<PositionEntity> positions;

  @ApiModelProperty(name = "regions", value = "组织机构绑定的行政区域")
  @SaturnColumn(description = "组织机构绑定的行政区域")
  @ManyToMany(fetch = FetchType.LAZY)
  @JoinTable(name = "engine_org_region_mapping", joinColumns = @JoinColumn(name = "org_id"), inverseJoinColumns = @JoinColumn(name = "region_id"))
  @OrderBy("regionCode asc")
  private Set<AdministrativeRegionEntity> regions;

  @ApiModelProperty(name = "isLeaf", value = "是否是叶子节点（1没有；0有）", required = false)
  @Column(name = "is_leaf", nullable = false, columnDefinition = "bit(1) COMMENT '是否是叶子节点'")
  @SaturnColumn(description = "是否是叶子节点")
  private Boolean isLeaf;

  @ApiModelProperty(name = "dimensionalityCode", value = "降维编码", required = false)
  @Column(name = "dimensionality_code", nullable = true, columnDefinition = "varchar(128) COMMENT '降维编码'")
  @SaturnColumn(description = "降维编码")
  private String dimensionalityCode;
  /**
   * 所在层级数
   */
  @ApiModelProperty(name = "level", value = "层级", required = true)
  @Column(name = "level", nullable = true, columnDefinition = "int(11) COMMENT '层级'")
  @SaturnColumn(description = "层级")
  private Integer level;

  @JoinColumn(name = "create_user", nullable = true, columnDefinition = "varchar(255) COMMENT '创建人'")
  @SaturnColumn(description = "创建人")
  private String createUser;

  @ApiModelProperty(name = "updateTime", value = "更新时间", required = false)
  @Column(name = "updateTime", nullable = true, columnDefinition = "varchar(128) COMMENT '更新时间'")
  @SaturnColumn(description = "更新时间")
  private Date updateTime;

  @ApiModelProperty(name = "updateUser", value = "更新人", required = false)
  @Column(name = "update_User", nullable = true, columnDefinition = "varchar(128) COMMENT '更新人'")
  @SaturnColumn(description = "更新人")
  private String updateUser;

  /**
   * 扩展字段1
   */
  @ApiModelProperty(name="extend1", value="扩展字段1", required=false)
  @SaturnColumn(description="扩展字段1")
  @Column(name = "extend1", nullable = true, columnDefinition = "varchar(255) comment '扩展字段1'")
  private String extend1;

  /**
   * 扩展字段2
   */
  @ApiModelProperty(name="extend2", value="扩展字段2", required=false)
  @Column(name = "extend2", nullable = true, columnDefinition = "varchar(255) comment '扩展字段2'")
  @SaturnColumn(description="扩展字段2")
  private String extend2;

  /**
   * 扩展字段3
   */
  @ApiModelProperty(name="extend3", value="扩展字段3", required=false)
  @Column(name = "extend3", nullable = true, columnDefinition = "varchar(255) comment '扩展字段3'")
  @SaturnColumn(description="扩展字段3")
  private String extend3;

  /**
   * 扩展字段4
   */
  @ApiModelProperty(name="extend4", value="扩展字段4", required=false)
  @Column(name = "extend4", nullable = true, columnDefinition = "varchar(255) comment '扩展字段4'")
  @SaturnColumn(description="扩展字段4")
  private String extend4;

  /**
   * 扩展字段5
   */
  @ApiModelProperty(name="extend5", value="扩展字段5", required=false)
  @Column(name = "extend5", nullable = true, columnDefinition = "varchar(255) comment '扩展字段5'")
  @SaturnColumn(description="扩展字段5")
  private String extend5;

  /**
   * 扩展字段6
   */
  @ApiModelProperty(name="extend6", value="扩展字段6", required=false)
  @Column(name = "extend6", nullable = true, columnDefinition = "varchar(255) comment '扩展字段6'")
  @SaturnColumn(description="扩展字段6")
  private String extend6;

  /**
   * 扩展字段7
   */
  @ApiModelProperty(name="extend7", value="扩展字段7", required=false)
  @Column(name = "extend7", nullable = true, columnDefinition = "varchar(255) comment '扩展字段7'")
  @SaturnColumn(description="扩展字段7")
  private String extend7;

  /**
   * 扩展字段8
   */
  @ApiModelProperty(name="extend8", value="扩展字段8", required=false)
  @Column(name = "extend8", nullable = true, columnDefinition = "varchar(255) comment '扩展字段8'")
  @SaturnColumn(description="扩展字段8")
  private String extend8;

  /**
   * 扩展字段9
   */
  @ApiModelProperty(name="extend9", value="扩展字段9", required=false)
  @Column(name = "extend9", nullable = true, columnDefinition = "varchar(255) comment '扩展字段9'")
  @SaturnColumn(description="扩展字段9")
  private String extend9;

  /**
   * 扩展字段10
   */
  @ApiModelProperty(name="extend10", value="扩展字段10", required=false)
  @Column(name = "extend10", nullable = true, columnDefinition = "varchar(255) comment '扩展字段10'")
  @SaturnColumn(description="扩展字段10")
  private String extend10;

  public Date getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(Date updateTime) {
    this.updateTime = updateTime;
  }

  public String getUpdateUser() {
    return updateUser;
  }

  public void setUpdateUser(String updateUser) {
    this.updateUser = updateUser;
  }

  public String getCreateUser() {
    return createUser;
  }

  public void setCreateUser(String createUser) {
    this.createUser = createUser;
  }

  public Integer getLevel() {
    return level;
  }

  public void setLevel(Integer level) {
    this.level = level;
  }

  public String getDimensionalityCode() {
    return dimensionalityCode;
  }

  public void setDimensionalityCode(String dimensionalityCode) {
    this.dimensionalityCode = dimensionalityCode;
  }

  public Boolean getLeaf() {
    return isLeaf;
  }

  public void setLeaf(Boolean leaf) {
    isLeaf = leaf;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getOrgName() {
    return orgName;
  }

  public void setOrgName(String orgName) {
    this.orgName = orgName;
  }

  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Integer getSortIndex() {
    return sortIndex;
  }

  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Set<UserEntity> getUsers() {
    return users;
  }

  public void setUsers(Set<UserEntity> users) {
    this.users = users;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public OrganizationEntity getParent() {
    return parent;
  }

  public void setParent(OrganizationEntity parent) {
    this.parent = parent;
  }

  public Set<OrganizationEntity> getChild() {
    return child;
  }

  public void setChild(Set<OrganizationEntity> child) {
    this.child = child;
  }

  public Set<PositionEntity> getPositions() {
    return positions;
  }

  public void setPositions(Set<PositionEntity> positions) {
    this.positions = positions;
  }

  public Set<AdministrativeRegionEntity> getRegions() {
    return regions;
  }

  public void setRegions(Set<AdministrativeRegionEntity> regions) {
    this.regions = regions;
  }

  public String getExtend1() {
    return extend1;
  }

  public void setExtend1(String extend1) {
    this.extend1 = extend1;
  }

  public String getExtend2() {
    return extend2;
  }

  public void setExtend2(String extend2) {
    this.extend2 = extend2;
  }

  public String getExtend3() {
    return extend3;
  }

  public void setExtend3(String extend3) {
    this.extend3 = extend3;
  }

  public String getExtend4() {
    return extend4;
  }

  public void setExtend4(String extend4) {
    this.extend4 = extend4;
  }

  public String getExtend5() {
    return extend5;
  }

  public void setExtend5(String extend5) {
    this.extend5 = extend5;
  }

  public String getExtend6() {
    return extend6;
  }

  public void setExtend6(String extend6) {
    this.extend6 = extend6;
  }

  public String getExtend7() {
    return extend7;
  }

  public void setExtend7(String extend7) {
    this.extend7 = extend7;
  }

  public String getExtend8() {
    return extend8;
  }

  public void setExtend8(String extend8) {
    this.extend8 = extend8;
  }

  public String getExtend9() {
    return extend9;
  }

  public void setExtend9(String extend9) {
    this.extend9 = extend9;
  }

  public String getExtend10() {
    return extend10;
  }

  public void setExtend10(String extend10) {
    this.extend10 = extend10;
  }
}
