package com.bizunited.platform.user.service.local.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.util.Date;
import java.util.Set;

/**
 * 描述业务系统中的岗位信息
 * @description:
 * @author: yanwe
 * @date: 17/Jan/2019 09:53
 */
@ApiModel(value = "PositionEntity", description = "岗位")
@Entity
@Table(name = "engine_position")
@org.hibernate.annotations.Table(appliesTo = "engine_position" , comment = "描述业务系统中的岗位信息")
public class PositionEntity extends UuidEntity {

  private static final long serialVersionUID = 6180350993871864854L;

  @ApiModelProperty(name = "code", value = "岗位唯一编号", required = true)
  @Column(name = "code", length = 128, nullable = false, unique = true, columnDefinition = "varchar(128) COMMENT '组织机构唯一编号'")
  @SaturnColumn(description = "岗位的唯一编号")
  private String code;

  @ApiModelProperty(name = "name", value = "岗位名称", required = true)
  @Column(name = "name", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '组织机构唯一编号'")
  @SaturnColumn(description = "岗位名称")
  private String name;

  @ManyToOne(fetch = FetchType.LAZY, targetEntity = OrganizationEntity.class)
  @JoinColumn(name = "organization_id", nullable = true, columnDefinition = "varchar(255) COMMENT '组织机构唯一编号'")
  @SaturnColumn(description = "所属组织id")
  private OrganizationEntity organization;

  @ApiModelProperty(name = "users", value = "这个岗位已经绑定的用户信息", hidden = true, required = true)
  @ManyToMany(fetch = FetchType.LAZY)
  @JoinTable(
      name = "engine_position_user_mapping",
      joinColumns = {@JoinColumn(name = "position_id")},
      inverseJoinColumns = {@JoinColumn(name = "user_id")})
  @SaturnColumn(description = "岗位已经绑定的用户信息")
  @OrderBy("createTime")
  private Set<UserEntity> users;

  @ApiModelProperty(name = "tstatus", value = "岗位状态（1正常；0不正常）", required = true)
  @Column(name = "tstatus", nullable = false, columnDefinition = "int(11) COMMENT '岗位状态'")
  @SaturnColumn(description = "岗位状态")
  private Integer tstatus;

  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "createTime", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime = new Date();

  /**
   * 岗位的父级
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "parent_id", columnDefinition = "varchar(255) COMMENT '岗位的父级ID'")
  @ApiModelProperty(name="parent" , value="岗位的父级")
  @SaturnColumn(description="岗位的父级")
  private PositionEntity parent;

  /**
   * 岗位下级
   */
  @OrderBy("createTime desc")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "parent")
  @ApiModelProperty("岗位下级")
  @SaturnColumn(description = "岗位下级")
  private Set<PositionEntity> children;

  /**
   * 所属职级
   */
  @OrderBy("createTime")
  @ManyToOne(fetch=FetchType.LAZY, targetEntity = PositionLevelEntity.class)
  @JoinColumn(name = "position_level_id", nullable = true, columnDefinition = "varchar(255) COMMENT '所属职级'")
  @SaturnColumn(description="所属职级")
  private PositionLevelEntity positionLevel;

  /**
   * 扩展字段1
   */
  @ApiModelProperty(name="extend1", value="扩展字段1", required=false)
  @SaturnColumn(description="扩展字段1")
  @Column(name = "extend1", nullable = true, columnDefinition = "varchar(255) comment '扩展字段1'")
  private String extend1;

  /**
   * 扩展字段2
   */
  @ApiModelProperty(name="extend2", value="扩展字段2", required=false)
  @Column(name = "extend2", nullable = true, columnDefinition = "varchar(255) comment '扩展字段2'")
  @SaturnColumn(description="扩展字段2")
  private String extend2;

  /**
   * 扩展字段3
   */
  @ApiModelProperty(name="extend3", value="扩展字段3", required=false)
  @Column(name = "extend3", nullable = true, columnDefinition = "varchar(255) comment '扩展字段3'")
  @SaturnColumn(description="扩展字段3")
  private String extend3;

  /**
   * 扩展字段4
   */
  @ApiModelProperty(name="extend4", value="扩展字段4", required=false)
  @Column(name = "extend4", nullable = true, columnDefinition = "varchar(255) comment '扩展字段4'")
  @SaturnColumn(description="扩展字段4")
  private String extend4;

  /**
   * 扩展字段5
   */
  @ApiModelProperty(name="extend5", value="扩展字段5", required=false)
  @Column(name = "extend5", nullable = true, columnDefinition = "varchar(255) comment '扩展字段5'")
  @SaturnColumn(description="扩展字段5")
  private String extend5;

  /**
   * 扩展字段6
   */
  @ApiModelProperty(name="extend6", value="扩展字段6", required=false)
  @Column(name = "extend6", nullable = true, columnDefinition = "varchar(255) comment '扩展字段6'")
  @SaturnColumn(description="扩展字段6")
  private String extend6;

  /**
   * 扩展字段7
   */
  @ApiModelProperty(name="extend7", value="扩展字段7", required=false)
  @Column(name = "extend7", nullable = true, columnDefinition = "varchar(255) comment '扩展字段7'")
  @SaturnColumn(description="扩展字段7")
  private String extend7;

  /**
   * 扩展字段8
   */
  @ApiModelProperty(name="extend8", value="扩展字段8", required=false)
  @Column(name = "extend8", nullable = true, columnDefinition = "varchar(255) comment '扩展字段8'")
  @SaturnColumn(description="扩展字段8")
  private String extend8;

  /**
   * 扩展字段9
   */
  @ApiModelProperty(name="extend9", value="扩展字段9", required=false)
  @Column(name = "extend9", nullable = true, columnDefinition = "varchar(255) comment '扩展字段9'")
  @SaturnColumn(description="扩展字段9")
  private String extend9;

  /**
   * 扩展字段10
   */
  @ApiModelProperty(name="extend10", value="扩展字段10", required=false)
  @Column(name = "extend10", nullable = true, columnDefinition = "varchar(255) comment '扩展字段10'")
  @SaturnColumn(description="扩展字段10")
  private String extend10;

  public PositionLevelEntity getPositionLevel() {
    return positionLevel;
  }

  public void setPositionLevel(PositionLevelEntity positionLevel) {
    this.positionLevel = positionLevel;
  }

  public Set<PositionEntity> getChildren() {
    return children;
  }

  public void setChildren(Set<PositionEntity> children) {
    this.children = children;
  }

  public PositionEntity getParent() {
    return parent;
  }

  public void setParent(PositionEntity parent) {
    this.parent = parent;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public OrganizationEntity getOrganization() {
    return organization;
  }

  public void setOrganization(OrganizationEntity organization) {
    this.organization = organization;
  }

  public Set<UserEntity> getUsers() {
    return users;
  }

  public void setUsers(Set<UserEntity> users) {
    this.users = users;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public String getExtend1() {
    return extend1;
  }

  public void setExtend1(String extend1) {
    this.extend1 = extend1;
  }

  public String getExtend2() {
    return extend2;
  }

  public void setExtend2(String extend2) {
    this.extend2 = extend2;
  }

  public String getExtend3() {
    return extend3;
  }

  public void setExtend3(String extend3) {
    this.extend3 = extend3;
  }

  public String getExtend4() {
    return extend4;
  }

  public void setExtend4(String extend4) {
    this.extend4 = extend4;
  }

  public String getExtend5() {
    return extend5;
  }

  public void setExtend5(String extend5) {
    this.extend5 = extend5;
  }

  public String getExtend6() {
    return extend6;
  }

  public void setExtend6(String extend6) {
    this.extend6 = extend6;
  }

  public String getExtend7() {
    return extend7;
  }

  public void setExtend7(String extend7) {
    this.extend7 = extend7;
  }

  public String getExtend8() {
    return extend8;
  }

  public void setExtend8(String extend8) {
    this.extend8 = extend8;
  }

  public String getExtend9() {
    return extend9;
  }

  public void setExtend9(String extend9) {
    this.extend9 = extend9;
  }

  public String getExtend10() {
    return extend10;
  }

  public void setExtend10(String extend10) {
    this.extend10 = extend10;
  }
}
