package com.bizunited.platform.user.service.local.repository.internal;

import com.bizunited.platform.user.service.local.entity.OrganizationEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 组织机构持久化自定义接口实现
 * @Author: Paul Chan
 * @Date: 2020-06-02 10:06
 */
@Repository("OrganizationRepositoryImpl")
public class OrganizationRepositoryImpl implements OrganizationRepositoryCustom {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;

  @Override
  @SuppressWarnings("unchecked")
  public List<OrganizationEntity> findAllByConditions(Map<String, Object> parameters) {
    StringBuilder hql = new StringBuilder("select o from OrganizationEntity o left join fetch o.parent o_parent where 1=1");
    Map<String, Object> parameter = new HashMap<>();
    if(parameters != null) {
      String id = (String) parameters.get("id");
      if(StringUtils.isNotBlank(id)) {
        hql.append(" AND o.id = :id");
        parameter.put("id", id);
      }
      String parentId = (String) parameters.get("parentId");
      if(StringUtils.isNotBlank(parentId)) {
        hql.append(" AND o.parent.id = :parentId");
        parameter.put("parentId", parentId);
      }
      String code = (String) parameters.get("code");
      if(StringUtils.isNotBlank(code)) {
        hql.append(" AND o.code = :code");
        parameter.put("code", code);
      }
      String orgName = (String) parameters.get("orgName");
      if(StringUtils.isNotBlank(orgName)) {
        hql.append(" AND o.orgName like CONCAT('%',:orgName,'%')");
        parameter.put("orgName", orgName);
      }
      Integer tstatus = (Integer) parameters.get("tstatus");
      if(tstatus != null) {
        hql.append(" AND o.tstatus = :tstatus");
        parameter.put("tstatus", tstatus);
      }
    }
    Query query = entityManager.createQuery(hql.toString());
    parameter.forEach((k, v) -> query.setParameter(k, v));
    return query.getResultList();
  }
}
