package com.bizunited.platform.user.service.local.repository.internal;

import com.bizunited.platform.user.common.vo.PositionSimpleVo;
import com.bizunited.platform.user.service.local.entity.PositionEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import java.util.Map;

/**
 * PositionRepositoryCustom
 *
 * @description:
 * @author: yanwe
 * @date: 18/Jan/2019 15:15
 */
@Repository("PositionRepositoryCustom")
public interface PositionRepositoryCustom {

  /**
   * 分页条件查询
   * @param pageable
   * @param conditions
   * @return
   */
  Page<PositionEntity> queryPage(Pageable pageable, Map<String, Object> conditions);

  /**
   * 分页条件查询，根据职位带出用户以及拓展信息
   * @param pageable
   * @param conditions
   * @return
   */
  Page<PositionSimpleVo> findByPositionLevelAndConditions(Pageable pageable, Map<String, Object> conditions);
}
