/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.venus.web.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.venus.common.service.document.DocumentService;
import com.bizunited.platform.venus.common.vo.DocumentVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/venus/documents"})
public class DocumentController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentController.class);
    @Autowired
    private DocumentService documentService;

    @ApiOperation(value="\u65b0\u5efa\u6587\u6863")
    @PostMapping(value={""})
    public ResponseModel create(@RequestBody @ApiParam(name="documentVo", value="\u65b0\u5efa\u6587\u6863\u65f6\u5fc5\u987b\u81f3\u5c11\u5305\u62ec\u6587\u6863\u6807\u9898\u3001\u6587\u6863\u6392\u5e8f\u7b49\u4fe1\u606f\uff0c\u5982\u679c\u6709\u6587\u6863\u7236\u8282\u70b9id\u5219\u5fc5\u987b\u4f20\u5165") DocumentVo documentVo) {
        try {
            Principal principal = this.getPrincipal();
            DocumentVo result = this.documentService.create(documentVo, principal);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6587\u6863")
    @PatchMapping(value={""})
    public ResponseModel update(@RequestBody @ApiParam(name="documentVo", value="\u4fdd\u5b58\u65f6\u5fc5\u987b\u81f3\u5c11\u5305\u62ec\u5f53\u524d\u6587\u6863id\u3001\u6587\u6863\u6807\u9898\u3001\u6587\u6863\u6392\u5e8f\u7b49\u4fe1\u606f\uff0c\u5982\u679c\u6709\u6587\u6863\u7236\u8282\u70b9id\u5219\u5fc5\u987b\u4f20\u5165") DocumentVo documentVo) {
        try {
            Principal principal = this.getPrincipal();
            DocumentVo result = this.documentService.update(documentVo, principal);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6811")
    @GetMapping(value={"findTree"})
    public ResponseModel findTree() {
        try {
            Set tree = this.documentService.findTree();
            return this.buildHttpResult(tree);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5220\u9664\u6587\u6863\uff0c\u8be5\u6587\u6863\u4e0b\u82e5\u6709\u5b50\u6587\u6863\u5219\u4e00\u5e76\u5220\u9664")
    @DeleteMapping(value={"/deleteById"})
    public ResponseModel deleteById(@RequestParam(value="id") @ApiParam(value="\u6587\u6863\u4e3b\u952eid", required=true) String id) {
        try {
            this.documentService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8bfb\u53d6\u5185\u5bb9")
    @GetMapping(value={"/findDetailsById"})
    public ResponseModel findDetailsById(@RequestParam(value="id") @ApiParam(value="\u4e3b\u952e", required=true) String id) {
        try {
            DocumentVo content = this.documentService.findDetailsById(id);
            return this.buildHttpResultW(content, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByKeyword"})
    @ApiOperation(value="\u6839\u636e\u5173\u952e\u5b57\u67e5\u8be2\u6587\u6863")
    public ResponseModel findByKeyword(@RequestParam(required=false) @ApiParam(value="\u641c\u7d22\u5173\u952e\u5b57") String keyword) {
        try {
            List documents = this.documentService.findByKeyword(keyword);
            return this.buildHttpResult(documents);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"export"})
    @ApiOperation(value="\u5bfc\u51fa\u6587\u6863\u6570\u636e")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] result = this.documentService.export();
            if (result == null || result.length == 0) {
                throw new IllegalArgumentException("\u6ca1\u6709\u4efb\u4f55\u4e0b\u8f7d\u4fe1\u606f\uff0c\u5f88\u5927\u51e0\u7387\u539f\u56e0\u662f\u5bfc\u51fa\u903b\u8f91\u51fa\u73b0\u9519\u8bef!!");
            }
            String fileName = StringUtils.join((Object[])new String[]{UUID.randomUUID().toString(), ".zip"});
            this.writeResponseFile(request, response, result, fileName);
        }
        catch (RuntimeException e) {
            super.printResponseModel(super.buildHttpResultForException((Throwable)e), response);
        }
    }

    @PostMapping(value={"importDoc"})
    @ApiOperation(value="\u5bfc\u5165\u6587\u6863\u6570\u636e")
    public ResponseModel importDoc(@RequestParam @ApiParam(value="\u538b\u7f29\u6587\u4ef6") MultipartFile file) {
        try {
            this.documentService.importDoc(file);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

