package com.bizunited.platform.venus.common.service.document;

import com.bizunited.platform.venus.common.vo.DocumentVo;
import org.springframework.web.multipart.MultipartFile;

import java.security.Principal;
import java.util.List;
import java.util.Set;

/**
 * 文档服务接口
 * @author: pangdajin
 * @date: 2020-04-07 16:53
 **/
public interface DocumentService {

  /**
   * 保存文档
   * @param documentVo
   * @param principal
   * @return
   */
  DocumentVo create(DocumentVo documentVo, Principal principal);

  /**
   * 修改文档
   * @param documentVo
   * @param principal
   */
  DocumentVo update (DocumentVo documentVo, Principal principal);


  /**
   * 删除文档，该文档下若有子文档则一并删除
   * @param id
   * @return
   */
  void deleteById(String id);

  /**
   * 读取内容
   * @param id
   */
  DocumentVo findDetailsById(String id);

  /**
   * 查询树
   * @return
   */
  Set<DocumentVo> findTree();

  /**
   * 根据关键字查询文档，支持模糊
   * @return
   */
  List<DocumentVo> findByKeyword(String keyword);

  /**
   * 导出文档数据
   * @return
   */
  byte[] export();

  /**
   * 导入文档数据
   * @param file
   */
  void importDoc(MultipartFile file);
}
