package com.bizunited.platform.venus.common.vo;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 普通文件附件、图片附件的记录信息
 * @author yinwenjie 
 */
@ApiModel(value = "OrdinaryFileVo" , description=" 普通文件附件、图片附件的记录信息")
public class OrdinaryFileVo extends UuidVo {
  /**
   *
   */
  private static final long serialVersionUID = -5037551559571438647L;
  /**
   * 文件的上传者
   */
  @ApiModelProperty(name="commitUser" , value="文件的上传者" , required=false)
  @SaturnColumn(description="文件的上传者")
  private String commitUser;
  /**
   * 重命名后的文件名字
   */
  @ApiModelProperty(name="fileName" , value="重命名后的文件名字" , required=false)
  @SaturnColumn(description="重命名后的文件名字")
  private String fileName;
  /**
   * 重命名前的文件名字
   */
  @ApiModelProperty(name="originalFileName" , value="重命名前的文件名字" , required=false)
  @SaturnColumn(description="重命名前的文件名字")
  private String originalFileName;
  /**
   * 文件在本地的存储目录（相对位置，不包括）<br>
   */
  @ApiModelProperty(name="relativeLocal" , value="文件在本地的存储目录（相对位置，不包括）" , required=false)
  @SaturnColumn(description="文件在本地的存储目录")
  private String relativeLocal;
  /**
   * 文件的扩展类型，例如：png、gif、jpg等
   */
  @ApiModelProperty(name="prefix" , value="文件的扩展类型，例如：png、gif、jpg等" , required=false)
  @SaturnColumn(description="文件的扩展类型")
  private String prefix;
  /**
   * 文件有效期截止，默认为3999-01-01 00:00:00
   */
  @ApiModelProperty(name="effectiveDate" , value="文件有效期截止" , required=false)
  @SaturnColumn(description="文件有效期截止")
  private Date effectiveDate;
  /**
   * 创建时间
   */
  @ApiModelProperty(name="createDate" , value="创建时间" , required=true)
  @SaturnColumn(description="创建时间")
  private Date createDate = new Date();

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }
  public String getCommitUser() {
    return commitUser;
  }
  public void setCommitUser(String commitUser) {
    this.commitUser = commitUser;
  }
  public String getFileName() {
    return fileName;
  }
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }
  public String getOriginalFileName() {
    return originalFileName;
  }
  public void setOriginalFileName(String originalFileName) {
    this.originalFileName = originalFileName;
  }
  public String getPrefix() {
    return prefix;
  }
  public void setPrefix(String prefix) {
    this.prefix = prefix;
  }
  public Date getCreateDate() {
    return createDate;
  }
  public void setCreateDate(Date createDate) {
    this.createDate = createDate;
  }
  public String getRelativeLocal() {
    return relativeLocal;
  }
  public void setRelativeLocal(String relativeLocal) {
    this.relativeLocal = relativeLocal;
  }
  public Date getEffectiveDate() {
    return effectiveDate;
  }
  public void setEffectiveDate(Date effectiveDate) {
    this.effectiveDate = effectiveDate;
  }
}
