package com.bizunited.platform.venus.common.service.image;

import com.bizunited.platform.venus.common.vo.OrdinaryFileVo;
import org.springframework.web.multipart.MultipartFile;

import java.util.Date;
import java.util.List;

/**
 * TODO 向外部提供服务的文件上传服务，其依赖内聚性较低，代码重复度较高，需要尽快调整
 * @author yinwenjie
 */
public interface FileUpdateService {
  /**
   * 文件上传服务，这个文件不一定是图片，只要满足配置信息中规定后缀的文件都可以上传，注意这些文件的有效期为永久。
   * 如果要更改文件有效时间，则需要指定effective参数，该参数是指定文件有效时长，单位为“天”
   * @param subsystem 指代进行文件上传的子系统信息，子系统将单独生成一个文件夹。
   * @param creator 创建人
   * @param effective 这些文件的有效时长，单位为“天”。如果没有传入则默认这些文件有效期为永久
   * @param files 多个文件的描述信息
   * @return 
   * @throws IllegalArgumentException
   */
  public List<OrdinaryFileVo> fileUpload(String subsystem, String creator, Integer effective, MultipartFile[] files);
  /**
   * 文件上传服务，这个文件不一定是图片，只要满足配置信息中规定后缀的文件都可以上传，注意这些文件的有效期为永久。
   * 如果要更改文件有效时间，则需要指定effective参数，该参数是指定文件有效时长，单位为“天”</p>
   * 并且上传的文件内容为base64编码
   * @param subsystem 指代进行文件上传的子系统信息，子系统将单独生成一个文件夹。
   * @param creator 创建人
   * @param effective 这些文件的有效时长，单位为“天”。如果没有传入则默认这些文件有效期为永久
   * @param fileNanmes 文件上传时的文件名
   * @param base64Contents 文件内容的base64编码描述
   * @return
   * @throws IllegalArgumentException
   */
  public List<OrdinaryFileVo> fileUpload(String subsystem, String creator, Integer effective, String[] fileNanmes, String[] base64Contents);
  /**
   * 按照当前指定的时间点，查询文件有效时间小于这个时间点所有文件信息
   * @param currentDate 当前指定的时间点
   * @return
   */
  public List<OrdinaryFileVo> findByEffectiveDate(Date currentDate);
  /**
   * 将指定文件的有效期设置为“永久”，实际上有效期截止时间将设置为3999-01-01 00:00:00
   * @param fileReNames 文件信息是文件存储的相对路径 + 重命名后的文件名。例如/file/20190402/3/e18ab4f4-9fad-46c7-9754-fdfc3f08c488.jpg
   */
  public void updateEffective(String[] fileReNames);
  
  /**
   * 删除指定文件编号下的文件信息，包括数据库信息和文件信息
   * @param fileIds
   */
  public void deleteFiles(String[] fileIds);
  /**
   * 删除指定的文件，包括数据库信息和文件信息
   * @param filePath
   * @param fileName
   */
  void deleteFile(String filePath, String fileName);
  /**
   * 图片上传服务，图片上传只能支持格式为：bmp、jpg、jpeg、gif、png格式的文件才能上传
   * @param subsystem 指代进行图片上传的子系统信息，子系统将单独生成一个文件夹。利于管理
   * @param creator 创建人
   * @param effective 这些文件的有效时长，单位为“天”。如果没有传入则默认这些文件有效期为永久
   * @param files 多个文件的描述信息
   * @return
   * @throws IllegalArgumentException
   */
  public List<OrdinaryFileVo> fileImageUpload(String subsystem , String creator, Integer effective, MultipartFile[] files);
  /**
   * 图片上传服务，图片上传只能支持格式为：bmp、jpg、jpeg、gif、png格式的文件才能上传
   * @param subsystem 指代进行图片上传的子系统信息，子系统将单独生成一个文件夹。利于管理
   * @param creator 创建人
   * @param effective 这些文件的有效时长，单位为“天”。如果没有传入则默认这些文件有效期为永久
   * @param fileNanmes 文件上传时的文件名
   * @param base64Contents 文件内容的base64编码描述
   * @return
   */
  public List<OrdinaryFileVo> fileImageUpload(String subsystem , String creator, Integer effective, String[] fileNanmes , String[] base64Contents);
}