package com.bizunited.platform.venus.common.vo;

import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.Set;

/**
 * 文档VO模型
 * @author: pangdajin
 * @date: 2020-04-07 16:57
 **/
public class DocumentVo extends UuidVo {

  private static final long serialVersionUID = 6217932224755544736L;

  /**
   *父级文档id
   */
  @ApiModelProperty("父级文档")
  @SaturnColumn(description = "父级文档")
  private DocumentVo parent;

  /**
   * 标题
   */
  @ApiModelProperty("标题")
  @SaturnColumn(description = "标题")
  private String title;

  /**
   * 排序，升序排序,，默认设置靠后的值
   */
  @ApiModelProperty("排序，升序排序")
  @SaturnColumn(description = "排序，升序排序")
  private Integer sort;

  /**
   * 创建人账号
   */
  @ApiModelProperty("创建人账号")
  @SaturnColumn(description = "创建人账号")
  private String creator;

  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  @SaturnColumn(description = "创建时间")
  private Date createTime;

  /**
   * 更新人账号
   */
  @ApiModelProperty("更新人账号")
  @SaturnColumn(description = "更新人账号")
  private String modifier;

  /**
   * 最后更新时间
   */
  @ApiModelProperty("最后更新时间")
  @SaturnColumn(description = "最后更新时间")
  private Date modifyTime;

  /**
   * 文档内容
   */
  @ApiModelProperty("文档内容")
  @SaturnColumn(description = "文档内容")
  private String content;

  /**
   * 文件在本地的存储目录（相对位置，不包括）<br>
   */
  @ApiModelProperty(name="relativeLocal" , value="文件在本地的存储目录（相对位置，不包括）" , required= false)
  @SaturnColumn(description="文件在本地的存储目录")
  private String relativeLocal;

  /**
   * 重命名后的文件名字
   */
  @ApiModelProperty(name="fileName" , value="重命名后的文件名字" , required=false)
  @SaturnColumn(description="重命名后的文件名字")
  private String fileName;
  
  @ApiModelProperty("子级文档")
  @SaturnColumn(description = "子级文档")
  @SaturnColumnRelation(type= SaturnColumnRelation.RelationType.OneToMany)
  private Set<DocumentVo> documents;

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @SaturnColumn(description = "工程名")
  private String projectName = ApplicationContextUtils.getProjectName();


  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public Integer getSort() {
    return sort;
  }

  public void setSort(Integer sort) {
    this.sort = sort;
  }

  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public Set<DocumentVo> getDocuments() {
    return documents;
  }

  public void setDocuments(Set<DocumentVo> documents) {
    this.documents = documents;
  }

  public DocumentVo getParent() {
    return parent;
  }

  public void setParent(DocumentVo parent) {
    this.parent = parent;
  }

  public String getCreator() {
    return creator;
  }

  public void setCreator(String creator) {
    this.creator = creator;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public String getModifier() {
    return modifier;
  }

  public void setModifier(String modifier) {
    this.modifier = modifier;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }

  public String getRelativeLocal() {
    return relativeLocal;
  }

  public void setRelativeLocal(String relativeLocal) {
    this.relativeLocal = relativeLocal;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }
}
