/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.venus.service.feign;

import com.bizunited.platform.common.configuration.FeignSupportConfig;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.interceptor.FeignRequestInterceptor;
import com.bizunited.platform.venus.service.feign.fallback.FileFeignClientFallback;
import feign.Response;
import java.util.Date;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@FeignClient(qualifier="FileFeignClient", name="${venus.application.name}", path="/v1/venus/files", fallback=FileFeignClientFallback.class, configuration={FeignRequestInterceptor.class, FeignSupportConfig.class})
public interface FileFeignClient {
    @PatchMapping(value={"/updatePermanentEffective"})
    public ResponseModel updatePermanentEffective(@RequestParam(name="fileNanmes") String[] var1);

    @PostMapping(value={"/{subsystem}/fileUpload"}, consumes={"multipart/form-data"})
    public ResponseModel fileUpload(@PathVariable(name="subsystem") String var1, @RequestParam(name="effective") Integer var2, @RequestPart(name="file") MultipartFile[] var3);

    @PostMapping(value={"/{subsystem}/fileUploadBase64"})
    public ResponseModel fileUpload(@RequestParam(name="subsystem") String var1, @RequestParam(name="effective") Integer var2, @RequestParam(name="fileNanmes") String[] var3, @RequestParam(name="base64Contents") String[] var4);

    @PostMapping(value={"/{subsystem}/fileImageUpload"}, consumes={"multipart/form-data"})
    public ResponseModel fileImageUpload(@PathVariable(name="subsystem") String var1, @RequestParam(name="effective") Integer var2, @RequestPart(name="file") MultipartFile[] var3);

    @PostMapping(value={"/{subsystem}/fileImageUploadBase64"})
    public ResponseModel fileImageUpload(@RequestParam(value="subsystem") String var1, @RequestParam(name="effective") Integer var2, @RequestParam(name="fileNames") String[] var3, @RequestParam(name="base64Contents") String[] var4);

    @GetMapping(value={"/fileQuery"})
    public Response fileQuery(@RequestParam(value="relativeLocal") String var1, @RequestParam(value="fileName") String var2);

    @GetMapping(value={"findByFileNameAndRelativeLocal"})
    public ResponseModel findByFileNameAndRelativeLocal(@RequestParam(value="fileName") String var1, @RequestParam(value="relativeLocal") String var2);

    @GetMapping(value={"findByEffectiveDate"})
    public ResponseModel findByEffectiveDate(@RequestParam(value="date") @DateTimeFormat(pattern="yyyy-MM-dd") Date var1);

    @DeleteMapping(value={"deleteFiles"})
    public ResponseModel deleteFiles(@RequestParam(value="fileIds") String[] var1);

    @DeleteMapping(value={"deleteFile"})
    public ResponseModel deleteFile(@RequestParam(value="filePath") String var1, @RequestParam(value="fileName") String var2);

    @PostMapping(value={"saveFile"}, consumes={"multipart/form-data"})
    public ResponseModel saveFile(@RequestParam(value="relativePath") String var1, @RequestParam(value="fileName") String var2, @RequestParam(value="fileRename") String var3, @RequestPart(value="file") MultipartFile var4);

    @DeleteMapping(value={"deleteFileByFileRename"})
    public ResponseModel deleteFile(@RequestParam(value="relativePath") String var1, @RequestParam(value="fileName") String var2, @RequestParam(value="fileRename") String var3);

    @GetMapping(value={"readFileContent"})
    public Response readFileContent(@RequestParam(value="relativePath") String var1, @RequestParam(value="fileRename") String var2);
}

