/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.venus.service.feign.service.internal;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.FileUtils;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import com.bizunited.platform.venus.service.feign.FileFeignClient;
import feign.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.Validate;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

public class VenusFileServiceSimpleImpl
implements VenusFileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VenusFileServiceSimpleImpl.class);
    @Autowired
    private FileFeignClient fileFeignClient;

    public void saveFile(String relativePath, String fileName, String fileRename, byte[] fileContext) {
        Validate.notNull((Object)fileContext, (String)"\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        try (ByteArrayInputStream is = new ByteArrayInputStream(fileContext);){
            MockMultipartFile file = new MockMultipartFile("file", fileName, ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)is);
            ResponseModel response = this.fileFeignClient.saveFile(relativePath, fileName, fileRename, (MultipartFile)file);
            Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25");
        }
    }

    public void deleteFile(String relativePath, String fileName, String fileRename) {
        this.fileFeignClient.deleteFile(relativePath, fileName, fileRename);
    }

    public byte[] readFileContent(String relativePath, String fileRename) {
        Response response = this.fileFeignClient.readFileContent(relativePath, fileRename);
        byte[] bytes = new byte[]{};
        try {
            bytes = FileUtils.readByte((Response)response);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return bytes;
    }
}

